/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.util;

import net.mehvahdjukaar.supplementaries.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.common.CommonUtil;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.PotionUtils;
import net.minecraft.state.IProperty;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColors;

public class LiquidHolder {
    private World world;
    private BlockPos pos;
    public int color = 0xFFFFFF;
    public float liquidLevel = 0.0f;
    public CommonUtil.JarLiquidType liquidType = CommonUtil.JarLiquidType.EMPTY;

    public LiquidHolder(World world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
    }

    public void setWorldAndPos(World world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
    }

    public void read(CompoundNBT compound) {
        if (compound.func_74764_b("LiquidHolder")) {
            CompoundNBT cmp = compound.func_74775_l("LiquidHolder");
            this.liquidLevel = cmp.func_74760_g("Level");
            this.color = cmp.func_74762_e("Color");
            this.liquidType = CommonUtil.JarLiquidType.values()[cmp.func_74762_e("Type")];
        }
    }

    public CompoundNBT write(CompoundNBT compound) {
        if (this.liquidType != CommonUtil.JarLiquidType.EMPTY) {
            CompoundNBT cmp = new CompoundNBT();
            cmp.func_74768_a("Color", this.color);
            cmp.func_74776_a("Level", this.liquidLevel);
            cmp.func_74768_a("Type", this.liquidType.ordinal());
            compound.func_218657_a("LiquidHolder", (INBT)cmp);
        }
        return compound;
    }

    public int updateClientWaterColor() {
        this.color = BiomeColors.func_228363_c_((ILightReader)this.world, (BlockPos)this.pos);
        return this.color;
    }

    public void updateLiquid(ItemStack stack) {
        this.liquidType = CommonUtil.getJarContentTypeFromItem(stack);
        this.liquidLevel = this.liquidType.isFish() ? 0.625f : (float)stack.func_190916_E() / (float)ServerConfigs.cached.JAR_CAPACITY * 0.75f;
        this.color = this.liquidType.isWater() ? -1 : (this.liquidType == CommonUtil.JarLiquidType.POTION ? PotionUtils.func_190932_c((ItemStack)stack) : this.liquidType.color);
        if (!this.world.field_72995_K) {
            int light = this.liquidType.getLightLevel();
            BlockState state = this.world.func_180495_p(this.pos);
            if ((Integer)state.func_177229_b((IProperty)BlockProperties.LIGHT_LEVEL_0_15) != light) {
                this.world.func_175656_a(this.pos, (BlockState)state.func_206870_a((IProperty)BlockProperties.LIGHT_LEVEL_0_15, (Comparable)Integer.valueOf(light)));
            }
        }
    }
}

