/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.util;

import java.util.Objects;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.block.tiles.SignPostBlockTile;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;

public class MapPost {
    public final BlockPos pos;
    @Nullable
    public final ITextComponent name;

    public MapPost(BlockPos pos, @Nullable ITextComponent name) {
        this.pos = pos;
        this.name = name;
    }

    public static MapPost read(CompoundNBT nbt) {
        BlockPos blockpos = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("Pos"));
        ITextComponent itextcomponent = nbt.func_74764_b("Name") ? ITextComponent.Serializer.func_150699_a((String)nbt.func_74779_i("Name")) : null;
        return new MapPost(blockpos, itextcomponent);
    }

    @Nullable
    public static MapPost fromWorld(IBlockReader reader, BlockPos pos) {
        TileEntity tileentity = reader.func_175625_s(pos);
        if (tileentity instanceof SignPostBlockTile) {
            SignPostBlockTile te = (SignPostBlockTile)tileentity;
            StringTextComponent t = new StringTextComponent("");
            if (te.up) {
                t = te.textHolder.signText[0];
            }
            if (te.down && t.getString().isEmpty()) {
                t = te.textHolder.signText[1];
            }
            if (t.getString().isEmpty()) {
                t = null;
            }
            return new MapPost(pos, (ITextComponent)t);
        }
        return null;
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (p_equals_1_ != null && this.getClass() == p_equals_1_.getClass()) {
            MapPost mapbanner = (MapPost)p_equals_1_;
            return Objects.equals(this.pos, mapbanner.pos) && Objects.equals(this.name, mapbanner.name);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.pos, this.name);
    }

    public CompoundNBT write() {
        CompoundNBT compoundnbt = new CompoundNBT();
        compoundnbt.func_218657_a("Pos", (INBT)NBTUtil.func_186859_a((BlockPos)this.pos));
        if (this.name != null) {
            compoundnbt.func_74778_a("Name", ITextComponent.Serializer.func_150696_a((ITextComponent)this.name));
        }
        return compoundnbt;
    }

    public String getId() {
        return "post-" + this.pos.func_177958_n() + "," + this.pos.func_177956_o() + "," + this.pos.func_177952_p();
    }
}

