/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.util;

import java.lang.reflect.Field;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.block.BlockProperties;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.passive.ParrotEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class MobHolder {
    private final Random rand = new Random();
    private World world;
    private BlockPos pos;
    public boolean entityChanged = true;
    public CompoundNBT entityData = null;
    public MobHolderType animationType = MobHolderType.DEFAULT;
    public UUID uuid = null;
    public float yOffset = 1.0f;
    public float scale = 1.0f;
    public String name;
    public LivingEntity mob = null;
    public float jumpY = 0.0f;
    public float prevJumpY = 0.0f;
    public float yVel = 0.0f;

    public MobHolder(World world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
    }

    public void setWorldAndPos(World world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
    }

    public void setPartying(BlockPos pos, boolean isPartying) {
        if (this.mob != null) {
            this.mob.func_191987_a(pos, isPartying);
        }
    }

    public void read(CompoundNBT compound) {
        if (compound.func_74764_b("jar_mob")) {
            this.entityData = compound.func_74775_l("jar_mob");
            this.entityChanged = true;
            this.scale = 0.15f;
            this.yOffset = 0.0f;
            this.animationType = MobHolderType.DEFAULT;
            this.name = "reload needed";
        }
        if (compound.func_74764_b("animation_type")) {
            this.animationType = MobHolderType.values()[compound.func_74762_e("animation_type")];
        }
        if (compound.func_74764_b("scale")) {
            this.scale = compound.func_74760_g("scale");
        }
        if (compound.func_74764_b("MobHolder")) {
            CompoundNBT cmp = compound.func_74775_l("MobHolder");
            this.entityData = cmp.func_74775_l("EntityData");
            this.scale = cmp.func_74760_g("Scale");
            this.yOffset = cmp.func_74760_g("YOffset");
            this.animationType = MobHolderType.values()[cmp.func_74762_e("AnimationType")];
            if (cmp.func_74764_b("UUID")) {
                this.uuid = cmp.func_186857_a("UUID");
            }
            this.name = cmp.func_74779_i("Name");
            this.entityChanged = true;
        }
    }

    public CompoundNBT write(CompoundNBT compound) {
        if (this.entityData != null) {
            MobHolder.saveMobToNBT(compound, this.entityData, this.scale, this.yOffset, this.animationType.ordinal(), this.name, this.uuid);
        }
        return compound;
    }

    public void tick() {
        if (this.entityChanged && this.entityData != null && this.world != null) {
            this.updateMob();
        }
        if (this.mob != null) {
            if (!this.world.field_72995_K) {
                if (this.animationType == MobHolderType.CHICKEN) {
                    ChickenEntity ch = (ChickenEntity)this.mob;
                    if (--ch.field_70887_j <= 0) {
                        ch.func_199703_a((IItemProvider)Items.field_151110_aK);
                        ch.field_70887_j = this.rand.nextInt(6000) + 6000;
                    }
                }
                return;
            }
            ++this.mob.field_70173_aa;
            this.prevJumpY = this.jumpY;
            switch (this.animationType) {
                default: {
                    break;
                }
                case SLIME: 
                case MAGMA_CUBE: {
                    SlimeEntity slime = (SlimeEntity)this.mob;
                    slime.field_70811_b += (slime.field_70813_a - slime.field_70811_b) * 0.5f;
                    slime.field_70812_c = slime.field_70811_b;
                    if (this.yVel != 0.0f) {
                        this.jumpY = Math.max(0.0f, this.jumpY + this.yVel);
                    }
                    if (this.jumpY != 0.0f) {
                        this.yVel -= 0.01f;
                    } else {
                        if (this.yVel != 0.0f) {
                            this.yVel = 0.0f;
                            slime.field_70813_a = -0.5f;
                        }
                        if ((double)this.rand.nextFloat() > 0.985) {
                            this.yVel = 0.08f;
                            slime.field_70813_a = 1.0f;
                        }
                    }
                    slime.field_70813_a *= 0.6f;
                    break;
                }
                case VEX: {
                    this.jumpY = 0.04f * MathHelper.func_76126_a((float)((float)this.mob.field_70173_aa / 10.0f)) - 0.03f;
                    break;
                }
                case ENDERMITE: {
                    if (!(this.rand.nextFloat() > 0.7f)) break;
                    this.world.func_195594_a((IParticleData)ParticleTypes.field_197599_J, (double)((float)this.pos.func_177958_n() + 0.5f), (double)((float)this.pos.func_177956_o() + 0.2f), (double)((float)this.pos.func_177952_p() + 0.5f), (this.rand.nextDouble() - 0.5) * 2.0, -this.rand.nextDouble(), (this.rand.nextDouble() - 0.5) * 2.0);
                    break;
                }
                case PARROT: {
                    boolean p;
                    this.mob.func_70636_d();
                    this.mob.field_70122_E = p = ((ParrotEntity)this.mob).func_192004_dr();
                    this.jumpY = p ? 0.0f : 0.0625f;
                    break;
                }
                case PIXIE: {
                    this.mob.func_70636_d();
                    this.mob.field_70137_T = this.pos.func_177956_o();
                    this.mob.func_70107_b(this.mob.func_226277_ct_(), (double)this.pos.func_177956_o(), this.mob.func_226281_cx_());
                    break;
                }
                case RABBIT: {
                    RabbitEntity rabbit = (RabbitEntity)this.mob;
                    if (this.yVel != 0.0f) {
                        this.jumpY = Math.max(0.0f, this.jumpY + this.yVel);
                    }
                    if (this.jumpY != 0.0f) {
                        this.yVel -= 0.017f;
                    } else {
                        if (this.yVel != 0.0f) {
                            this.yVel = 0.0f;
                        }
                        if ((double)this.rand.nextFloat() > 0.985) {
                            this.yVel = 0.093f;
                            rabbit.func_184770_cZ();
                        }
                    }
                    rabbit.func_70636_d();
                    break;
                }
                case CAT: {
                    CatEntity cat = (CatEntity)this.mob;
                    cat.func_70904_g(true);
                    break;
                }
                case CHICKEN: {
                    ChickenEntity ch = (ChickenEntity)this.mob;
                    ch.func_70636_d();
                    double d = this.rand.nextFloat();
                    double d2 = ch.field_70122_E ? 0.99 : 0.88;
                    if (!(d > d2)) break;
                    ch.field_70122_E = !ch.field_70122_E;
                    break;
                }
                case MOTH: {
                    this.mob.func_70636_d();
                    this.mob.field_70137_T = this.pos.func_177956_o();
                    this.mob.func_70107_b(this.mob.func_226277_ct_(), (double)this.pos.func_177956_o(), this.mob.func_226281_cx_());
                    this.jumpY = 0.04f * MathHelper.func_76126_a((float)((float)this.mob.field_70173_aa / 10.0f)) - 0.03f;
                }
            }
        }
    }

    public void setWaterMobInWater(boolean w) {
        if (this.mob != null && this.mob instanceof WaterMobEntity && this.mob.func_70090_H() != w) {
            try {
                Field f = ObfuscationReflectionHelper.findField(Entity.class, (String)"field_70171_ac");
                f.setAccessible(true);
                f.setBoolean(this.mob, w);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Nullable
    public static Entity createEntityFromNBT(CompoundNBT com, UUID id, World world) {
        if (com != null && com.func_74764_b("id")) {
            Object entity2 = com.func_74781_a("id").func_150285_a_().equals("minecraft:bee") ? new BeeEntity(EntityType.field_226289_e_, world) : EntityType.func_220335_a((CompoundNBT)com, (World)world, o -> o);
            if (id != null) {
                entity2.func_184221_a(id);
            }
            return entity2;
        }
        return null;
    }

    public void updateMob() {
        this.entityChanged = false;
        Entity entity2 = MobHolder.createEntityFromNBT(this.entityData, this.uuid, this.world);
        if (entity2 == null) {
            return;
        }
        double px = (double)this.pos.func_177958_n() + 0.5;
        double py = (double)this.pos.func_177956_o() + 0.5 + 0.0625;
        double pz = (double)this.pos.func_177952_p() + 0.5;
        entity2.func_70107_b(px, py, pz);
        entity2.field_70142_S = px;
        entity2.field_70137_T = py;
        entity2.field_70136_U = pz;
        entity2.field_70169_q = px;
        entity2.field_70167_r = py;
        entity2.field_70166_s = pz;
        entity2.field_70173_aa += this.rand.nextInt(40);
        this.mob = (LivingEntity)entity2;
        this.animationType = MobHolderType.getType(entity2);
        if (!this.world.field_72995_K) {
            int light = this.animationType.getLightLevel();
            BlockState state = this.world.func_180495_p(this.pos);
            if ((Integer)state.func_177229_b((IProperty)BlockProperties.LIGHT_LEVEL_0_15) != light) {
                this.world.func_180501_a(this.pos, (BlockState)state.func_206870_a((IProperty)BlockProperties.LIGHT_LEVEL_0_15, (Comparable)Integer.valueOf(light)), 22);
            }
        }
        this.setWaterMobInWater(!this.world.func_204610_c(this.pos).func_206888_e());
    }

    public boolean isEmpty() {
        return this.entityData == null;
    }

    public static void saveMobToNBT(CompoundNBT compound, CompoundNBT entityData, float scale, float yOffset, int type, String name, UUID id) {
        CompoundNBT cmp = new CompoundNBT();
        cmp.func_218657_a("EntityData", (INBT)entityData);
        cmp.func_74776_a("Scale", scale);
        cmp.func_74776_a("YOffset", yOffset);
        cmp.func_74768_a("AnimationType", type);
        if (id != null) {
            cmp.func_186854_a("UUID", id);
        }
        cmp.func_74778_a("Name", name);
        compound.func_218657_a("MobHolder", (INBT)cmp);
    }

    public static void createMobHolderItemNBT(ItemStack stack, Entity mob, float blockh, float blockw) {
        if (mob == null) {
            return;
        }
        if (mob instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)mob;
            le.field_70758_at = 0.0f;
            le.field_70759_as = 0.0f;
            le.field_70721_aZ = 0.0f;
            le.field_184618_aE = 0.0f;
            le.field_184619_aG = 0.0f;
            le.field_70737_aN = 0;
            le.field_70738_aO = 0;
            le.field_70737_aN = 0;
        }
        mob.field_70177_z = 0.0f;
        mob.field_70126_B = 0.0f;
        mob.field_70127_C = 0.0f;
        mob.field_70125_A = 0.0f;
        mob.func_70066_B();
        mob.field_70172_ad = 0;
        UUID id = mob.func_110124_au();
        CompoundNBT mobCompound = new CompoundNBT();
        mob.func_70039_c(mobCompound);
        if (!mobCompound.isEmpty()) {
            mobCompound.func_82580_o("Passengers");
            mobCompound.func_82580_o("Leash");
            mobCompound.func_82580_o("UUID");
            boolean flag = mob.func_189652_ae() || mob instanceof IFlyingAnimal || mob.func_145773_az() || mob instanceof WaterMobEntity;
            MobHolderType type = MobHolderType.getType(mob);
            float babyscale = 1.0f;
            if (mob instanceof AgeableEntity && ((LivingEntity)mob).func_70631_g_()) {
                babyscale = 2.0f;
            }
            if (mobCompound.func_74764_b("IsBaby") && mobCompound.func_74767_n("IsBaby") || mob instanceof VillagerEntity && ((LivingEntity)mob).func_70631_g_()) {
                babyscale = 1.125f;
            }
            float s = 1.0f;
            float w = mob.func_213311_cf() * babyscale;
            float h = mob.func_213302_cg() * babyscale;
            float maxh = blockh - (flag ? 0.25f : 0.125f) - type.adjHeight;
            float maxw = blockw - 0.25f - type.adjWidth;
            if (w > maxw || h > maxh) {
                s = w - maxw > h - maxh ? maxw / w : maxh / h;
            }
            float y = flag ? blockh / 2.0f - h * s / 2.0f : 0.0626f;
            String name = mob.func_200600_R().getRegistryName().toString();
            if (name.equals("iceandfire:fire_dragon") || name.equals("iceandfire:ice_dragon") || name.equals("iceandfire:lightning_dragon")) {
                s = (float)((double)s * 0.45);
            }
            CompoundNBT cmp = new CompoundNBT();
            MobHolder.saveMobToNBT(cmp, mobCompound, s, y, 0, mob.func_200200_C_().getString(), id);
            stack.func_77983_a("BlockEntityTag", (INBT)cmp);
        }
    }

    public static enum MobHolderType {
        DEFAULT(null, 0.0f, 0.0f),
        SLIME("minecraft:slime", 0.0f, 0.0f),
        MAGMA_CUBE("minecraft:magma_cube", 0.0f, 0.0f),
        BEE("minecraft:bee", 0.3125f, 0.0f),
        BAT("minecraft:bat", 0.0f, 0.0f),
        VEX("minecraft:vex", 0.0f, 0.125f),
        ENDERMITE("minecraft:endermite", 0.0f, 0.0f),
        SILVERFISH("minecraft:silverfish", 0.0f, 0.25f),
        PARROT("minecraft:parrot", 0.0f, 0.0f),
        CAT("minecraft:cat", 0.0f, 0.1875f),
        RABBIT("minecraft:rabbit", 0.0f, 0.0f),
        CHICKEN("minecraft:chicken", 0.25f, 0.3125f),
        PIXIE("iceandfire:pixie", 0.0f, 0.0f),
        MOTH("druidcraft:lunar_moth", 0.375f, 0.1375f),
        WATER_MOB("minecraft:tropical_fish", 0.0f, 0.125f);

        public final String type;
        public final float adjHeight;
        public final float adjWidth;

        private MobHolderType(String type, float h, float w) {
            this.type = type;
            this.adjHeight = h;
            this.adjWidth = w;
        }

        public int getLightLevel() {
            if (this == PIXIE) {
                return 10;
            }
            if (this == ENDERMITE) {
                return 5;
            }
            if (this == MOTH) {
                return 10;
            }
            return 0;
        }

        public static MobHolderType getType(Entity e) {
            if (e instanceof WaterMobEntity) {
                return WATER_MOB;
            }
            String name = e.func_200600_R().getRegistryName().toString();
            for (MobHolderType n : MobHolderType.values()) {
                if (!name.equals(n.type)) continue;
                return n;
            }
            return DEFAULT;
        }
    }
}

