/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.mehvahdjukaar.supplementaries.block.tiles.BlackboardBlockTile;
import net.mehvahdjukaar.supplementaries.client.gui.BlackBoardButton;
import net.mehvahdjukaar.supplementaries.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.network.UpdateServerBlackboardPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class BlackBoardGui
extends Screen {
    private final BlackboardBlockTile tileBoard;
    private final BlackBoardButton[][] buttons = new BlackBoardButton[16][16];

    public BlackBoardGui(BlackboardBlockTile teBoard) {
        super((ITextComponent)new TranslationTextComponent("gui.supplementaries.blackboard.edit", new Object[0]));
        this.tileBoard = teBoard;
    }

    public static void open(BlackboardBlockTile sign) {
        Minecraft.func_71410_x().func_147108_a((Screen)new BlackBoardGui(sign));
    }

    public void tick() {
        if (!this.tileBoard.func_200662_C().func_223045_a(this.tileBoard.func_195044_w().func_177230_c())) {
            this.close();
        }
    }

    public void onClose() {
        this.close();
    }

    public void removed() {
        this.minecraft.field_195559_v.func_197967_a(false);
        byte[][] pixels = new byte[16][16];
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                pixels[xx][yy] = (byte)(this.buttons[xx][yy].on ? 1 : 0);
            }
        }
        NetworkHandler.INSTANCE.sendToServer((Object)new UpdateServerBlackboardPacket(this.tileBoard.func_174877_v(), pixels));
        this.tileBoard.setEditable(true);
    }

    private void close() {
        this.tileBoard.func_70296_d();
        this.minecraft.func_147108_a(null);
    }

    public void setPixel(int x, int y, boolean on) {
        this.tileBoard.pixels[x][y] = (byte)(on ? 1 : 0);
    }

    public void dragButtons(double mx, double my, boolean on) {
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                if (!this.buttons[xx][yy].isMouseOver(mx, my)) continue;
                this.buttons[xx][yy].onDrag(mx, my, on);
            }
        }
    }

    private void clear() {
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                this.setPixel(xx, yy, false);
                this.buttons[xx][yy].on = false;
            }
        }
    }

    protected void init() {
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                this.buttons[xx][yy] = new BlackBoardButton(this.width / 2, 65, xx, yy, this::setPixel, this::dragButtons);
                this.children.add(this.buttons[xx][yy]);
                this.buttons[xx][yy].on = this.tileBoard.pixels[xx][yy] > 0;
            }
        }
        this.minecraft.field_195559_v.func_197967_a(true);
        this.addButton((Widget)new Button(this.width / 2 - 100, this.height / 4 + 120, 96, 20, I18n.func_135052_a((String)"gui.supplementaries.blackboard.clear", (Object[])new Object[0]), b -> this.clear()));
        this.addButton((Widget)new Button(this.width / 2 + 4, this.height / 4 + 120, 96, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), p_238847_1_ -> this.close()));
        this.tileBoard.setEditable(false);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        RenderHelper.func_227783_c_();
        this.renderBackground();
        this.drawCenteredString(this.font, this.title.getString(), this.width / 2, 40, 0xFFFFFF);
        MatrixStack matrixstack = new MatrixStack();
        matrixstack.func_227860_a_();
        int ut = -1;
        int vt = -1;
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                if (this.buttons[xx][yy].isHovered()) {
                    ut = xx;
                    vt = yy;
                }
                this.buttons[xx][yy].render(mouseX, mouseY, partialTicks);
            }
        }
        if (ut != -1) {
            this.buttons[ut][vt].renderTooltip(matrixstack);
        }
        matrixstack.func_227865_b_();
        RenderHelper.func_227784_d_();
        super.render(mouseX, mouseY, partialTicks);
    }
}

