/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.gui;

import net.mehvahdjukaar.supplementaries.block.tiles.SpeakerBlockTile;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.network.UpdateServerSpeakerBlockPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.widget.Slider;

public class SpeakerBlockGui
extends Screen {
    private static final ITextComponent NARRATOR_TEXT = new TranslationTextComponent("gui.supplementaries.speaker_block.chat_message", new Object[0]);
    private static final ITextComponent CHAT_TEXT = new TranslationTextComponent("gui.supplementaries.speaker_block.narrator_message", new Object[0]);
    private static final ITextComponent DISTANCE_BLOCKS = new TranslationTextComponent("gui.supplementaries.speaker_block.blocks", new Object[0]);
    private static final ITextComponent VOLUME_TEXT = new TranslationTextComponent("gui.supplementaries.speaker_block.volume", new Object[0]);
    private TextFieldWidget commandTextField;
    private final SpeakerBlockTile tileSpeaker;
    private boolean narrator;
    private final String message;
    private Button modeBtn;
    private Slider volume;

    public SpeakerBlockGui(SpeakerBlockTile te) {
        super((ITextComponent)new TranslationTextComponent("gui.supplementaries.speaker_block.edit", new Object[0]));
        this.tileSpeaker = te;
        this.narrator = this.tileSpeaker.narrator;
        this.message = this.tileSpeaker.message;
    }

    public static void open(SpeakerBlockTile te) {
        Minecraft.func_71410_x().func_147108_a((Screen)new SpeakerBlockGui(te));
    }

    public void tick() {
        this.commandTextField.func_146178_a();
    }

    private void updateMode() {
        if (this.narrator) {
            this.modeBtn.setMessage(NARRATOR_TEXT.func_150254_d());
        } else {
            this.modeBtn.setMessage(CHAT_TEXT.func_150254_d());
        }
    }

    private void toggleMode() {
        this.narrator = !this.narrator;
    }

    public void init() {
        assert (this.minecraft != null);
        this.minecraft.field_195559_v.func_197967_a(true);
        int range = ServerConfigs.cached.SPEAKER_RANGE;
        double v = this.tileSpeaker.volume * (double)range;
        this.volume = new Slider(this.width / 2 - 75, this.height / 4 + 80, 150, 20, VOLUME_TEXT.func_150254_d(), DISTANCE_BLOCKS.func_150254_d(), 1.0, (double)range, v, false, true, null, null);
        this.children.add(this.volume);
        this.addButton((Widget)new Button(this.width / 2 - 100, this.height / 4 + 120, 200, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), p_214266_1_ -> this.close()));
        this.modeBtn = (Button)this.addButton((Widget)new Button(this.width / 2 - 75, this.height / 4 + 50, 150, 20, CHAT_TEXT.func_150254_d(), p_214186_1_ -> {
            this.toggleMode();
            this.updateMode();
        }));
        this.updateMode();
        this.commandTextField = new TextFieldWidget(this.font, this.width / 2 - 100, this.height / 4 + 10, 200, 20, this.title.func_150254_d()){

            protected String getNarrationMessage() {
                return super.getNarrationMessage();
            }
        };
        this.commandTextField.func_146180_a(this.message);
        this.commandTextField.func_146203_f(32);
        this.children.add(this.commandTextField);
        this.func_212928_a((IGuiEventListener)this.commandTextField);
        this.commandTextField.func_146195_b(true);
    }

    public void removed() {
        this.minecraft.field_195559_v.func_197967_a(false);
        this.tileSpeaker.message = this.commandTextField.func_146179_b();
        this.tileSpeaker.narrator = this.narrator;
        this.tileSpeaker.volume = this.volume.getValue() / this.volume.maxValue;
        NetworkHandler.INSTANCE.sendToServer((Object)new UpdateServerSpeakerBlockPacket(this.tileSpeaker.func_174877_v(), this.tileSpeaker.message, this.tileSpeaker.narrator, this.tileSpeaker.volume));
    }

    private void close() {
        this.tileSpeaker.func_70296_d();
        this.minecraft.func_147108_a(null);
    }

    public void onClose() {
        this.close();
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_)) {
            return true;
        }
        if (p_keyPressed_1_ != 257 && p_keyPressed_1_ != 335) {
            return false;
        }
        this.close();
        return true;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.volume.onRelease(mouseX, mouseY);
        }
        return false;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        this.drawCenteredString(this.font, this.title.func_150254_d(), this.width / 2, 40, 0xFFFFFF);
        this.volume.render(mouseX, mouseY, partialTicks);
        this.commandTextField.render(mouseX, mouseY, partialTicks);
        super.render(mouseX, mouseY, partialTicks);
    }
}

