/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import net.mehvahdjukaar.supplementaries.client.renderers.Const;
import net.mehvahdjukaar.supplementaries.common.Textures;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;

public class RendererUtil {
    public static void renderBlockPlus(BlockState state, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, BlockRendererDispatcher blockRenderer, World world, BlockPos pos) {
        try {
            for (RenderType type : RenderType.func_228661_n_()) {
                if (!RenderTypeLookup.canRenderInLayer((BlockState)state, (RenderType)type)) continue;
                RendererUtil.renderBlockPlus(state, matrixStackIn, bufferIn, blockRenderer, world, pos, type);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void renderBlockPlus(BlockState state, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, BlockRendererDispatcher blockRenderer, World world, BlockPos pos, RenderType type) {
        ForgeHooksClient.setRenderLayer((RenderType)type);
        blockRenderer.func_175019_b().func_228802_a_((ILightReader)world, blockRenderer.func_184389_a(state), state, pos, matrixStackIn, bufferIn.getBuffer(type), false, new Random(), 0L, OverlayTexture.field_229196_a_);
        ForgeHooksClient.setRenderLayer(null);
    }

    public static void addCube(IVertexBuilder builder, MatrixStack matrixStackIn, float w, float h, TextureAtlasSprite sprite, int combinedLightIn, int color, float a, int combinedOverlayIn, boolean up, boolean down, boolean fakeshading, boolean flippedY) {
        RendererUtil.addCube(builder, matrixStackIn, 0.0f, 0.0f, w, h, sprite, combinedLightIn, color, a, combinedOverlayIn, up, down, fakeshading, flippedY);
    }

    public static void addCube(IVertexBuilder builder, MatrixStack matrixStackIn, float uOff, float vOff, float w, float h, TextureAtlasSprite sprite, int combinedLightIn, int color, float a, int combinedOverlayIn, boolean up, boolean down, boolean fakeshading, boolean flippedY) {
        float b5;
        float g5;
        float r5;
        int lu = combinedLightIn & 0xFFFF;
        int lv = combinedLightIn >> 16 & 0xFFFF;
        float atlasscaleU = sprite.func_94212_f() - sprite.func_94209_e();
        float atlasscaleV = sprite.func_94210_h() - sprite.func_94206_g();
        float minu = sprite.func_94209_e() + atlasscaleU * uOff;
        float minv = sprite.func_94206_g() + atlasscaleV * vOff;
        float maxu = minu + atlasscaleU * w;
        float maxv = minv + atlasscaleV * h;
        float maxv2 = minv + atlasscaleV * w;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float r6 = r5 = r;
        float r8 = r5;
        float g6 = g5 = g;
        float g8 = g5;
        float b6 = b5 = b;
        float b8 = b5;
        if (fakeshading) {
            float s1 = 0.8f;
            float s2 = 0.6f;
            float s3 = 0.5f;
            r8 *= s1;
            g8 *= s1;
            b8 *= s1;
            r6 *= s2;
            g6 *= s2;
            b6 *= s2;
            r5 *= s3;
            g5 *= s3;
            b5 *= s3;
        }
        float hw = w / 2.0f;
        float hh = h / 2.0f;
        if (up) {
            RendererUtil.addQuadTop(builder, matrixStackIn, -hw, h, hw, hw, h, -hw, minu, minv, maxu, maxv2, r, g, b, a, lu, lv, 0.0f, 1.0f, 0.0f);
        }
        if (down) {
            RendererUtil.addQuadTop(builder, matrixStackIn, -hw, 0.0f, -hw, hw, 0.0f, hw, minu, minv, maxu, maxv2, r5, g5, b5, a, lu, lv, 0.0f, -1.0f, 0.0f);
        }
        if (flippedY) {
            float temp = minv;
            minv = maxv;
            maxv = temp;
        }
        RendererUtil.addQuadSide(builder, matrixStackIn, hw, 0.0f, -hw, -hw, h, -hw, minu, minv, maxu, maxv, r8, g8, b8, a, lu, lv, 0.0f, 0.0f, 1.0f);
        RendererUtil.addQuadSide(builder, matrixStackIn, -hw, 0.0f, -hw, -hw, h, hw, minu, minv, maxu, maxv, r6, g6, b6, a, lu, lv, -1.0f, 0.0f, 0.0f);
        RendererUtil.addQuadSide(builder, matrixStackIn, -hw, 0.0f, hw, hw, h, hw, minu, minv, maxu, maxv, r8, g8, b8, a, lu, lv, 0.0f, 0.0f, -1.0f);
        RendererUtil.addQuadSide(builder, matrixStackIn, hw, 0.0f, hw, hw, h, -hw, minu, minv, maxu, maxv, r6, g6, b6, a, lu, lv, 1.0f, 0.0f, 0.0f);
    }

    public static void addQuadSide(IVertexBuilder builder, MatrixStack matrixStackIn, float x0, float y0, float z0, float x1, float y1, float z1, float u0, float v0, float u1, float v1, float r, float g, float b, float a, int lu, int lv, float nx, float ny, float nz) {
        RendererUtil.addVert(builder, matrixStackIn, x0, y0, z0, u0, v1, r, g, b, a, lu, lv, nx, ny, nz);
        RendererUtil.addVert(builder, matrixStackIn, x1, y0, z1, u1, v1, r, g, b, a, lu, lv, nx, ny, nz);
        RendererUtil.addVert(builder, matrixStackIn, x1, y1, z1, u1, v0, r, g, b, a, lu, lv, nx, ny, nz);
        RendererUtil.addVert(builder, matrixStackIn, x0, y1, z0, u0, v0, r, g, b, a, lu, lv, nx, ny, nz);
    }

    public static void addQuadTop(IVertexBuilder builder, MatrixStack matrixStackIn, float x0, float y0, float z0, float x1, float y1, float z1, float u0, float v0, float u1, float v1, float r, float g, float b, float a, int lu, int lv, float nx, float ny, float nz) {
        RendererUtil.addVert(builder, matrixStackIn, x0, y0, z0, u0, v1, r, g, b, a, lu, lv, nx, ny, nz);
        RendererUtil.addVert(builder, matrixStackIn, x1, y0, z0, u1, v1, r, g, b, a, lu, lv, nx, ny, nz);
        RendererUtil.addVert(builder, matrixStackIn, x1, y1, z1, u1, v0, r, g, b, a, lu, lv, nx, ny, nz);
        RendererUtil.addVert(builder, matrixStackIn, x0, y1, z1, u0, v0, r, g, b, a, lu, lv, nx, ny, nz);
    }

    public static void addVert(IVertexBuilder builder, MatrixStack matrixStackIn, float x, float y, float z, float u, float v, float r, float g, float b, float a, int lu, int lv, float nx, float ny, float nz) {
        builder.func_227888_a_(matrixStackIn.func_227866_c_().func_227870_a_(), x, y, z).func_227885_a_(r, g, b, a).func_225583_a_(u, v).func_227891_b_(OverlayTexture.field_229196_a_).func_225587_b_(lu, lv).func_227887_a_(matrixStackIn.func_227866_c_().func_227872_b_(), nx, ny, nz).func_181675_d();
    }

    public static void renderFish(IVertexBuilder builder, MatrixStack matrixStackIn, float wo, float ho, int fishType, int combinedLightIn, int combinedOverlayIn) {
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(Textures.FISHIES_TEXTURE);
        float w = 0.3125f;
        float h = 0.25f;
        float hw = w / 2.0f;
        float hh = h / 2.0f;
        int lu = combinedLightIn & 0xFFFF;
        int lv = combinedLightIn >> 16 & 0xFFFF;
        float atlasscaleU = sprite.func_94212_f() - sprite.func_94209_e();
        float atlasscaleV = sprite.func_94210_h() - sprite.func_94206_g();
        float minu = sprite.func_94209_e();
        float maxv = sprite.func_94206_g() + atlasscaleV * (float)fishType * h;
        float maxu = atlasscaleU * w + minu;
        float minv = atlasscaleV * h + maxv;
        for (int j = 0; j < 2; ++j) {
            RendererUtil.addVert(builder, matrixStackIn, hw - Math.abs(wo / 2.0f), -hh + ho, wo, minu, minv, 1.0f, 1.0f, 1.0f, 1.0f, lu, lv, 0.0f, 1.0f, 0.0f);
            RendererUtil.addVert(builder, matrixStackIn, -hw + Math.abs(wo / 2.0f), -hh + ho, -wo, maxu, minv, 1.0f, 1.0f, 1.0f, 1.0f, lu, lv, 0.0f, 1.0f, 0.0f);
            RendererUtil.addVert(builder, matrixStackIn, -hw + Math.abs(wo / 2.0f), hh + ho, -wo, maxu, maxv, 1.0f, 1.0f, 1.0f, 1.0f, lu, lv, 0.0f, 1.0f, 0.0f);
            RendererUtil.addVert(builder, matrixStackIn, hw - Math.abs(wo / 2.0f), hh + ho, wo, minu, maxv, 1.0f, 1.0f, 1.0f, 1.0f, lu, lv, 0.0f, 1.0f, 0.0f);
            matrixStackIn.func_227863_a_(Const.Y180);
            float temp = minu;
            minu = maxu;
            maxu = temp;
        }
    }
}

