/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers;

import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.block.tiles.BambooSpikesBlockTile;
import net.mehvahdjukaar.supplementaries.client.renderers.HSLColor;
import net.mehvahdjukaar.supplementaries.plugins.quark.SupplementariesQuarkPlugin;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.ModList;

public class TippedSpikesColor
implements IBlockColor,
IItemColor {
    public int getColor(BlockState state, @Nullable ILightReader world, @Nullable BlockPos pos, int tint) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof BambooSpikesBlockTile) {
            int color = ((BambooSpikesBlockTile)te).getColor();
            return this.getProcessedColor(color, tint);
        }
        if (ModList.get().isLoaded("quark") && world instanceof World && (te = SupplementariesQuarkPlugin.getMovingTile(pos, (World)world)) instanceof BambooSpikesBlockTile) {
            int color = ((BambooSpikesBlockTile)te).getColor();
            return this.getProcessedColor(color, tint);
        }
        return 0xFFFFFF;
    }

    public int getColor(ItemStack stack, int tint) {
        if (tint == 0) {
            return 0xFFFFFF;
        }
        return this.getProcessedColor(PotionUtils.func_190932_c((ItemStack)stack), tint - 1);
    }

    private int getProcessedColor(int rgb, int tint) {
        float h;
        float[] hsl = HSLColor.rgbToHsl(rgb);
        if (tint == 1) {
            h = hsl[0];
            boolean b = h > 0.16667f && h < 0.6667f;
            float i = b ? -0.04f : 0.04f;
            hsl[0] = (h + i) % 1.0f;
        }
        hsl = HSLColor.postProcess(hsl);
        h = hsl[0];
        float s = hsl[1];
        float l = hsl[2];
        s = tint == 0 ? s * 0.81f : s * 0.74f;
        return HSLColor.hslToRgb(h, s, l);
    }
}

