/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.mehvahdjukaar.supplementaries.block.tiles.GlobeBlockTile;
import net.mehvahdjukaar.supplementaries.client.renderers.Const;
import net.mehvahdjukaar.supplementaries.client.renderers.RendererUtil;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.world.data.GlobeData;
import net.mehvahdjukaar.supplementaries.world.data.GlobeDataGenerator;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class GlobeBlockTileRenderer
extends TileEntityRenderer<GlobeBlockTile> {
    public static final ModelRenderer globe = new ModelRenderer(32, 16, 0, 0);
    public static final ModelRenderer flat = new ModelRenderer(32, 32, 0, 0);
    public static final ModelRenderer sheared = new ModelRenderer(32, 32, 0, 0);

    public GlobeBlockTileRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void renderEarth(MatrixStack matrixStack, IVertexBuilder vertexBuilder, int combinedLightIn, int combinedOverlayIn) {
        matrixStack.func_227863_a_(Const.X180);
        globe.func_228309_a_(matrixStack, vertexBuilder, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void renderFlat(MatrixStack matrixStack, IVertexBuilder vertexBuilder, int combinedLightIn, int combinedOverlayIn) {
        matrixStack.func_227863_a_(Const.X180);
        flat.func_228309_a_(matrixStack, vertexBuilder, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void renderSheared(MatrixStack matrixStack, IVertexBuilder vertexBuilder, int combinedLightIn, int combinedOverlayIn) {
        matrixStack.func_227863_a_(Const.X180);
        sheared.func_228309_a_(matrixStack, vertexBuilder, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void render(GlobeBlockTile tile, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.5, 0.5, 0.5);
        matrixStackIn.func_227863_a_(tile.getDirection().func_229384_a_());
        matrixStackIn.func_227863_a_(Const.XN90);
        matrixStackIn.func_227861_a_(0.0, 0.0625, 0.0);
        matrixStackIn.func_227863_a_(Const.XN22);
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(MathHelper.func_219799_g((float)partialTicks, (float)(tile.prevYaw + (float)tile.face), (float)(tile.yaw + (float)tile.face))));
        IVertexBuilder builder = bufferIn.getBuffer(RenderType.func_228638_b_((ResourceLocation)tile.field_200663_e.texture));
        if (!ClientConfigs.cached.GLOBE_RANDOM) {
            this.renderEarth(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        }
        switch (tile.field_200663_e) {
            case FLAT: {
                this.renderFlat(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
                break;
            }
            default: {
                this.renderEarth(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
                break;
            }
            case SHEARED: {
                this.renderSheared(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
                break;
            }
            case DEFAULT: {
                matrixStackIn.func_227861_a_(-0.25, 0.25, 0.25);
                byte[][] colors = GlobeData.get((World)tile.func_145831_w()).colors;
                if (colors[0].length != 16) {
                    matrixStackIn.func_227865_b_();
                    return;
                }
                int lu = combinedLightIn & 0xFFFF;
                int lv = combinedLightIn >> 16 & 0xFFFF;
                matrixStackIn.func_227862_a_(0.0625f, 0.0625f, 0.0625f);
                GlobeBlockTileRenderer.renderFace(matrixStackIn, builder, colors, 0, 8, lu, lv);
                matrixStackIn.func_227863_a_(Const.Y90);
                matrixStackIn.func_227860_a_();
                matrixStackIn.func_227863_a_(Const.XN90);
                matrixStackIn.func_227861_a_(0.0, 8.0, 0.0);
                GlobeBlockTileRenderer.renderFaceUp(matrixStackIn, builder, colors, 8, 0, lu, lv);
                matrixStackIn.func_227865_b_();
                matrixStackIn.func_227860_a_();
                matrixStackIn.func_227861_a_(0.0, -8.0, 0.0);
                matrixStackIn.func_227863_a_(Const.X90);
                GlobeBlockTileRenderer.renderFace(matrixStackIn, builder, colors, 16, 0, lu, lv);
                matrixStackIn.func_227865_b_();
                GlobeBlockTileRenderer.renderFace(matrixStackIn, builder, colors, 8, 8, lu, lv);
                matrixStackIn.func_227863_a_(Const.Y90);
                GlobeBlockTileRenderer.renderFace(matrixStackIn, builder, colors, 16, 8, lu, lv);
                matrixStackIn.func_227863_a_(Const.Y90);
                GlobeBlockTileRenderer.renderFace(matrixStackIn, builder, colors, 24, 8, lu, lv);
            }
        }
        matrixStackIn.func_227865_b_();
    }

    public static void renderFace(MatrixStack matrixStackIn, IVertexBuilder builder, byte[][] colors, int ux, int uv, int lu, int lv) {
        for (int x = 0; x < 8; ++x) {
            matrixStackIn.func_227860_a_();
            for (int y = 0; y < 8; ++y) {
                matrixStackIn.func_227861_a_(0.0, -1.0, 0.0);
                int color = GlobeDataGenerator.getRGB(colors[ux + x][uv + y]);
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                RendererUtil.addQuadSide(builder, matrixStackIn, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, r, g, b, 1.0f, lu, lv, 0.0f, 0.0f, 1.0f);
            }
            matrixStackIn.func_227865_b_();
            matrixStackIn.func_227861_a_(1.0, 0.0, 0.0);
        }
    }

    public static void renderFaceUp(MatrixStack matrixStackIn, IVertexBuilder builder, byte[][] colors, int ux, int uv, int lu, int lv) {
        for (int x = 0; x < 8; ++x) {
            matrixStackIn.func_227860_a_();
            for (int y = 0; y < 8; ++y) {
                matrixStackIn.func_227861_a_(0.0, -1.0, 0.0);
                int color = GlobeDataGenerator.getRGB(colors[ux + x][uv + y]);
                float r = (float)(color >> 16 & 0xFF) / 255.0f * 0.775f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f * 0.775f;
                float b = (float)(color & 0xFF) / 255.0f * 0.775f;
                RendererUtil.addQuadSide(builder, matrixStackIn, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, r, g, b, 1.0f, lu, lv, 0.0f, 0.0f, 1.0f);
            }
            matrixStackIn.func_227865_b_();
            matrixStackIn.func_227861_a_(1.0, 0.0, 0.0);
        }
    }

    static {
        globe.func_228303_a_(-4.0f, -28.0f, -4.0f, 8.0f, 8.0f, 8.0f, 0.0f, false);
        globe.func_78793_a(0.0f, 24.0f, 0.0f);
        flat.func_78793_a(0.0f, 24.0f, 0.0f);
        flat.func_78784_a(0, 0).func_228303_a_(-4.0f, -28.0f, -4.0f, 8.0f, 4.0f, 8.0f, 0.0f, false);
        flat.func_78784_a(0, 13).func_228303_a_(-4.0f, -24.0f, -4.0f, 8.0f, 2.0f, 8.0f, 0.0f, false);
        flat.func_78784_a(4, 23).func_228303_a_(-3.0f, -22.0f, -3.0f, 6.0f, 1.0f, 6.0f, 0.0f, false);
        flat.func_78784_a(8, 24).func_228303_a_(-2.0f, -21.0f, -2.0f, 4.0f, 1.0f, 4.0f, 0.0f, false);
        sheared.func_78793_a(0.0f, 24.0f, 0.0f);
        sheared.func_78784_a(0, 0).func_228303_a_(-4.0f, -28.0f, -4.0f, 8.0f, 8.0f, 4.0f, 0.0f, false);
        sheared.func_78784_a(0, 12).func_228303_a_(0.0f, -28.0f, 0.0f, 4.0f, 8.0f, 4.0f, 0.0f, false);
    }
}

