/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import net.mehvahdjukaar.supplementaries.block.tiles.JarBlockTile;
import net.mehvahdjukaar.supplementaries.block.util.MobHolder;
import net.mehvahdjukaar.supplementaries.client.renderers.Const;
import net.mehvahdjukaar.supplementaries.client.renderers.RendererUtil;
import net.mehvahdjukaar.supplementaries.common.CommonUtil;
import net.mehvahdjukaar.supplementaries.common.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class JarBlockTileRenderer
extends TileEntityRenderer<JarBlockTile> {
    public JarBlockTileRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(JarBlockTile tile, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        float height = tile.liquidLevel;
        long r = tile.func_174877_v().func_218275_a();
        Random rand = new Random(r);
        if (tile.liquidType == CommonUtil.JarLiquidType.COOKIES) {
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.5, 0.5, 0.5);
            matrixStackIn.func_227863_a_(Const.XN90);
            matrixStackIn.func_227861_a_(0.0, 0.0, -0.5);
            float scale = 0.5714286f;
            matrixStackIn.func_227862_a_(scale, scale, scale);
            float i = 0.0f;
            while (i < height) {
                matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)rand.nextInt(360)));
                matrixStackIn.func_227861_a_(0.0, 0.0, (double)(1.0f / (16.0f * scale)));
                ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
                ItemStack stack = tile.func_70301_a(0);
                IBakedModel ibakedmodel = itemRenderer.func_184393_a(stack, tile.func_145831_w(), null);
                itemRenderer.func_229111_a_(stack, ItemCameraTransforms.TransformType.FIXED, true, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, ibakedmodel);
                i = (float)((double)i + 0.0625);
            }
            matrixStackIn.func_227865_b_();
        } else {
            if (tile.liquidType.isFish()) {
                matrixStackIn.func_227860_a_();
                IVertexBuilder builder1 = bufferIn.getBuffer(RenderType.func_228643_e_());
                long time = System.currentTimeMillis() + r;
                float angle = (float)(time % 28800L) / 80.0f;
                float angle2 = (float)(time % 1080L) / 3.0f;
                float angle3 = (float)(time % 126000L) / 350.0f;
                float wo = 0.015f * MathHelper.func_76126_a((float)((float)(Math.PI * 2 * (double)angle2 / 360.0)));
                float ho = 0.1f * MathHelper.func_76126_a((float)((float)(Math.PI * 2 * (double)angle3 / 360.0)));
                matrixStackIn.func_227861_a_(0.5, 0.0635, 0.5);
                TextureAtlasSprite sprite_s = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(Textures.SAND_TEXTURE);
                RendererUtil.addCube(builder1, matrixStackIn, 0.499f, 0.0625f, sprite_s, combinedLightIn, 0xFFFFFF, 1.0f, combinedOverlayIn, true, true, true, true);
                matrixStackIn.func_227861_a_(0.0, 0.4365, 0.0);
                Quaternion rotation = Vector3f.field_229181_d_.func_229187_a_(-angle);
                matrixStackIn.func_227863_a_(rotation);
                matrixStackIn.func_227862_a_(0.6f, 0.6f, 0.6f);
                matrixStackIn.func_227861_a_(0.0, -0.2, -0.35);
                RendererUtil.renderFish(builder1, matrixStackIn, wo, ho, tile.liquidType.fishType, combinedLightIn, combinedOverlayIn);
                matrixStackIn.func_227865_b_();
            }
            if (height != 0.0f) {
                int color;
                matrixStackIn.func_227860_a_();
                int n = color = tile.liquidType.applyColor ? tile.color : 0xFFFFFF;
                if (color == -1) {
                    color = tile.updateClientWaterColor();
                }
                float opacity = tile.liquidType.opacity;
                ResourceLocation texture = tile.liquidType.texture;
                TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(texture);
                IVertexBuilder builder = bufferIn.getBuffer(RenderType.func_228645_f_());
                matrixStackIn.func_227861_a_(0.5, 0.0625, 0.5);
                RendererUtil.addCube(builder, matrixStackIn, 0.5f, height, sprite, combinedLightIn, color, opacity, combinedOverlayIn, true, true, true, true);
                matrixStackIn.func_227865_b_();
            }
        }
        MobHolder mobHolder = tile.mobHolder;
        LivingEntity mob = mobHolder.mob;
        if (mob != null) {
            matrixStackIn.func_227860_a_();
            float y = mobHolder.yOffset + MathHelper.func_219799_g((float)partialTicks, (float)mobHolder.prevJumpY, (float)mobHolder.jumpY);
            float s = mobHolder.scale;
            matrixStackIn.func_227861_a_(0.5, (double)y, 0.5);
            matrixStackIn.func_227863_a_(tile.getDirection().func_229384_a_());
            matrixStackIn.func_227863_a_(Const.XN90);
            matrixStackIn.func_227862_a_(s, s, s);
            Minecraft.func_71410_x().func_175598_ae().func_229084_a_((Entity)mob, 0.0, 0.0, 0.0, 0.0f, partialTicks, matrixStackIn, bufferIn, combinedLightIn);
            matrixStackIn.func_227865_b_();
        }
    }
}

