/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.mehvahdjukaar.supplementaries.block.tiles.LaserBlockTile;
import net.mehvahdjukaar.supplementaries.client.renderers.RendererUtil;
import net.mehvahdjukaar.supplementaries.common.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;

public class LaserBlockTileRenderer
extends TileEntityRenderer<LaserBlockTile> {
    public LaserBlockTileRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(LaserBlockTile tile, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (tile.canEmit()) {
            int MAXLENGHT = 15;
            int lenght = tile.lenght;
            if (lenght == 0) {
                return;
            }
            TextureAtlasSprite sprite_o = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(Textures.LASER_OVERLAY_TEXTURE);
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(Textures.LASER_BEAM_TEXTURE);
            int color = 0xFF00FF;
            Direction dir = tile.getDirection();
            float yaw = dir.func_185119_l();
            float pitch = 0.0f;
            if (dir == Direction.UP) {
                pitch = 90.0f;
            } else if (dir == Direction.DOWN) {
                pitch = -90.0f;
            }
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.5, 0.5, 0.5);
            matrixStackIn.func_227863_a_(dir.func_229384_a_());
            matrixStackIn.func_227861_a_(0.0, -0.5, 0.0);
            int j = 240;
            int k = combinedLightIn >> 16 & 0xFF;
            combinedLightIn = j | k << 16;
            float w2 = 0.046875f;
            float w = 0.125f;
            if (!Minecraft.func_71410_x().func_147113_T()) {
                float d = 0.015625f * MathHelper.func_219799_g((float)partialTicks, (float)tile.prevWidth, (float)tile.width);
                w += d / 2.0f;
                w2 = (float)((double)w2 + (double)d / 1.5);
            }
            int l = Math.min(lenght, MAXLENGHT);
            for (int i = 0; i < l; ++i) {
                matrixStackIn.func_227861_a_(0.0, 1.0, 0.0);
                matrixStackIn.func_227860_a_();
                IVertexBuilder builder1 = bufferIn.getBuffer(RenderType.func_228657_l_());
                RendererUtil.addCube(builder1, matrixStackIn, w, 1.0f, sprite, combinedLightIn, color, 0.7f, combinedOverlayIn, false, false, false, false);
                RendererUtil.addCube(builder1, matrixStackIn, w2, 1.0f, sprite, combinedLightIn, 0xFFFFFF, 1.0f, combinedOverlayIn, false, false, false, false);
                matrixStackIn.func_227865_b_();
                matrixStackIn.func_227860_a_();
                IVertexBuilder builder = bufferIn.getBuffer(RenderType.func_228645_f_());
                matrixStackIn.func_227865_b_();
            }
            if (lenght == MAXLENGHT + 1) {
                matrixStackIn.func_227861_a_(0.0, 1.0, 0.0);
                matrixStackIn.func_227860_a_();
                IVertexBuilder builder1 = bufferIn.getBuffer(RenderType.func_228657_l_());
                TextureAtlasSprite sprite1 = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(Textures.LASER_BEAM_END_TEXTURE);
                RendererUtil.addCube(builder1, matrixStackIn, w, 1.0f, sprite1, combinedLightIn, color, 0.7f, combinedOverlayIn, false, false, false, true);
                RendererUtil.addCube(builder1, matrixStackIn, w2, 1.0f, sprite1, combinedLightIn, 0xFFFFFF, 1.0f, combinedOverlayIn, false, false, false, true);
                matrixStackIn.func_227865_b_();
            }
            matrixStackIn.func_227865_b_();
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227865_b_();
        }
    }
}

