/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common;

import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FlowerPotHelper {
    public static Set<Block> emptyPots;
    public static Map<Block, Map<ResourceLocation, Supplier<? extends Block>>> fullPots;

    public static boolean isEmptyPot(Block b) {
        return fullPots != null && b != null && fullPots.containsKey(b);
    }

    public static void refresh() {
        Field f2;
        emptyPots = new HashSet<Block>();
        for (Block b : ForgeRegistries.BLOCKS) {
            if (!(b instanceof FlowerPotBlock)) continue;
            try {
                f2 = ObfuscationReflectionHelper.findField(FlowerPotBlock.class, (String)"emptyPot");
                f2.setAccessible(true);
                FlowerPotBlock empty = (FlowerPotBlock)((Supplier)f2.get(b)).get();
                emptyPots.add((Block)empty);
            }
            catch (Exception f2) {}
        }
        fullPots = Maps.newHashMap();
        for (Block pot2 : emptyPots) {
            try {
                f2 = ObfuscationReflectionHelper.findField(FlowerPotBlock.class, (String)"fullPots");
                f2.setAccessible(true);
                fullPots.put(pot2, (Map)f2.get(pot2));
            }
            catch (Exception exception) {}
        }
        emptyPots.removeIf(pot -> !fullPots.containsKey(pot));
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        IWorld world = event.getWorld();
        if (world instanceof ServerWorld) {
            FlowerPotHelper.refresh();
        }
    }
}

