/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.configs;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.lang.reflect.Field;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class RegistryConfigs {
    public static ForgeConfigSpec REGISTRY_CONFIG;

    public static void load() {
        CommentedFileConfig replacementConfig = (CommentedFileConfig)CommentedFileConfig.builder((Path)FMLPaths.CONFIGDIR.get().resolve("supplementaries-registry.toml")).sync().preserveInsertionOrder().writingMode(WritingMode.REPLACE).build();
        replacementConfig.load();
        replacementConfig.save();
        REGISTRY_CONFIG.setConfig((CommentedConfig)replacementConfig);
    }

    static {
        ForgeConfigSpec.Builder REGISTRY_BUILDER = new ForgeConfigSpec.Builder();
        reg.init(REGISTRY_BUILDER);
        REGISTRY_CONFIG = REGISTRY_BUILDER.build();
        try {
            if (ModList.get().isLoaded("mysticalworld") || ModList.get().isLoaded("immersiveengineering") || ModList.get().isLoaded("bluepower") || ModList.get().isLoaded("silents_mechanisms ") || ModList.get().isLoaded("thermal") || ModList.get().isLoaded("iceandfire") || ModList.get().isLoaded("silentgems") || ModList.get().isLoaded("occultism")) {
                reg.HAS_SILVER = true;
            }
            reg.FIREFLY_JAR = (Boolean)reg.FIREFLY_ENABLED.get() != false && (Boolean)reg.JAR_ENABLED.get() != false;
            reg.SILVER_CANDELABRA = (Boolean)reg.CANDELABRA_ENABLED.get() != false && reg.HAS_SILVER;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class reg {
        public static ForgeConfigSpec.BooleanValue FIREFLY_ENABLED;
        public static ForgeConfigSpec.BooleanValue PLANTER_ENABLED;
        public static ForgeConfigSpec.BooleanValue CLOCK_ENABLED;
        public static ForgeConfigSpec.BooleanValue PEDESTAL_ENABLED;
        public static ForgeConfigSpec.BooleanValue WIND_VANE_ENABLED;
        public static ForgeConfigSpec.BooleanValue ILLUMINATOR_ENABLED;
        public static ForgeConfigSpec.BooleanValue NOTICE_BOARD_ENABLED;
        public static ForgeConfigSpec.BooleanValue CRANK_ENABLED;
        public static ForgeConfigSpec.BooleanValue JAR_ENABLED;
        public static ForgeConfigSpec.BooleanValue FAUCET_ENABLED;
        public static ForgeConfigSpec.BooleanValue TURN_TABLE_ENABLED;
        public static ForgeConfigSpec.BooleanValue PISTON_LAUNCHER_ENABLED;
        public static ForgeConfigSpec.BooleanValue SPEAKER_BLOCK_ENABLED;
        public static ForgeConfigSpec.BooleanValue SIGN_POST_ENABLED;
        public static ForgeConfigSpec.BooleanValue HANGING_SIGN_ENABLED;
        public static ForgeConfigSpec.BooleanValue BELLOWS_ENABLED;
        public static ForgeConfigSpec.BooleanValue SCONCE_ENABLED;
        public static ForgeConfigSpec.BooleanValue SCONCE_ENDER_ENABLED;
        public static ForgeConfigSpec.BooleanValue SCONCE_GREEN_ENABLED;
        public static ForgeConfigSpec.BooleanValue SCONCE_SOUL_ENABLED;
        public static ForgeConfigSpec.BooleanValue CANDELABRA_ENABLED;
        public static ForgeConfigSpec.BooleanValue CAGE_ENABLED;
        public static ForgeConfigSpec.BooleanValue ITEM_SHELF_ENABLED;
        public static ForgeConfigSpec.BooleanValue SCONCE_LEVER_ENABLED;
        public static ForgeConfigSpec.BooleanValue CANDLE_HOLDER_ENABLED;
        public static ForgeConfigSpec.BooleanValue COG_BLOCK_ENABLED;
        public static ForgeConfigSpec.BooleanValue STONE_LAMP_ENABLED;
        public static ForgeConfigSpec.BooleanValue GLOBE_ENABLED;
        public static ForgeConfigSpec.BooleanValue HOURGLASS_ENABLED;
        public static ForgeConfigSpec.BooleanValue LASER_ENABLED;
        public static ForgeConfigSpec.BooleanValue FLAG_ENABLED;
        public static ForgeConfigSpec.BooleanValue SACK_ENABLED;
        public static ForgeConfigSpec.BooleanValue BLACKBOARD_ENABLED;
        public static ForgeConfigSpec.BooleanValue SAFE_ENABLED;
        public static ForgeConfigSpec.BooleanValue COPPER_LANTERN_ENABLED;
        public static ForgeConfigSpec.BooleanValue FLUTE_ENABLED;
        public static ForgeConfigSpec.BooleanValue GOLD_TRAPDOOR_ENABLED;
        public static ForgeConfigSpec.BooleanValue GOLD_DOOR_ENABLED;
        public static ForgeConfigSpec.BooleanValue BAMBOO_SPIKES_ENABLED;
        public static ForgeConfigSpec.BooleanValue CREATIVE_TAB;
        public static ForgeConfigSpec.BooleanValue DISPENSERS;
        public static boolean FIREFLY_JAR;
        public static boolean SILVER_CANDELABRA;
        public static boolean HAS_COPPER;
        public static boolean HAS_SILVER;

        public static boolean isEnabled(String path) {
            if (path.equals("firefly_jar")) {
                return FIREFLY_JAR;
            }
            if (path.equals("candelabra_silver")) {
                return SILVER_CANDELABRA;
            }
            for (Field f : reg.class.getDeclaredFields()) {
                try {
                    ForgeConfigSpec.BooleanValue b;
                    String p;
                    if (!ForgeConfigSpec.BooleanValue.class.isAssignableFrom(f.getType()) || !(p = (String)(b = (ForgeConfigSpec.BooleanValue)f.get(null)).getPath().get(b.getPath().size() - 1)).equals(path)) continue;
                    return (Boolean)b.get();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }

        private static void init(ForgeConfigSpec.Builder builder) {
            builder.comment("all these don't actually disable blocks anymore, they just remove their recipe and remove them from the creative tabs(like all other mods do)\nto access server configuration go into /saves/serverconfigs").push("general");
            CREATIVE_TAB = builder.comment("enable creative tab").define("creative_tab", false);
            DISPENSERS = builder.comment("set to false to disable custom dispenser behaviors (filling jars) if for some reason they are causing trouble").define("dispensers", true);
            builder.pop();
            builder.comment("Enable and disable blocks / entities");
            builder.push("registration");
            builder.push("blocks");
            PLANTER_ENABLED = builder.define("planter", true);
            CLOCK_ENABLED = builder.define("clock_block", true);
            PEDESTAL_ENABLED = builder.define("pedestal", true);
            WIND_VANE_ENABLED = builder.define("wind_vane", true);
            ILLUMINATOR_ENABLED = builder.define("redstone_illuminator", true);
            NOTICE_BOARD_ENABLED = builder.define("notice_board", true);
            CRANK_ENABLED = builder.define("crank", true);
            JAR_ENABLED = builder.define("jar", true);
            FAUCET_ENABLED = builder.define("faucet", true);
            TURN_TABLE_ENABLED = builder.define("turn_table", true);
            PISTON_LAUNCHER_ENABLED = builder.define("piston_launcher", true);
            SPEAKER_BLOCK_ENABLED = builder.define("speaker_block", true);
            SIGN_POST_ENABLED = builder.define("sign_post", true);
            HANGING_SIGN_ENABLED = builder.define("hanging_sign", true);
            BELLOWS_ENABLED = builder.define("bellows", true);
            SCONCE_ENABLED = builder.define("sconce", true);
            SCONCE_GREEN_ENABLED = builder.define("sconce_green", false);
            SCONCE_ENDER_ENABLED = builder.define("sconce_ender", true);
            CANDELABRA_ENABLED = builder.define("candelabra", true);
            CAGE_ENABLED = builder.define("cage", true);
            ITEM_SHELF_ENABLED = builder.define("item_shelf", true);
            SCONCE_LEVER_ENABLED = builder.define("sconce_lever", true);
            COG_BLOCK_ENABLED = builder.define("cog_block", true);
            CANDLE_HOLDER_ENABLED = builder.define("candle_holder", true);
            GLOBE_ENABLED = builder.define("globe", true);
            HOURGLASS_ENABLED = builder.define("hourglass", true);
            SACK_ENABLED = builder.define("sack", true);
            BLACKBOARD_ENABLED = builder.define("blackboard", true);
            SAFE_ENABLED = builder.define("safe", true);
            COPPER_LANTERN_ENABLED = builder.define("copper_lantern", true);
            FLUTE_ENABLED = builder.define("flute", true);
            GOLD_TRAPDOOR_ENABLED = builder.define("gold_trapdoor", true);
            GOLD_DOOR_ENABLED = builder.define("gold_door", true);
            BAMBOO_SPIKES_ENABLED = builder.define("bamboo_spikes", true);
            STONE_LAMP_ENABLED = builder.define("stone_lamp", true);
            LASER_ENABLED = builder.comment("WIP").define("laser_block", false);
            FLAG_ENABLED = builder.comment("WIP").define("flag", false);
            builder.pop();
            builder.push("entities");
            FIREFLY_ENABLED = builder.define("firefly", true);
            builder.pop();
            builder.pop();
        }

        static {
            FIREFLY_JAR = true;
            SILVER_CANDELABRA = false;
            HAS_COPPER = false;
            HAS_SILVER = false;
        }
    }
}

