/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.entities;

import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.minecraft.block.AirBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.GrassBlock;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

public class FireflyEntity
extends CreatureEntity
implements IFlyingAnimal,
IEntityAdditionalSpawnData {
    public float alpha = 0.0f;
    public float prevAlpha = 0.01f;
    private int flickerPeriod;
    private int offset;

    public FireflyEntity(EntityType<? extends CreatureEntity> type, World world) {
        super(type, world);
        this.field_70728_aV = 1;
        this.func_94061_f(false);
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 10, true);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        FlyingPathNavigator flyingpathnavigator = new FlyingPathNavigator((MobEntity)this, worldIn){

            public boolean func_188555_b(BlockPos pos) {
                return !this.field_75513_b.func_180495_p(pos.func_177977_b()).func_196958_f();
            }
        };
        flyingpathnavigator.func_192879_a(false);
        flyingpathnavigator.func_212239_d(false);
        flyingpathnavigator.func_192878_b(true);
        return flyingpathnavigator;
    }

    public static boolean canSpawnOn(EntityType<? extends MobEntity> firefly, IWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        BlockState blockstate = worldIn.func_180495_p(pos.func_177977_b());
        if (pos.func_177956_o() <= worldIn.func_181545_F()) {
            return false;
        }
        return (blockstate.func_203425_a(BlockTags.field_206952_E) || blockstate.func_177230_c() instanceof GrassBlock || blockstate.func_203425_a(BlockTags.field_200031_h) || blockstate.func_177230_c() instanceof AirBlock) && worldIn.func_226659_b_(pos, 0) > 8;
    }

    public boolean func_213380_a(IWorld world, SpawnReason spawnReasonIn) {
        return !this.field_70170_p.func_72935_r() && !this.field_70170_p.func_72911_I();
    }

    public boolean func_70112_a(double distance) {
        return Math.abs(distance) < 3500.0;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.alpha == 0.0f && !this.field_70170_p.field_72995_K) {
            long dayTime;
            if (this.field_70170_p.func_72896_J() && (double)this.field_70146_Z.nextFloat() < 0.1) {
                this.func_70106_y();
            }
            if (ServerConfigs.cached.FIREFLY_DESPAWN && ((dayTime = this.field_70170_p.func_72820_D() % 24000L) > 23500L || dayTime < 12500L && (double)this.field_70146_Z.nextFloat() < 0.1)) {
                this.func_70106_y();
            }
        }
        this.prevAlpha = this.alpha;
        float a = (float)ClientConfigs.cached.FIREFLY_INTENSITY;
        float p = (float)ClientConfigs.cached.FIREFLY_EXPONENT;
        float time = this.field_70173_aa + this.offset;
        boolean w = this.field_70170_p.field_72995_K;
        this.alpha = Math.max((1.0f - a) * MathHelper.func_76126_a((float)(time * ((float)Math.PI * 2 / (float)this.flickerPeriod))) + a, 0.0f);
        if (this.alpha != 0.0f) {
            this.alpha = (float)Math.pow(this.alpha, p);
        }
        this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.65, 1.0));
        this.func_213317_d(this.func_213322_ci().func_72441_c(0.02 * (this.field_70146_Z.nextDouble() - 0.5), 0.03 * (this.field_70146_Z.nextDouble() - 0.5), 0.02 * (this.field_70146_Z.nextDouble() - 0.5)));
    }

    public void readSpawnData(PacketBuffer buffer) {
        this.offset = buffer.readInt();
        this.flickerPeriod = buffer.readInt();
    }

    public void writeSpawnData(PacketBuffer buffer) {
        this.flickerPeriod = ServerConfigs.cached.FIREFLY_PERIOD + this.field_70146_Z.nextInt(10);
        this.offset = this.field_70146_Z.nextInt(this.flickerPeriod / 2);
        buffer.writeInt(this.offset);
        buffer.writeInt(this.flickerPeriod);
    }

    public boolean func_70089_S() {
        return true;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b / 2.0f;
    }

    public boolean func_184652_a(PlayerEntity player) {
        return false;
    }

    public boolean func_145773_az() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_82167_n(Entity entityIn) {
    }

    protected void func_85033_bc() {
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new WanderGoal());
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223222_a_;
    }

    protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
        super.func_213333_a(source, looting, recentlyHitIn);
    }

    public SoundEvent func_184601_bQ(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.bat.hurt"));
    }

    public SoundEvent func_184615_bR() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.bat.death"));
    }

    public boolean func_225503_b_(float l, float d) {
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76364_f() instanceof ArrowEntity) {
            return false;
        }
        if (source == DamageSource.field_76379_h) {
            return false;
        }
        if (source == DamageSource.field_76367_g) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        if (this.func_110148_a(SharedMonsterAttributes.field_111263_d) != null) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        }
        if (this.func_110148_a(SharedMonsterAttributes.field_111267_a) != null) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(1.0);
        }
        if (this.func_110148_a(SharedMonsterAttributes.field_188791_g) != null) {
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(0.0);
        }
        if (this.func_110148_a(SharedMonsterAttributes.field_111264_e) == null) {
            this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        }
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(0.0);
        if (this.func_110148_a(SharedMonsterAttributes.field_193334_e) == null) {
            this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_193334_e);
        }
        this.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(48.0);
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void func_189654_d(boolean ignored) {
        super.func_189654_d(true);
    }

    public void func_70636_d() {
        super.func_70636_d();
    }

    class WanderGoal
    extends Goal {
        WanderGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return FireflyEntity.this.field_70699_by.func_75500_f() && FireflyEntity.this.field_70146_Z.nextInt(50) == 0;
        }

        public boolean func_75253_b() {
            return FireflyEntity.this.field_70699_by.func_226337_n_();
        }

        public void func_75249_e() {
            Vec3d vec3d = this.getRandomLocation();
            if (vec3d != null) {
                FireflyEntity.this.field_70699_by.func_75484_a(FireflyEntity.this.field_70699_by.func_179680_a(new BlockPos(vec3d), 1), 1.0);
            }
        }

        @Nullable
        private Vec3d getRandomLocation() {
            Vec3d vec3d = FireflyEntity.this.func_70676_i(0.0f);
            int i = 8;
            Vec3d vec3d2 = RandomPositionGenerator.func_226340_a_((CreatureEntity)FireflyEntity.this, (int)8, (int)7, (Vec3d)vec3d, (float)1.5707964f, (int)2, (int)1);
            return vec3d2 != null ? vec3d2 : RandomPositionGenerator.func_226338_a_((CreatureEntity)FireflyEntity.this, (int)8, (int)4, (int)-2, (Vec3d)vec3d, (double)1.5707963705062866);
        }
    }
}

