/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.events;

import net.mehvahdjukaar.supplementaries.block.blocks.DirectionalCakeBlock;
import net.mehvahdjukaar.supplementaries.block.blocks.DoubleCakeBlock;
import net.mehvahdjukaar.supplementaries.common.CommonUtil;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.items.BlockHolderItem;
import net.mehvahdjukaar.supplementaries.setup.Registry;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.state.IProperty;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ServerEvents {
    private static ActionResultType paceBlockOverride(Item itemOverride, PlayerEntity player, Hand hand, BlockItem heldItem, BlockPos pos, Direction dir, World world) {
        if (dir != null) {
            ActionResultType activationResult;
            BlockState blockstate = world.func_180495_p(pos);
            BlockRayTraceResult raytrace = new BlockRayTraceResult(new Vec3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), dir, pos, false);
            if (!player.func_225608_bj_() && (activationResult = blockstate.func_227031_a_(world, player, hand, raytrace)).func_226246_a_()) {
                return activationResult;
            }
            BlockItemUseContext ctx = new BlockItemUseContext(new ItemUseContext(player, hand, raytrace));
            if (itemOverride instanceof BlockHolderItem) {
                return ((BlockHolderItem)itemOverride).tryPlace(ctx, heldItem.func_179223_d());
            }
            if (itemOverride instanceof BlockItem) {
                return ((BlockItem)itemOverride).func_195942_a(ctx);
            }
        }
        return ActionResultType.PASS;
    }

    public static ActionResultType placeDoubleCake(PlayerEntity player, ItemStack stack, BlockPos pos, World world) {
        boolean d;
        BlockState state1 = world.func_180495_p(pos);
        boolean bl = d = state1.func_177230_c() == Registry.DIRECTIONAL_CAKE.get();
        if (d && (Integer)state1.func_177229_b((IProperty)DirectionalCakeBlock.field_176589_a) == 0 || state1 == Blocks.field_150414_aQ.func_176223_P()) {
            BlockState state = (BlockState)((BlockState)((Block)Registry.DOUBLE_CAKE.get()).func_176223_P().func_206870_a((IProperty)DoubleCakeBlock.FACING, (Comparable)(d ? (Direction)state1.func_177229_b((IProperty)DoubleCakeBlock.FACING) : Direction.WEST))).func_206870_a((IProperty)DoubleCakeBlock.WATERLOGGED, (Comparable)Boolean.valueOf(world.func_204610_c(pos).func_206886_c() == Fluids.field_204546_a));
            if (!world.func_180501_a(pos, state, 3)) {
                return ActionResultType.FAIL;
            }
            if (player instanceof ServerPlayerEntity) {
                CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)player, pos, stack);
            }
            SoundType soundtype = state.getSoundType((IWorldReader)world, pos, (Entity)player);
            world.func_184133_a(player, pos, state.getSoundType((IWorldReader)world, pos, (Entity)player).func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
            if (player == null || !player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        PlayerEntity player = event.getPlayer();
        if (player.func_175149_v()) {
            return;
        }
        Hand hand = event.getHand();
        ItemStack stack = event.getItemStack();
        Item i = stack.func_77973_b();
        Direction dir = event.getFace();
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        if (!(player.func_225608_bj_() || !ServerConfigs.cached.DIRECTIONAL_CAKE || world.func_180495_p(pos) != Blocks.field_150414_aQ.func_176223_P() || ServerConfigs.cached.DOUBLE_CAKE_PLACEMENT && i == Items.field_222070_lD)) {
            world.func_180501_a(pos, ((Block)Registry.DIRECTIONAL_CAKE.get()).func_176223_P(), 4);
            BlockState blockstate = world.func_180495_p(pos);
            BlockRayTraceResult raytrace = new BlockRayTraceResult(new Vec3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), dir, pos, false);
            event.setCancellationResult(blockstate.func_227031_a_(world, player, hand, raytrace));
            event.setCanceled(true);
            return;
        }
        if (player.field_71075_bZ.field_75099_e && i instanceof BlockItem) {
            BlockItem bi = (BlockItem)i;
            ActionResultType result = ActionResultType.PASS;
            if (ServerConfigs.cached.WALL_LANTERN_PLACEMENT && CommonUtil.isLantern((Item)bi)) {
                result = ServerEvents.paceBlockOverride((Item)Registry.WALL_LANTERN_ITEM.get(), player, hand, bi, pos, dir, world);
            } else if (ServerConfigs.cached.HANGING_POT_PLACEMENT && CommonUtil.isPot((Item)bi)) {
                result = ServerEvents.paceBlockOverride((Item)Registry.HANGING_FLOWER_POT_ITEM.get(), player, hand, bi, pos, dir, world);
            } else if (CommonUtil.isCake((Item)bi)) {
                if (ServerConfigs.cached.DOUBLE_CAKE_PLACEMENT) {
                    result = ServerEvents.placeDoubleCake(player, stack, pos, world);
                }
                if (!result.func_226246_a_() && ServerConfigs.cached.DIRECTIONAL_CAKE) {
                    result = ServerEvents.paceBlockOverride((Item)Registry.DIRECTIONAL_CAKE_ITEM.get(), player, hand, bi, pos, dir, world);
                }
            }
            if (result.func_226246_a_()) {
                if (player instanceof ServerPlayerEntity) {
                    // empty if block
                }
                event.setCanceled(true);
                event.setCancellationResult(result);
            }
        }
    }
}

