/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.items;

import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.block.util.MobHolder;
import net.mehvahdjukaar.supplementaries.common.DrinkHelper;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.setup.Registry;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;

public class EmptyCageItem
extends BlockItem {
    public final Supplier<Item> full;
    public final CageWhitelist cageType;

    public EmptyCageItem(Block blockIn, Item.Properties properties, Supplier<Item> full, CageWhitelist whitelist) {
        super(blockIn, properties);
        this.full = full;
        this.cageType = whitelist;
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity2) {
        if (!(entity2 instanceof LivingEntity) || player.func_184600_cs() == null) {
            return false;
        }
        return this.func_111207_a(stack, player, (LivingEntity)entity2, player.func_184600_cs());
    }

    public boolean func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity entity2, Hand hand) {
        ResourceLocation n = entity2.func_200600_R().getRegistryName();
        if (n == null) {
            return false;
        }
        String name = n.toString();
        boolean isFirefly = false;
        switch (this.cageType) {
            case CAGE: {
                boolean canBeCaught;
                boolean bl = canBeCaught = ServerConfigs.cached.CAGE_ALL_MOBS || ServerConfigs.cached.CAGE_ALL_BABIES && entity2.func_70631_g_() || ServerConfigs.cached.CAGE_ALLOWED_MOBS.contains(name) || ServerConfigs.cached.CAGE_ALLOWED_BABY_MOBS.contains(name) && entity2.func_70631_g_();
                if (canBeCaught) break;
                return false;
            }
            case JAR: {
                isFirefly = entity2.func_200600_R().getRegistryName().func_110623_a().toLowerCase().contains("firefl");
                if (ServerConfigs.cached.MOB_JAR_ALLOWED_MOBS.contains(name) || isFirefly) break;
                return false;
            }
            case TINTED_JAR: {
                if (ServerConfigs.cached.MOB_JAR_TINTED_ALLOWED_MOBS.contains(name)) break;
                return false;
            }
        }
        if (!entity2.func_70089_S()) {
            return false;
        }
        if (entity2 instanceof SlimeEntity && ((SlimeEntity)entity2).func_70809_q() > 1) {
            return false;
        }
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        ItemStack returnStack = new ItemStack(isFirefly ? (IItemProvider)Registry.FIREFLY_JAR_ITEM.get() : (IItemProvider)this.full.get());
        if (!isFirefly) {
            if (stack.func_82837_s()) {
                returnStack.func_200302_a(stack.func_200301_q());
            }
            MobHolder.createMobHolderItemNBT(returnStack, (Entity)entity2, this.cageType.height, this.cageType.width);
        }
        player.func_184611_a(hand, DrinkHelper.fill(stack.func_77946_l(), player, returnStack, false));
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187618_I, SoundCategory.BLOCKS, 1.0f, 1.0f);
        entity2.func_70106_y();
        return true;
    }

    public static enum CageWhitelist {
        CAGE(1.0f, 0.875f),
        JAR(0.875f, 0.625f),
        TINTED_JAR(0.875f, 0.625f);

        public final float width;
        public final float height;

        private CageWhitelist(float blockH, float blockW) {
            this.width = blockW;
            this.height = blockH;
        }

        public boolean isJar() {
            return this != CAGE;
        }
    }
}

