/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.mixins;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.block.util.MapPost;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import net.minecraft.world.storage.WorldSavedData;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MapData.class})
public abstract class MapDataPostsMixin
extends WorldSavedData {
    @Final
    private final Map<String, MapPost> posts = Maps.newHashMap();
    @Shadow
    @Final
    public int field_76201_a;
    @Shadow
    @Final
    public int field_76199_b;
    @Shadow
    @Final
    public byte field_76197_d;
    @Shadow
    @Final
    public final Map<String, MapDecoration> field_76203_h = Maps.newLinkedHashMap();

    public MapDataPostsMixin(String name) {
        super(name);
    }

    @Shadow
    @Final
    private void func_191095_a(MapDecoration.Type type, @Nullable IWorld worldIn, String decorationName, double worldX, double worldZ, double rotationIn, @Nullable ITextComponent name) {
    }

    @Inject(method={"tryAddBanner"}, at={@At(value="HEAD")}, cancellable=true)
    public void tryAddBanner(IWorld world, BlockPos pos, CallbackInfo info) {
        double d0 = (double)pos.func_177958_n() + 0.5;
        double d1 = (double)pos.func_177952_p() + 0.5;
        int i = 1 << this.field_76197_d;
        double d2 = (d0 - (double)this.field_76201_a) / (double)i;
        double d3 = (d1 - (double)this.field_76199_b) / (double)i;
        if (d2 >= -63.0 && d3 >= -63.0 && d2 <= 63.0 && d3 <= 63.0) {
            MapPost mappost = MapPost.fromWorld((IBlockReader)world, pos);
            if (mappost == null) {
                return;
            }
            if (this.posts.containsKey(mappost.getId()) && this.posts.get(mappost.getId()).equals(mappost)) {
                this.posts.remove(mappost.getId());
                this.field_76203_h.remove(mappost.getId());
            } else {
                this.posts.put(mappost.getId(), mappost);
                this.func_191095_a(MapDecoration.Type.TARGET_POINT, world, mappost.getId(), d0, d1, 180.0, mappost.name);
            }
            this.func_76185_a();
        }
    }

    @Inject(method={"removeStaleBanners"}, at={@At(value="TAIL")}, cancellable=true)
    public void removeStaleBanners(IBlockReader reader, int x, int z, CallbackInfo info) {
        Iterator<MapPost> iterator = this.posts.values().iterator();
        while (iterator.hasNext()) {
            MapPost mampost = iterator.next();
            if (mampost.pos.func_177958_n() != x || mampost.pos.func_177952_p() != z) continue;
            MapPost post2 = MapPost.fromWorld(reader, mampost.pos);
            if (post2 == null) {
                iterator.remove();
                this.field_76203_h.remove(mampost.getId());
                continue;
            }
            if (Objects.equals(post2.name, mampost.name)) continue;
            MapDecoration p = this.field_76203_h.get(mampost.getId());
            p = new MapDecoration(p.func_191179_b(), p.func_176112_b(), p.func_176113_c(), p.func_176111_d(), post2.name);
            iterator.remove();
            this.field_76203_h.remove(mampost.getId());
            this.field_76203_h.put(mampost.getId(), p);
            this.posts.remove(mampost.getId());
            MapPost p2 = new MapPost(mampost.pos, post2.name);
            this.posts.put(mampost.getId(), p2);
        }
    }

    @Inject(method={"read"}, at={@At(value="TAIL")}, cancellable=true)
    public void read(CompoundNBT nbt, CallbackInfo info) {
        ListNBT listnbt2 = nbt.func_150295_c("posts", 10);
        for (int j = 0; j < listnbt2.size(); ++j) {
            MapPost mappost = MapPost.read(listnbt2.func_150305_b(j));
            this.posts.put(mappost.getId(), mappost);
            this.func_191095_a(MapDecoration.Type.TARGET_POINT, null, mappost.getId(), mappost.pos.func_177958_n(), mappost.pos.func_177952_p(), 180.0, mappost.name);
        }
    }

    @Inject(method={"write"}, at={@At(value="TAIL")}, cancellable=true)
    public CompoundNBT write(CompoundNBT compound, CallbackInfoReturnable<CompoundNBT> info) {
        ListNBT listnbt2 = new ListNBT();
        for (MapPost mappost : this.posts.values()) {
            listnbt2.add((Object)mappost.write());
        }
        ((CompoundNBT)info.getReturnValue()).func_218657_a("posts", (INBT)listnbt2);
        return compound;
    }
}

