/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.network;

import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.block.util.IMapDisplay;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.fml.network.NetworkEvent;

public class RequestMapDataFromServerPacket {
    private final BlockPos pos;
    private final UUID id;

    public RequestMapDataFromServerPacket(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.id = buf.func_179253_g();
    }

    public RequestMapDataFromServerPacket(BlockPos pos, UUID id) {
        this.pos = pos;
        this.id = id;
    }

    public static void buffer(RequestMapDataFromServerPacket message, PacketBuffer buf) {
        buf.func_179255_a(message.pos);
        buf.func_179252_a(message.id);
    }

    public static void handler(RequestMapDataFromServerPacket message, Supplier<NetworkEvent.Context> ctx) {
        World world = Objects.requireNonNull(ctx.get().getSender()).field_70170_p;
        ctx.get().enqueueWork(() -> {
            TileEntity tileentity;
            if (world instanceof ServerWorld && (tileentity = world.func_175625_s(message.pos)) instanceof IMapDisplay) {
                ItemStack stack = ((IMapDisplay)tileentity).getMapStack();
                PlayerEntity player = world.func_217371_b(message.id);
                if (stack.func_77973_b() instanceof FilledMapItem) {
                    MapData data = FilledMapItem.func_219994_a((ItemStack)stack, (World)world);
                    FilledMapItem map = (FilledMapItem)stack.func_77973_b();
                    data.func_76191_a(player, stack);
                    map.func_77872_a(world, (Entity)player, data);
                    IPacket ipacket = map.func_150911_c(stack, world, player);
                    if (ipacket != null && player instanceof ServerPlayerEntity) {
                        ((ServerPlayerEntity)player).field_71135_a.func_147359_a(ipacket);
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

