/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.plugins.jei;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.mehvahdjukaar.supplementaries.items.BambooSpikesTippedItem;
import net.mehvahdjukaar.supplementaries.setup.Registry;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

@JeiPlugin
public class SupplementariesJEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("supplementaries", "plugin_supplementaries");
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)Registry.BAMBOO_SPIKES_TIPPED_ITEM.get(), (ISubtypeInterpreter)SpikesSubtypeInterpreter.INSTANCE);
    }

    public void registerRecipes(IRecipeRegistration registry) {
        registry.addRecipes(SupplementariesJEIPlugin.createTippedBambooSpikesRecipes(), VanillaRecipeCategoryUid.CRAFTING);
        registry.addRecipes(SupplementariesJEIPlugin.createBlackboardDuplicate(), VanillaRecipeCategoryUid.CRAFTING);
        registry.addRecipes(SupplementariesJEIPlugin.createBlackboardClear(), VanillaRecipeCategoryUid.CRAFTING);
    }

    public static List<IRecipe<?>> createTippedBambooSpikesRecipes() {
        ArrayList recipes = new ArrayList();
        String group = "supplementaries.jei.tipped_spikes";
        for (Potion potionType : ForgeRegistries.POTION_TYPES.getValues()) {
            if (potionType.func_185170_a().isEmpty()) continue;
            recipes.add((IRecipe<?>)SupplementariesJEIPlugin.makeSpikeRecipe(potionType, group));
        }
        return recipes;
    }

    private static ShapelessRecipe makeSpikeRecipe(Potion potionType, String group) {
        ItemStack spikes = new ItemStack((IItemProvider)Registry.BAMBOO_SPIKES_ITEM.get());
        ItemStack lingeringPotion = PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_185156_bI), (Potion)potionType);
        Ingredient spikeIngredient = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{spikes});
        Ingredient potionIngredient = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{lingeringPotion});
        NonNullList inputs = NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{spikeIngredient, potionIngredient});
        ItemStack output = BambooSpikesTippedItem.makeSpikeItem(potionType);
        ResourceLocation id = new ResourceLocation("supplementaries", potionType.func_185174_b("jei.tipped_spikes."));
        return new ShapelessRecipe(id, group, output, inputs);
    }

    public static List<IRecipe<?>> createBlackboardDuplicate() {
        ArrayList recipes = new ArrayList();
        String group = "supplementaries.jei.blackboard_duplicate";
        ItemStack blackboard = new ItemStack((IItemProvider)Registry.BLACKBOARD_ITEM.get());
        CompoundNBT com = new CompoundNBT();
        com.func_74773_a("pixels_0", new byte[]{0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0});
        com.func_74773_a("pixels_1", new byte[]{0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 1, 0});
        com.func_74773_a("pixels_2", new byte[]{0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0});
        com.func_74773_a("pixels_3", new byte[]{0, 0, 1, 0, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 0});
        com.func_74773_a("pixels_4", new byte[]{0, 0, 1, 0, 0, 1, 1, 0, 1, 1, 0, 1, 0, 0, 1, 0});
        com.func_74773_a("pixels_5", new byte[]{0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 1, 0});
        com.func_74773_a("pixels_6", new byte[]{0, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0});
        com.func_74773_a("pixels_7", new byte[]{0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 1, 1, 0, 1, 0, 0});
        com.func_74773_a("pixels_8", new byte[]{0, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0});
        com.func_74773_a("pixels_9", new byte[]{0, 0, 1, 0, 0, 1, 1, 0, 1, 0, 1, 0, 0, 1, 0, 0});
        com.func_74773_a("pixels_10", new byte[]{0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0});
        com.func_74773_a("pixels_11", new byte[]{0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0});
        com.func_74773_a("pixels_12", new byte[]{0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0});
        com.func_74773_a("pixels_13", new byte[]{0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0});
        com.func_74773_a("pixels_14", new byte[]{0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0});
        com.func_74773_a("pixels_15", new byte[]{0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0});
        blackboard.func_77983_a("BlockEntityTag", (INBT)com);
        Ingredient emptyBoard = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)Registry.BLACKBOARD_ITEM.get())});
        Ingredient fullBoard = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{blackboard});
        NonNullList inputs = NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{emptyBoard, fullBoard});
        ResourceLocation id = new ResourceLocation("supplementaries", "jei_blackboard_duplicate");
        ShapelessRecipe recipe = new ShapelessRecipe(id, group, blackboard, inputs);
        recipes.add((IRecipe<?>)recipe);
        return recipes;
    }

    public static List<IRecipe<?>> createBlackboardClear() {
        ArrayList recipes = new ArrayList();
        String group = "supplementaries.jei.blackboard_clear";
        ItemStack blackboard = new ItemStack((IItemProvider)Registry.BLACKBOARD_ITEM.get());
        CompoundNBT com = new CompoundNBT();
        com.func_74773_a("pixels_1", new byte[]{0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0});
        com.func_74773_a("pixels_0", new byte[]{0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0});
        com.func_74773_a("pixels_10", new byte[]{0, 1, 0, 0, 0, 1, 1, 1, 1, 0, 0, 1, 0, 1, 0, 1});
        com.func_74773_a("pixels_11", new byte[]{0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 1, 1, 0, 1, 0});
        com.func_74773_a("pixels_12", new byte[]{0, 0, 1, 0, 0, 0, 1, 1, 1, 0, 1, 1, 0, 0, 1, 0});
        com.func_74773_a("pixels_13", new byte[]{0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0});
        com.func_74773_a("pixels_14", new byte[]{0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0});
        com.func_74773_a("pixels_15", new byte[]{0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0});
        com.func_74773_a("pixels_3", new byte[]{0, 0, 1, 0, 0, 0, 1, 1, 1, 0, 1, 1, 0, 0, 1, 0});
        com.func_74773_a("pixels_2", new byte[]{0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0});
        com.func_74773_a("pixels_5", new byte[]{0, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 1});
        com.func_74773_a("pixels_4", new byte[]{0, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 0, 0, 1, 0});
        com.func_74773_a("pixels_7", new byte[]{0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 1});
        com.func_74773_a("pixels_6", new byte[]{0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1});
        com.func_74773_a("pixels_9", new byte[]{0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 0, 1});
        com.func_74773_a("pixels_8", new byte[]{0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1});
        blackboard.func_77983_a("BlockEntityTag", (INBT)com);
        Ingredient emptyBoard = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_151131_as)});
        Ingredient fullBoard = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{blackboard});
        NonNullList inputs = NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{emptyBoard, fullBoard});
        ResourceLocation id = new ResourceLocation("supplementaries", "jei_blackboard_clear");
        ShapelessRecipe recipe = new ShapelessRecipe(id, group, new ItemStack((IItemProvider)Registry.BLACKBOARD_ITEM.get()), inputs);
        recipes.add((IRecipe<?>)recipe);
        return recipes;
    }

    public static class SpikesSubtypeInterpreter
    implements ISubtypeInterpreter {
        public static final SpikesSubtypeInterpreter INSTANCE = new SpikesSubtypeInterpreter();

        private SpikesSubtypeInterpreter() {
        }

        public String apply(ItemStack itemStack) {
            Potion potionType = PotionUtils.func_185191_c((ItemStack)itemStack);
            String potionTypeString = potionType.func_185174_b("");
            StringBuilder stringBuilder = new StringBuilder(potionTypeString);
            List effects = PotionUtils.func_185189_a((ItemStack)itemStack);
            for (EffectInstance effect : effects) {
                stringBuilder.append(";").append(effect);
            }
            return stringBuilder.toString();
        }
    }
}

