/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.setup;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.block.blocks.BambooSpikesBlock;
import net.mehvahdjukaar.supplementaries.block.blocks.FireflyJarBlock;
import net.mehvahdjukaar.supplementaries.block.blocks.LightUpBlock;
import net.mehvahdjukaar.supplementaries.block.tiles.JarBlockTile;
import net.mehvahdjukaar.supplementaries.common.CommonUtil;
import net.mehvahdjukaar.supplementaries.configs.RegistryConfigs;
import net.mehvahdjukaar.supplementaries.items.EmptyJarItem;
import net.mehvahdjukaar.supplementaries.items.JarItem;
import net.mehvahdjukaar.supplementaries.items.SackItem;
import net.mehvahdjukaar.supplementaries.setup.Registry;
import net.minecraft.block.BlockState;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.OptionalDispenseBehavior;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DirectionalPlaceContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.DispenserTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class Dispenser {
    public static Map<Item, IDispenseItemBehavior> DEFAULT_BEHAVIORS;
    private static final DefaultDispenseItemBehavior spawneggBehavior;
    private static final DefaultDispenseItemBehavior defaultBehaviour;

    public static void registerBehaviors() {
        if (!((Boolean)RegistryConfigs.reg.DISPENSERS.get()).booleanValue()) {
            return;
        }
        DEFAULT_BEHAVIORS = Dispenser.getVanillaDispenserBehaviors();
        if (DEFAULT_BEHAVIORS == null) {
            Supplementaries.LOGGER.info("failed to register dispenser behaviors");
            return;
        }
        if (((Boolean)RegistryConfigs.reg.JAR_ENABLED.get()).booleanValue()) {
            for (Item item2 : ForgeRegistries.ITEMS) {
                if (item2 instanceof JarItem || item2 instanceof EmptyJarItem || item2 instanceof SackItem || item2 instanceof BlockItem && ((BlockItem)item2).func_179223_d() instanceof FireflyJarBlock) {
                    DispenserBlock.func_199774_a((IItemProvider)item2, (IDispenseItemBehavior)new PlaceBlockDispenseBehavior());
                    continue;
                }
                if (CommonUtil.getJarContentTypeFromItem(new ItemStack((IItemProvider)item2)).isEmpty()) continue;
                DispenserBlock.func_199774_a((IItemProvider)item2, (IDispenseItemBehavior)new FillJarDispenserBehavior());
            }
            DispenserBlock.func_199774_a((IItemProvider)Items.field_151133_ar, (IDispenseItemBehavior)new BucketJarDispenserBehavior());
            DispenserBlock.func_199774_a((IItemProvider)Items.field_151054_z, (IDispenseItemBehavior)new BowlJarDispenserBehavior());
            DispenserBlock.func_199774_a((IItemProvider)Items.field_151069_bo, (IDispenseItemBehavior)new BottleJarDispenserBehavior());
            DispenserBlock.func_199774_a((IItemProvider)Items.field_151033_d, (IDispenseItemBehavior)new FlintAndSteelDispenserBehavior());
            DispenserBlock.func_199774_a((IItemProvider)Items.field_185156_bI, (IDispenseItemBehavior)new BambooSpikesDispenserBehavior());
        }
        if (((Boolean)RegistryConfigs.reg.FIREFLY_ENABLED.get()).booleanValue()) {
            DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)Registry.FIREFLY_SPAWN_EGG_ITEM.get()), (IDispenseItemBehavior)spawneggBehavior);
        }
    }

    private static Map<Item, IDispenseItemBehavior> getVanillaDispenserBehaviors() {
        try {
            Field f = ObfuscationReflectionHelper.findField(DispenserBlock.class, (String)"field_149943_a");
            f.setAccessible(true);
            Map m = (Map)f.get(null);
            HashMap<Item, IDispenseItemBehavior> map = new HashMap<Item, IDispenseItemBehavior>();
            for (Item i : m.keySet()) {
                map.put(i, (IDispenseItemBehavior)m.get(i));
            }
            return map;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static boolean MergeDispenserItem(DispenserTileEntity te, ItemStack filled) {
        try {
            Field f = ObfuscationReflectionHelper.findField(DispenserTileEntity.class, (String)"field_146022_i");
            f.setAccessible(true);
            NonNullList stacks = (NonNullList)f.get(te);
            for (int i = 0; i < te.func_70302_i_(); ++i) {
                ItemStack s = (ItemStack)stacks.get(i);
                if (!s.func_190926_b() && (s.func_77973_b() != filled.func_77973_b() || s.func_77976_d() <= s.func_190916_E())) continue;
                filled.func_190917_f(s.func_190916_E());
                te.func_70299_a(i, filled);
                return true;
            }
        }
        catch (Exception ignored) {
            return te.func_146019_a(filled.func_77946_l()) < 0;
        }
        return false;
    }

    public static ItemStack glassBottleFill(IBlockSource source, ItemStack empty, ItemStack filled) {
        empty.func_190918_g(1);
        if (empty.func_190926_b()) {
            return filled.func_77946_l();
        }
        if (!Dispenser.MergeDispenserItem((DispenserTileEntity)source.func_150835_j(), filled)) {
            defaultBehaviour.dispense(source, filled.func_77946_l());
        }
        return empty;
    }

    static {
        spawneggBehavior = new DefaultDispenseItemBehavior(){

            public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                Direction direction = (Direction)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a);
                EntityType entitytype = ((SpawnEggItem)stack.func_77973_b()).func_208076_b(stack.func_77978_p());
                entitytype.func_220331_a(source.func_197524_h(), stack, null, source.func_180699_d().func_177972_a(direction), SpawnReason.DISPENSER, direction != Direction.UP, false);
                stack.func_190918_g(1);
                return stack;
            }
        };
        defaultBehaviour = new DefaultDispenseItemBehavior();
    }

    public static class PlaceBlockDispenseBehavior
    extends OptionalDispenseBehavior {
        protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            this.field_218407_b = false;
            Item item2 = stack.func_77973_b();
            if (item2 instanceof BlockItem) {
                Direction direction = (Direction)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a);
                BlockPos blockpos = source.func_180699_d().func_177972_a(direction);
                Direction direction1 = source.func_197524_h().func_175623_d(blockpos.func_177977_b()) ? direction : Direction.UP;
                ActionResultType result = ((BlockItem)item2).func_195942_a((BlockItemUseContext)new DirectionalPlaceContext(source.func_197524_h(), blockpos, direction, stack, direction1));
                this.field_218407_b = result.func_226246_a_();
            }
            return stack;
        }
    }

    public static class BowlJarDispenserBehavior
    extends AdditionalDispenserBehavior {
        @Override
        protected ItemStack customBehavior(IBlockSource source, ItemStack stack) {
            BlockPos blockpos;
            World world = source.func_197524_h();
            TileEntity te = world.func_175625_s(blockpos = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a)));
            if (te instanceof JarBlockTile) {
                ItemStack returnitem;
                JarBlockTile tile = (JarBlockTile)te;
                if (tile.liquidType.bowl && (returnitem = tile.extractItem(2)) != null) {
                    tile.func_70296_d();
                    return Dispenser.glassBottleFill(source, stack, returnitem);
                }
            }
            return super.customBehavior(source, stack);
        }
    }

    public static class BottleJarDispenserBehavior
    extends AdditionalDispenserBehavior {
        @Override
        protected ItemStack customBehavior(IBlockSource source, ItemStack stack) {
            BlockPos blockpos;
            World world = source.func_197524_h();
            TileEntity te = world.func_175625_s(blockpos = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a)));
            if (te instanceof JarBlockTile) {
                ItemStack returnitem;
                JarBlockTile tile = (JarBlockTile)te;
                if (tile.liquidType.bottle && (returnitem = tile.extractItem(1)) != null) {
                    tile.func_70296_d();
                    return Dispenser.glassBottleFill(source, stack, returnitem);
                }
            }
            return super.customBehavior(source, stack);
        }
    }

    public static class BucketJarDispenserBehavior
    extends AdditionalDispenserBehavior {
        @Override
        protected ItemStack customBehavior(IBlockSource source, ItemStack stack) {
            BlockPos blockpos;
            World world = source.func_197524_h();
            TileEntity te = world.func_175625_s(blockpos = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a)));
            if (te instanceof JarBlockTile) {
                ItemStack returnitem;
                JarBlockTile tile = (JarBlockTile)te;
                if (tile.liquidType.bucket && (returnitem = tile.extractItem(3)) != null) {
                    tile.func_70296_d();
                    return Dispenser.glassBottleFill(source, stack, returnitem);
                }
            }
            return super.customBehavior(source, stack);
        }
    }

    public static class BambooSpikesDispenserBehavior
    extends AdditionalDispenserBehavior {
        @Override
        protected ItemStack customBehavior(IBlockSource source, ItemStack stack) {
            BlockPos blockpos;
            World world = source.func_197524_h();
            BlockState state = world.func_180495_p(blockpos = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a)));
            if (state.func_177230_c() instanceof BambooSpikesBlock) {
                if (BambooSpikesBlock.tryAddingPotion(state, (IWorld)world, blockpos, stack)) {
                    return Dispenser.glassBottleFill(source, stack, new ItemStack((IItemProvider)Items.field_151069_bo));
                }
                return stack;
            }
            return super.customBehavior(source, stack);
        }
    }

    public static class FlintAndSteelDispenserBehavior
    extends AdditionalDispenserBehavior {
        @Override
        protected ItemStack customBehavior(IBlockSource source, ItemStack stack) {
            BlockPos blockpos;
            World world = source.func_197524_h();
            BlockState state = world.func_180495_p(blockpos = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a)));
            if (state.func_177230_c() instanceof LightUpBlock) {
                if (LightUpBlock.lightUp(state, blockpos, (IWorld)world, LightUpBlock.FireSound.FLINT_AND_STEEL) && stack.func_96631_a(1, world.field_73012_v, (ServerPlayerEntity)null)) {
                    stack.func_190920_e(0);
                }
                return stack;
            }
            return super.customBehavior(source, stack);
        }
    }

    public static class FillJarDispenserBehavior
    extends AdditionalDispenserBehavior {
        @Override
        protected ItemStack customBehavior(IBlockSource source, ItemStack stack) {
            JarBlockTile tile;
            BlockPos blockpos;
            World world = source.func_197524_h();
            TileEntity te = world.func_175625_s(blockpos = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a)));
            if (te instanceof JarBlockTile && (tile = (JarBlockTile)te).func_94041_b(0, stack)) {
                tile.handleAddItem(stack, null, null);
                tile.func_70296_d();
                return Dispenser.glassBottleFill(source, stack, new ItemStack((IItemProvider)(stack.func_77973_b() == Items.field_151131_as ? Items.field_151133_ar : tile.liquidType.getReturnItem())));
            }
            return super.customBehavior(source, stack);
        }
    }

    public static abstract class AdditionalDispenserBehavior
    extends DefaultDispenseItemBehavior {
        public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            try {
                return this.customBehavior(source, stack);
            }
            catch (Exception e) {
                return defaultBehaviour.dispense(source, stack);
            }
        }

        protected ItemStack customBehavior(IBlockSource source, ItemStack stack) {
            return DEFAULT_BEHAVIORS.get(stack.func_77973_b()).dispense(source, stack);
        }
    }
}

