/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.setup.registration;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.block.blocks.HangingSignBlock;
import net.mehvahdjukaar.supplementaries.datagen.types.IWoodType;
import net.mehvahdjukaar.supplementaries.datagen.types.WoodTypes;
import net.mehvahdjukaar.supplementaries.items.BurnableBlockItem;
import net.mehvahdjukaar.supplementaries.items.SignPostItem;
import net.mehvahdjukaar.supplementaries.setup.Registry;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Variants {
    public static boolean hasWood(IWoodType wood) {
        return ModList.get().isLoaded(wood.getNamespace());
    }

    public static <T extends IForgeRegistryEntry<T>> Map<IWoodType, RegistryObject<T>> makeVariants(DeferredRegister<T> registry, String name, Supplier<T> supplier) {
        HashMap<IWoodType, RegistryObject<T>> map = new HashMap<IWoodType, RegistryObject<T>>();
        for (IWoodType wood : WoodTypes.TYPES.values()) {
            String s = name + "_" + wood;
            map.put(wood, registry.register(s, supplier));
        }
        return map;
    }

    public static Map<IWoodType, RegistryObject<Block>> makeHangingSingsBlocks() {
        HashMap<IWoodType, RegistryObject<Block>> map = new HashMap<IWoodType, RegistryObject<Block>>();
        for (IWoodType wood : WoodTypes.TYPES.values()) {
            String name = Variants.getHangingSignName(wood);
            map.put(wood, (RegistryObject<Block>)Registry.BLOCKS.register(name, () -> new HangingSignBlock(Block.Properties.func_200949_a((Material)wood.getMaterial(), (MaterialColor)wood.getColor()).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a).harvestTool(ToolType.AXE).func_226896_b_().func_200942_a())));
        }
        return map;
    }

    public static Map<IWoodType, RegistryObject<Item>> makeHangingSignsItems() {
        HashMap<IWoodType, RegistryObject<Item>> map = new HashMap<IWoodType, RegistryObject<Item>>();
        for (IWoodType wood : WoodTypes.TYPES.values()) {
            String name = Variants.getHangingSignName(wood);
            map.put(wood, (RegistryObject<Item>)Registry.ITEMS.register(name, () -> new BurnableBlockItem((Block)Registry.HANGING_SIGNS.get(wood).get(), new Item.Properties().func_200916_a(Registry.getTab(!Variants.hasWood(wood) ? null : ItemGroup.field_78031_c, "hanging_sign")), 200)));
        }
        return map;
    }

    public static Map<IWoodType, RegistryObject<Item>> makeSignPostItems() {
        HashMap<IWoodType, RegistryObject<Item>> map = new HashMap<IWoodType, RegistryObject<Item>>();
        for (IWoodType wood : WoodTypes.TYPES.values()) {
            String name = Variants.getSignPostName(wood);
            map.put(wood, (RegistryObject<Item>)Registry.ITEMS.register(name, () -> new SignPostItem(new Item.Properties().func_200916_a(!Variants.hasWood(wood) ? null : Registry.getTab(ItemGroup.field_78031_c, "sign_post")), wood)));
        }
        return map;
    }

    public static String getHangingSignName(IWoodType type) {
        return "hanging_sign_" + type.getRegName();
    }

    public static String getSignPostName(IWoodType type) {
        return "sign_post_" + type.getRegName();
    }
}

