/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.terracraft.block;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.mcreator.terracraft.TerracraftModElements;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeature;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

@TerracraftModElements.ModElement.Tag
public class SnowBlock
extends TerracraftModElements.ModElement {
    @ObjectHolder(value="terracraft:snow")
    public static final Block block = null;

    public SnowBlock(TerracraftModElements instance) {
        super(instance, 1428);
    }

    @Override
    public void initElements() {
        this.elements.blocks.add(() -> new CustomBlock());
        this.elements.items.add(() -> (Item)new BlockItem(block, new Item.Properties().func_200916_a(null)).setRegistryName(block.getRegistryName()));
    }

    @Override
    public void init(FMLCommonSetupEvent event) {
        for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
            boolean biomeCriteria = false;
            if (ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome).equals((Object)new ResourceLocation("frozen_river"))) {
                biomeCriteria = true;
            }
            if (ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome).equals((Object)new ResourceLocation("snowy_tundra"))) {
                biomeCriteria = true;
            }
            if (ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome).equals((Object)new ResourceLocation("snowy_mountains"))) {
                biomeCriteria = true;
            }
            if (ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome).equals((Object)new ResourceLocation("snowy_taiga"))) {
                biomeCriteria = true;
            }
            if (ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome).equals((Object)new ResourceLocation("snowy_taiga_hills"))) {
                biomeCriteria = true;
            }
            if (!biomeCriteria) continue;
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, new OreFeature(OreFeatureConfig::func_214641_a){

                public boolean func_212245_a(IWorld world, ChunkGenerator generator, Random rand, BlockPos pos, OreFeatureConfig config) {
                    DimensionType dimensionType = world.func_201675_m().func_186058_p();
                    boolean dimensionCriteria = false;
                    if (dimensionType == DimensionType.field_223227_a_) {
                        dimensionCriteria = true;
                    }
                    if (!dimensionCriteria) {
                        return false;
                    }
                    return super.func_212245_a(world, generator, rand, pos, config);
                }
            }.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.create((String)"snow", (String)"snow", blockAt -> {
                boolean blockCriteria = false;
                if (blockAt.func_177230_c() == Blocks.field_150348_b.func_176223_P().func_177230_c()) {
                    blockCriteria = true;
                }
                return blockCriteria;
            }), block.func_176223_P(), 30)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(30, 30, 30, 64))));
        }
    }

    public static class CustomBlock
    extends Block {
        public CustomBlock() {
            super(Block.Properties.func_200945_a((Material)Material.field_151578_c).func_200947_a(SoundType.field_185854_g).func_200948_a(1.0f, 0.2f).func_200951_a(0).harvestLevel(1).harvestTool(ToolType.SHOVEL).func_200941_a(0.7f));
            this.setRegistryName("snow");
        }

        public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
            List dropsOriginal = super.func_220076_a(state, builder);
            if (!dropsOriginal.isEmpty()) {
                return dropsOriginal;
            }
            return Collections.singletonList(new ItemStack((IItemProvider)Blocks.field_196604_cC, 1));
        }

        @OnlyIn(value=Dist.CLIENT)
        public void func_180655_c(BlockState state, World world, BlockPos pos, Random random) {
            super.func_180655_c(state, world, pos, random);
            ClientPlayerEntity entity = Minecraft.func_71410_x().field_71439_g;
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            for (int l = 0; l < 1; ++l) {
                double d0 = (float)x + random.nextFloat();
                double d1 = (float)y + random.nextFloat();
                double d2 = (float)z + random.nextFloat();
                int i1 = random.nextInt(2) * 2 - 1;
                double d3 = ((double)random.nextFloat() - 0.5) * 0.1;
                double d4 = ((double)random.nextFloat() - 0.5) * 0.1;
                double d5 = ((double)random.nextFloat() - 0.5) * 0.1;
                world.func_195594_a((IParticleData)ParticleTypes.field_197602_M, d0, d1, d2, d3, d4, d5);
            }
        }
    }
}

