/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.terracraft.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.mcreator.terracraft.TerracraftModElements;
import net.mcreator.terracraft.gui.GuideGUIGui;
import net.mcreator.terracraft.procedures.BugnetguideprocedureProcedure;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveTowardsVillageGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.EntityArmorInvWrapper;
import net.minecraftforge.items.wrapper.EntityHandsInvWrapper;
import net.minecraftforge.registries.ForgeRegistries;

@TerracraftModElements.ModElement.Tag
public class GuideEntity
extends TerracraftModElements.ModElement {
    public static EntityType entity = null;

    public GuideEntity(TerracraftModElements instance) {
        super(instance, 1311);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
    }

    @Override
    public void initElements() {
        entity = (EntityType)EntityType.Builder.func_220322_a(CustomEntity::new, (EntityClassification)EntityClassification.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(CustomEntity::new).func_220321_a(0.6f, 1.8f).func_206830_a("guide").setRegistryName("guide");
        this.elements.entities.add(() -> entity);
        this.elements.items.add(() -> (Item)new SpawnEggItem(entity, -7180759, -10718066, new Item.Properties().func_200916_a(ItemGroup.field_78026_f)).setRegistryName("guide_spawn_egg"));
    }

    @Override
    public void init(FMLCommonSetupEvent event) {
        for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
            biome.func_76747_a(EntityClassification.MONSTER).add(new Biome.SpawnListEntry(entity, 1, 1, 1));
        }
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)entity, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223324_d);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        RenderingRegistry.registerEntityRenderingHandler((EntityType)entity, renderManager -> new MobRenderer(renderManager, new ModelGuide(), 0.5f){

            public ResourceLocation func_110775_a(Entity entity) {
                return new ResourceLocation("terracraft:textures/guide.png");
            }
        });
    }

    public static class ModelGuide
    extends EntityModel<Entity> {
        ModelRenderer Head;
        ModelRenderer Body;
        ModelRenderer LeftArm;
        ModelRenderer RightArm;
        ModelRenderer LeftLeg;
        ModelRenderer RightLeg;
        ModelRenderer Hair;
        ModelRenderer HairTop;
        ModelRenderer Leftsideburn;
        ModelRenderer Rightsideburn;

        public ModelGuide() {
            this.field_78090_t = 64;
            this.field_78089_u = 64;
            this.Head = new ModelRenderer((Model)this, 26, 5);
            this.Head.func_228300_a_(-3.5f, -7.0f, -3.55f, 7.0f, 7.0f, 7.0f);
            this.Head.func_78793_a(0.0f, 0.0f, 0.0f);
            this.Head.func_78787_b(64, 32);
            this.Head.field_78809_i = true;
            this.setRotation(this.Head, 0.0f, 0.0f, 0.0f);
            this.Body = new ModelRenderer((Model)this, 0, 3);
            this.Body.func_228300_a_(-4.0f, 0.0f, -3.0f, 8.0f, 12.0f, 4.0f);
            this.Body.func_78793_a(0.0f, 0.0f, 1.0f);
            this.Body.func_78787_b(64, 32);
            this.Body.field_78809_i = true;
            this.setRotation(this.Body, 0.0f, 0.0f, 0.0f);
            this.LeftArm = new ModelRenderer((Model)this, 17, 19);
            this.LeftArm.func_228300_a_(-1.0f, 0.0f, -1.5f, 3.0f, 13.0f, 3.0f);
            this.LeftArm.func_78793_a(5.0f, 0.0f, 0.0f);
            this.LeftArm.func_78787_b(64, 32);
            this.LeftArm.field_78809_i = true;
            this.setRotation(this.LeftArm, 0.0f, 0.0f, 0.0f);
            this.RightArm = new ModelRenderer((Model)this, 17, 19);
            this.RightArm.func_228300_a_(-2.0f, 0.0f, -1.5f, 3.0f, 13.0f, 3.0f);
            this.RightArm.func_78793_a(-5.0f, 0.0f, 0.0f);
            this.RightArm.func_78787_b(64, 32);
            this.RightArm.field_78809_i = true;
            this.setRotation(this.RightArm, 0.0f, 0.0f, 0.0f);
            this.LeftLeg = new ModelRenderer((Model)this, 0, 19);
            this.LeftLeg.func_228300_a_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f);
            this.LeftLeg.func_78793_a(2.0f, 12.0f, 0.0f);
            this.LeftLeg.func_78787_b(64, 32);
            this.LeftLeg.field_78809_i = true;
            this.setRotation(this.LeftLeg, 0.0f, 0.0f, 0.0f);
            this.RightLeg = new ModelRenderer((Model)this, 0, 19);
            this.RightLeg.func_228300_a_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f);
            this.RightLeg.func_78793_a(-2.0f, 12.0f, 0.0f);
            this.RightLeg.func_78787_b(64, 32);
            this.RightLeg.field_78809_i = true;
            this.setRotation(this.RightLeg, 0.0f, 0.0f, 0.0f);
            this.Hair = new ModelRenderer((Model)this, 0, 35);
            this.Hair.func_228300_a_(-3.5f, -9.0f, -6.5f, 7.0f, 3.0f, 9.0f);
            this.Hair.func_78793_a(0.0f, 0.0f, 0.0f);
            this.Hair.func_78787_b(64, 32);
            this.Hair.field_78809_i = true;
            this.setRotation(this.Hair, -0.2792527f, 0.0f, 0.0f);
            this.HairTop = new ModelRenderer((Model)this, 0, 47);
            this.HairTop.func_228300_a_(-3.0f, -11.0f, -4.0f, 6.0f, 3.0f, 2.0f);
            this.HairTop.func_78793_a(0.0f, 0.0f, 0.0f);
            this.HairTop.func_78787_b(64, 32);
            this.HairTop.field_78809_i = true;
            this.setRotation(this.HairTop, 0.1745329f, 0.0f, 0.0f);
            this.Leftsideburn = new ModelRenderer((Model)this, 0, 52);
            this.Leftsideburn.func_228300_a_(3.0f, -8.0f, -1.0f, 1.0f, 6.0f, 5.0f);
            this.Leftsideburn.func_78793_a(0.0f, 0.0f, 0.0f);
            this.Leftsideburn.func_78787_b(64, 32);
            this.Leftsideburn.field_78809_i = true;
            this.setRotation(this.Leftsideburn, 0.0f, 0.0f, 0.0f);
            this.Rightsideburn = new ModelRenderer((Model)this, 0, 52);
            this.Rightsideburn.func_228300_a_(-4.0f, -8.0f, -1.0f, 1.0f, 6.0f, 5.0f);
            this.Rightsideburn.func_78793_a(0.0f, 0.0f, 0.0f);
            this.Rightsideburn.func_78787_b(64, 32);
            this.Rightsideburn.field_78809_i = true;
            this.setRotation(this.Rightsideburn, 0.0f, 0.0f, 0.0f);
        }

        public void func_225598_a_(MatrixStack ms, IVertexBuilder vb, int i1, int i2, float f1, float f2, float f3, float f4) {
            this.Head.func_228309_a_(ms, vb, i1, i2, f1, f2, f3, f4);
            this.Body.func_228309_a_(ms, vb, i1, i2, f1, f2, f3, f4);
            this.LeftArm.func_228309_a_(ms, vb, i1, i2, f1, f2, f3, f4);
            this.RightArm.func_228309_a_(ms, vb, i1, i2, f1, f2, f3, f4);
            this.LeftLeg.func_228309_a_(ms, vb, i1, i2, f1, f2, f3, f4);
            this.RightLeg.func_228309_a_(ms, vb, i1, i2, f1, f2, f3, f4);
            this.Hair.func_228309_a_(ms, vb, i1, i2, f1, f2, f3, f4);
            this.HairTop.func_228309_a_(ms, vb, i1, i2, f1, f2, f3, f4);
            this.Leftsideburn.func_228309_a_(ms, vb, i1, i2, f1, f2, f3, f4);
            this.Rightsideburn.func_228309_a_(ms, vb, i1, i2, f1, f2, f3, f4);
        }

        private void setRotation(ModelRenderer model, float x, float y, float z) {
            model.field_78795_f = x;
            model.field_78796_g = y;
            model.field_78808_h = z;
        }

        public void func_225597_a_(Entity e, float f, float f1, float f2, float f3, float f4) {
            this.Hair.field_78796_g = f3 / 57.295776f;
            this.Hair.field_78795_f = f4 / 57.295776f;
            this.HairTop.field_78796_g = f3 / 57.295776f;
            this.HairTop.field_78795_f = f4 / 57.295776f;
            this.RightArm.field_78795_f = MathHelper.func_76134_b((float)(f * 0.6662f + (float)Math.PI)) * f1;
            this.LeftLeg.field_78795_f = MathHelper.func_76134_b((float)(f * 1.0f)) * -1.0f * f1;
            this.Head.field_78796_g = f3 / 57.295776f;
            this.Head.field_78795_f = f4 / 57.295776f;
            this.LeftArm.field_78795_f = MathHelper.func_76134_b((float)(f * 0.6662f)) * f1;
            this.RightLeg.field_78795_f = MathHelper.func_76134_b((float)(f * 1.0f)) * 1.0f * f1;
            this.Leftsideburn.field_78796_g = f3 / 57.295776f;
            this.Leftsideburn.field_78795_f = f4 / 57.295776f;
            this.Rightsideburn.field_78796_g = f3 / 57.295776f;
            this.Rightsideburn.field_78795_f = f4 / 57.295776f;
        }
    }

    public static class CustomEntity
    extends CreatureEntity {
        private final ItemStackHandler inventory = new ItemStackHandler(31){

            public int getSlotLimit(int slot) {
                return 64;
            }
        };
        private final CombinedInvWrapper combined = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory, new EntityHandsInvWrapper((LivingEntity)this), new EntityArmorInvWrapper((LivingEntity)this)});

        public CustomEntity(FMLPlayMessages.SpawnEntity packet, World world) {
            this((EntityType<CustomEntity>)entity, world);
        }

        public CustomEntity(EntityType<CustomEntity> type, World world) {
            super(type, world);
            this.field_70728_aV = 0;
            this.func_94061_f(false);
        }

        public IPacket<?> func_213297_N() {
            return NetworkHooks.getEntitySpawningPacket((Entity)this);
        }

        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70714_bg.func_75776_a(1, (Goal)new LookRandomlyGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(2, (Goal)new SwimGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(3, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
            this.field_70714_bg.func_75776_a(4, (Goal)new PanicGoal((CreatureEntity)this, 1.2));
            this.field_70714_bg.func_75776_a(5, (Goal)new OpenDoorGoal((MobEntity)this, false));
            this.field_70714_bg.func_75776_a(6, (Goal)new OpenDoorGoal((MobEntity)this, true));
            this.field_70714_bg.func_75776_a(7, (Goal)new MoveTowardsVillageGoal((CreatureEntity)this, 0.5));
        }

        public CreatureAttribute func_70668_bt() {
            return CreatureAttribute.field_223222_a_;
        }

        public SoundEvent func_184639_G() {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.villager.ambient"));
        }

        public SoundEvent func_184601_bQ(DamageSource ds) {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.hurt"));
        }

        public SoundEvent func_184615_bR() {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.death"));
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            double x = this.func_226277_ct_();
            double y = this.func_226278_cu_();
            double z = this.func_226281_cx_();
            CustomEntity entity = this;
            Entity sourceentity = source.func_76346_g();
            HashMap<String, Object> $_dependencies = new HashMap<String, Object>();
            $_dependencies.put("entity", (Object)entity);
            $_dependencies.put("sourceentity", sourceentity);
            $_dependencies.put("x", x);
            $_dependencies.put("y", y);
            $_dependencies.put("z", z);
            $_dependencies.put("world", this.field_70170_p);
            BugnetguideprocedureProcedure.executeProcedure($_dependencies);
            if (source == DamageSource.field_76367_g) {
                return false;
            }
            return super.func_70097_a(source, amount);
        }

        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
            if (this.func_70089_S() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && side == null) {
                return LazyOptional.of(() -> this.combined).cast();
            }
            return super.getCapability(capability, side);
        }

        protected void func_213337_cE() {
            super.func_213337_cE();
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                ItemStack itemstack = this.inventory.getStackInSlot(i);
                if (itemstack.func_190926_b() || EnchantmentHelper.func_190939_c((ItemStack)itemstack)) continue;
                this.func_199701_a_(itemstack);
            }
        }

        public void func_213281_b(CompoundNBT compound) {
            super.func_213281_b(compound);
            compound.func_218657_a("InventoryCustom", (INBT)this.inventory.serializeNBT());
        }

        public void func_70037_a(CompoundNBT compound) {
            super.func_70037_a(compound);
            INBT inventoryCustom = compound.func_74781_a("InventoryCustom");
            if (inventoryCustom instanceof CompoundNBT) {
                this.inventory.deserializeNBT((CompoundNBT)inventoryCustom);
            }
        }

        public boolean func_184645_a(final PlayerEntity sourceentity, Hand hand) {
            ItemStack itemstack = sourceentity.func_184586_b(hand);
            boolean retval = true;
            if (sourceentity instanceof ServerPlayerEntity) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)sourceentity), (INamedContainerProvider)new INamedContainerProvider(){

                    public ITextComponent func_145748_c_() {
                        return new StringTextComponent("Guide");
                    }

                    public Container createMenu(int id, PlayerInventory inventory, PlayerEntity player) {
                        PacketBuffer packetBuffer = new PacketBuffer(Unpooled.buffer());
                        packetBuffer.func_179255_a(new BlockPos((Entity)sourceentity));
                        packetBuffer.writeByte(0);
                        packetBuffer.func_150787_b(this.func_145782_y());
                        return new GuideGUIGui.GuiContainerMod(id, inventory, packetBuffer);
                    }
                }, buf -> {
                    buf.func_179255_a(new BlockPos((Entity)sourceentity));
                    buf.writeByte(0);
                    buf.func_150787_b(this.func_145782_y());
                });
            }
            super.func_184645_a(sourceentity, hand);
            double x = this.func_226277_ct_();
            double y = this.func_226278_cu_();
            double z = this.func_226281_cx_();
            CustomEntity entity = this;
            return retval;
        }

        protected void func_110147_ax() {
            super.func_110147_ax();
            if (this.func_110148_a(SharedMonsterAttributes.field_111263_d) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_111267_a) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_188791_g) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(0.0);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_111264_e) == null) {
                this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
            }
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
        }
    }
}

