/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.terracraft.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import net.mcreator.terracraft.TerracraftModElements;
import net.mcreator.terracraft.item.SporeItem;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.SlimeModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@TerracraftModElements.ModElement.Tag
public class SporeentityEntity
extends TerracraftModElements.ModElement {
    public static EntityType entity = null;

    public SporeentityEntity(TerracraftModElements instance) {
        super(instance, 813);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
    }

    @Override
    public void initElements() {
        entity = (EntityType)EntityType.Builder.func_220322_a(CustomEntity::new, (EntityClassification)EntityClassification.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(40).setUpdateInterval(3).setCustomClientFactory(CustomEntity::new).func_220320_c().func_220321_a(0.5f, 0.5f).func_206830_a("sporeentity").setRegistryName("sporeentity");
        this.elements.entities.add(() -> entity);
        this.elements.items.add(() -> (Item)new SpawnEggItem(entity, -12884990, -6770308, new Item.Properties().func_200916_a(ItemGroup.field_78026_f)).setRegistryName("sporeentity_spawn_egg"));
    }

    @Override
    public void init(FMLCommonSetupEvent event) {
        for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
            boolean biomeCriteria = false;
            if (ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome).equals((Object)new ResourceLocation("jungle"))) {
                biomeCriteria = true;
            }
            if (ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome).equals((Object)new ResourceLocation("jungle_hills"))) {
                biomeCriteria = true;
            }
            if (ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome).equals((Object)new ResourceLocation("jungle_edge"))) {
                biomeCriteria = true;
            }
            if (ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome).equals((Object)new ResourceLocation("bamboo_jungle"))) {
                biomeCriteria = true;
            }
            if (ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome).equals((Object)new ResourceLocation("bamboo_jungle_hills"))) {
                biomeCriteria = true;
            }
            if (!biomeCriteria) continue;
            biome.func_76747_a(EntityClassification.MONSTER).add(new Biome.SpawnListEntry(entity, 25, 1, 1));
        }
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)entity, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223324_d);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        RenderingRegistry.registerEntityRenderingHandler((EntityType)entity, renderManager -> new MobRenderer(renderManager, (EntityModel)new SlimeModel(0), 0.5f){
            {
                this.func_177094_a(new GlowingLayer(this));
            }

            public ResourceLocation func_110775_a(Entity entity) {
                return new ResourceLocation("terracraft:textures/spore.png");
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class GlowingLayer<T extends Entity, M extends EntityModel<T>>
    extends LayerRenderer<T, M> {
        public GlowingLayer(IEntityRenderer<T, M> er) {
            super(er);
        }

        public void func_225628_a_(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228652_i_((ResourceLocation)new ResourceLocation("terracraft:textures/spore.png")));
            this.func_215332_c().func_225598_a_(matrixStackIn, ivertexbuilder, 0xF00000, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public static class CustomEntity
    extends MonsterEntity {
        public CustomEntity(FMLPlayMessages.SpawnEntity packet, World world) {
            this((EntityType<CustomEntity>)entity, world);
        }

        public CustomEntity(EntityType<CustomEntity> type, World world) {
            super(type, world);
            this.field_70728_aV = 0;
            this.func_94061_f(false);
            this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Blocks.field_150478_aa, 1));
        }

        public IPacket<?> func_213297_N() {
            return NetworkHooks.getEntitySpawningPacket((Entity)this);
        }

        protected void func_184651_r() {
            super.func_184651_r();
        }

        public CreatureAttribute func_70668_bt() {
            return CreatureAttribute.field_223222_a_;
        }

        protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
            super.func_213333_a(source, looting, recentlyHitIn);
            this.func_199701_a_(new ItemStack((IItemProvider)SporeItem.block, 1));
        }

        public SoundEvent func_184601_bQ(DamageSource ds) {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.hurt"));
        }

        public SoundEvent func_184615_bR() {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.death"));
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            if (source.func_76364_f() instanceof ArrowEntity) {
                return false;
            }
            if (source.func_76364_f() instanceof PotionEntity) {
                return false;
            }
            if (source == DamageSource.field_76379_h) {
                return false;
            }
            if (source == DamageSource.field_76367_g) {
                return false;
            }
            if (source == DamageSource.field_76369_e) {
                return false;
            }
            if (source == DamageSource.field_180137_b) {
                return false;
            }
            return super.func_70097_a(source, amount);
        }

        protected void func_110147_ax() {
            super.func_110147_ax();
            if (this.func_110148_a(SharedMonsterAttributes.field_111263_d) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_111267_a) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(1.0);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_188791_g) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(0.0);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_111264_e) == null) {
                this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
            }
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(0.0);
        }

        public void func_70636_d() {
            super.func_70636_d();
            double x = this.func_226277_ct_();
            double y = this.func_226278_cu_();
            double z = this.func_226281_cx_();
            Random random = this.field_70146_Z;
            CustomEntity entity = this;
            for (int l = 0; l < 1; ++l) {
                double d0 = x + (double)random.nextFloat();
                double d1 = y + (double)random.nextFloat();
                double d2 = z + (double)random.nextFloat();
                int i1 = random.nextInt(2) * 2 - 1;
                double d3 = ((double)random.nextFloat() - 0.5) * 0.2;
                double d4 = ((double)random.nextFloat() - 0.5) * 0.2;
                double d5 = ((double)random.nextFloat() - 0.5) * 0.2;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197592_C, d0, d1, d2, d3, d4, d5);
            }
        }
    }
}

