/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.hammer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import se.mickelus.tetra.blocks.forged.hammer.HammerBaseTile;
import se.mickelus.tetra.blocks.forged.hammer.HammerEffect;

@OnlyIn(value=Dist.CLIENT)
public class HammerBaseRenderer
extends TileEntityRenderer<HammerBaseTile> {
    public static final RenderMaterial material = new RenderMaterial(AtlasTexture.field_110575_b, new ResourceLocation("tetra", "blocks/forged_hammer/base_sheet"));
    private final ModelRenderer unpowered = new ModelRenderer(128, 64, 0, 0);
    private final ModelRenderer powered;
    private final ModelRenderer[] modulesA;
    private final ModelRenderer[] modulesB;
    private final ModelRenderer cellAunpowered;
    private final ModelRenderer cellBunpowered;
    private final ModelRenderer cellApowered;
    private final ModelRenderer cellBpowered;

    public HammerBaseRenderer(TileEntityRendererDispatcher rendererDispatcher) {
        super(rendererDispatcher);
        int i;
        this.unpowered.func_228301_a_(0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 0.0f);
        this.powered = new ModelRenderer(128, 64, 64, 0);
        this.powered.func_228301_a_(0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 0.0f);
        HammerEffect[] effects = HammerEffect.values();
        this.modulesA = new ModelRenderer[effects.length];
        for (i = 0; i < effects.length; ++i) {
            this.modulesA[i] = new ModelRenderer(128, 64, i * 16, 32);
            this.modulesA[i].func_228301_a_(0.0f, 0.0f, -16.0f, 16.0f, 16.0f, 0.0f, 0.03f);
            this.modulesA[i].field_78796_g = -1.5707964f;
        }
        this.modulesB = new ModelRenderer[effects.length];
        for (i = 0; i < effects.length; ++i) {
            this.modulesB[i] = new ModelRenderer(128, 64, i * 16, 32);
            this.modulesB[i].func_228301_a_(-16.0f, 0.0f, 0.0f, 16.0f, 16.0f, 0.0f, 0.03f);
            this.modulesB[i].field_78796_g = 1.5707964f;
        }
        this.cellAunpowered = new ModelRenderer(128, 64, 48, 0);
        this.cellAunpowered.func_228301_a_(5.5f, -19.0f, 5.5f, 5.0f, 3.0f, 5.0f, 0.0f);
        this.cellAunpowered.field_78795_f = -1.5707964f;
        this.cellApowered = new ModelRenderer(128, 64, 48, 8);
        this.cellApowered.func_228301_a_(5.5f, -19.0f, 5.5f, 5.0f, 3.0f, 5.0f, 0.0f);
        this.cellApowered.field_78795_f = -1.5707964f;
        this.cellBunpowered = new ModelRenderer(128, 64, 48, 0);
        this.cellBunpowered.func_228301_a_(5.5f, -3.0f, -10.0f, 5.0f, 3.0f, 5.0f, 0.0f);
        this.cellBunpowered.field_78795_f = 1.5707964f;
        this.cellBpowered = new ModelRenderer(128, 64, 48, 8);
        this.cellBpowered.func_228301_a_(5.5f, -3.0f, -10.0f, 5.0f, 3.0f, 5.0f, 0.0f);
        this.cellBpowered.field_78795_f = 1.5707964f;
    }

    public void render(HammerBaseTile tile, float v, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        if (tile.func_145830_o()) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.5, 0.5, 0.5);
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(tile.getFacing().func_185119_l()));
            matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
            IVertexBuilder vertexBuilder = material.func_229311_a_(buffer, RenderType::func_228638_b_);
            if (tile.isFueled()) {
                this.powered.func_228308_a_(matrixStack, vertexBuilder, combinedLight, combinedOverlay);
            } else {
                this.unpowered.func_228308_a_(matrixStack, vertexBuilder, combinedLight, combinedOverlay);
            }
            if (tile.hasCellInSlot(0)) {
                if (tile.getCellFuel(0) > 0) {
                    this.cellApowered.func_228308_a_(matrixStack, vertexBuilder, combinedLight, combinedOverlay);
                } else {
                    this.cellAunpowered.func_228308_a_(matrixStack, vertexBuilder, combinedLight, combinedOverlay);
                }
            }
            if (tile.hasCellInSlot(1)) {
                if (tile.getCellFuel(1) > 0) {
                    this.cellBpowered.func_228308_a_(matrixStack, vertexBuilder, combinedLight, combinedOverlay);
                } else {
                    this.cellBunpowered.func_228308_a_(matrixStack, vertexBuilder, combinedLight, combinedOverlay);
                }
            }
            if (tile.getEffect(true) != null) {
                this.modulesA[tile.getEffect(true).ordinal()].func_228308_a_(matrixStack, vertexBuilder, combinedLight, combinedOverlay);
            }
            if (tile.getEffect(false) != null) {
                this.modulesB[tile.getEffect(false).ordinal()].func_228308_a_(matrixStack, vertexBuilder, combinedLight, combinedOverlay);
            }
            matrixStack.func_227865_b_();
        }
    }
}

