/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.hammer;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.tetra.ToolTypes;
import se.mickelus.tetra.advancements.BlockUseCriterion;
import se.mickelus.tetra.blocks.forged.hammer.HammerBaseBlock;
import se.mickelus.tetra.blocks.forged.hammer.HammerEffect;
import se.mickelus.tetra.blocks.forged.hammer.HammerHeadTile;
import se.mickelus.tetra.blocks.salvage.IInteractiveBlock;
import se.mickelus.tetra.blocks.workbench.AbstractWorkbenchBlock;
import se.mickelus.tetra.items.cell.ItemCellMagmatic;
import se.mickelus.tetra.util.CastOptional;
import se.mickelus.tetra.util.TileEntityOptional;

public class HammerBaseTile
extends TileEntity
implements ITickableTileEntity {
    @ObjectHolder(value="tetra:hammer_base")
    public static TileEntityType<HammerBaseTile> type;
    private static final String moduleAKey = "modA";
    private static final String moduleBKey = "modB";
    private HammerEffect moduleA;
    private HammerEffect moduleB;
    private static final String slotsKey = "slots";
    private static final String indexKey = "slot";
    private ItemStack[] slots = new ItemStack[2];
    private static final String redstoneKey = "rs";
    private int redstonePower = 0;

    public HammerBaseTile() {
        super(type);
    }

    public boolean setModule(boolean isA, Item item) {
        HammerEffect newModule = HammerEffect.fromItem(item);
        if (newModule != null) {
            if (isA) {
                if (this.moduleA == null) {
                    this.moduleA = newModule;
                    this.sync();
                    return true;
                }
            } else if (this.moduleB == null) {
                this.moduleB = newModule;
                this.sync();
                return true;
            }
        }
        return false;
    }

    public Item removeModule(boolean isA) {
        if (isA) {
            if (this.moduleA != null) {
                Item item = this.moduleA.getItem();
                this.moduleA = null;
                this.sync();
                return item;
            }
        } else if (this.moduleB != null) {
            Item item = this.moduleB.getItem();
            this.moduleB = null;
            this.sync();
            return item;
        }
        return null;
    }

    public boolean hasEffect(HammerEffect effect) {
        return effect == this.moduleA || effect == this.moduleB;
    }

    public HammerEffect getEffect(boolean isA) {
        return isA ? this.moduleA : this.moduleB;
    }

    public int getEffectLevel(HammerEffect effect) {
        int level = 0;
        if (effect == this.moduleA) {
            ++level;
        }
        if (effect == this.moduleB) {
            ++level;
        }
        return level;
    }

    public int getHammerLevel() {
        return 5 + this.getEffectLevel(HammerEffect.power);
    }

    public boolean isFunctional() {
        return this.isFueled() && this.getEffect(true) != null && this.getEffect(false) != null;
    }

    public boolean isFueled() {
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.getCellFuel(i) > 0) continue;
            return false;
        }
        return true;
    }

    public void consumeFuel() {
        if (!this.field_145850_b.field_72995_K) {
            int fuelUsage = this.fuelUsage();
            for (int i = 0; i < this.slots.length; ++i) {
                this.consumeFuel(i, fuelUsage);
            }
            this.applyConsumeEffect();
            this.sync();
        }
    }

    public void consumeFuel(int index, int amount) {
        if (index >= 0 && index < this.slots.length && this.slots[index] != null && this.slots[index].func_77973_b() instanceof ItemCellMagmatic) {
            ItemCellMagmatic item = (ItemCellMagmatic)this.slots[index].func_77973_b();
            item.drainCharge(this.slots[index], amount);
        }
    }

    public float getJamChance() {
        return 0.3f - 0.15f * (float)this.getEffectLevel(HammerEffect.reliable);
    }

    public void updateRedstonePower() {
        if (this.field_145850_b != null) {
            int updatedPower = 0;
            for (Direction direction : Direction.values()) {
                updatedPower += this.field_145850_b.func_175651_c(this.field_174879_c.func_177972_a(direction), direction);
            }
            if (updatedPower != this.redstonePower) {
                this.redstonePower = updatedPower;
                this.sync();
            }
        }
    }

    private int tickrate() {
        return this.redstonePower != 0 ? (int)Math.max(600.0f / (float)this.redstonePower, 10.0f) : 20;
    }

    public void func_73660_a() {
        if (this.redstonePower > 0 && this.field_145850_b.func_82737_E() % (long)this.tickrate() == 0L && this.field_145850_b.func_175640_z(this.field_174879_c) && this.isFunctional()) {
            BlockPos targetPos = this.field_174879_c.func_177979_c(2);
            BlockState targetState = this.field_145850_b.func_180495_p(targetPos);
            HammerHeadTile head = TileEntityOptional.from((IBlockReader)this.field_145850_b, this.field_174879_c.func_177977_b(), HammerHeadTile.class).orElse(null);
            if (head == null || head.isJammed()) {
                return;
            }
            CastOptional.cast(targetState.func_177230_c(), IInteractiveBlock.class).map(block -> block.getPotentialInteractions(this.field_145850_b, targetPos, targetState, Direction.UP, Collections.singletonList(ToolTypes.hammer))).map(Arrays::stream).orElseGet(Stream::empty).filter(interaction -> ToolTypes.hammer.equals(interaction.requiredTool)).filter(interaction -> this.getHammerLevel() >= interaction.requiredLevel).findFirst().ifPresent(interaction -> {
                interaction.applyOutcome(this.field_145850_b, targetPos, targetState, null, null, Direction.UP);
                if (!(targetState.func_177230_c() instanceof AbstractWorkbenchBlock)) {
                    if (!this.field_145850_b.field_72995_K) {
                        this.consumeFuel();
                    } else {
                        head.activate();
                        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187689_f, SoundCategory.BLOCKS, 0.2f, (float)(0.5 + Math.random() * 0.2));
                    }
                } else {
                    head.activate();
                }
            });
        }
    }

    private void applyConsumeEffect() {
        Direction facing = (Direction)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b((Property)HammerBaseBlock.facingProp);
        Vector3d pos = Vector3d.func_237489_a_((Vector3i)this.func_174877_v());
        Vector3d oppositePos = pos.func_178787_e(Vector3d.func_237491_b_((Vector3i)facing.func_176734_d().func_176730_m()).func_186678_a(0.55));
        pos = pos.func_178787_e(Vector3d.func_237491_b_((Vector3i)facing.func_176730_m()).func_186678_a(0.55));
        if (this.hasEffect(HammerEffect.power)) {
            this.spawnParticle((IParticleData)ParticleTypes.field_197622_o, Vector3d.func_237491_b_((Vector3i)this.func_174877_v()).func_72441_c(0.5, -0.9, 0.5), 15, 0.1f);
        }
        if (this.hasEffect(HammerEffect.power)) {
            this.spawnParticle((IParticleData)ParticleTypes.field_239820_at_, Vector3d.func_237491_b_((Vector3i)this.func_174877_v()).func_72441_c(0.5, -0.9, 0.5), 15, 0.1f);
            int count = this.field_145850_b.field_73012_v.nextInt(2 + this.getEffectLevel(HammerEffect.power) * 4);
            if (count > 2) {
                this.spawnParticle((IParticleData)ParticleTypes.field_197595_F, pos, 2, 0.06f);
                this.spawnParticle((IParticleData)ParticleTypes.field_197594_E, pos, 2, 0.0f);
                this.spawnParticle((IParticleData)ParticleTypes.field_197595_F, oppositePos, 2, 0.06f);
                this.spawnParticle((IParticleData)ParticleTypes.field_197594_E, oppositePos, 2, 0.0f);
                LinkedList<BlockPos> flammableBlocks = new LinkedList<BlockPos>();
                for (int x = -3; x < 3; ++x) {
                    for (int y = -3; y < 2; ++y) {
                        for (int z = -3; z < 3; ++z) {
                            BlockPos firePos = this.func_174877_v().func_177982_a(x, y, z);
                            if (!this.field_145850_b.func_175623_d(firePos)) continue;
                            flammableBlocks.add(firePos);
                        }
                    }
                }
                Collections.shuffle(flammableBlocks);
                flammableBlocks.stream().limit(count).forEach(blockPos -> this.field_145850_b.func_180501_a(blockPos, Blocks.field_150480_ab.func_176223_P(), 11));
            }
        }
        if (this.field_145850_b.field_73012_v.nextFloat() < this.getJamChance()) {
            TileEntityOptional.from((IBlockReader)this.field_145850_b, this.func_174877_v().func_177977_b(), HammerHeadTile.class).ifPresent(head -> head.setJammed(true));
            this.field_145850_b.func_217357_a(ServerPlayerEntity.class, new AxisAlignedBB(this.func_174877_v()).func_72314_b(10.0, 5.0, 10.0)).forEach(player -> BlockUseCriterion.trigger(player, this.func_195044_w(), ItemStack.field_190927_a));
            this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_219642_eu, SoundCategory.BLOCKS, 0.8f, 0.5f);
        }
    }

    private int fuelUsage() {
        int usage = 5;
        usage += this.getEffectLevel(HammerEffect.power) * 4;
        usage = (int)((double)usage * (1.0 - (double)this.getEffectLevel(HammerEffect.efficient) * 0.4));
        return Math.max(usage, 1);
    }

    public boolean hasCellInSlot(int index) {
        return index >= 0 && index < this.slots.length && this.slots[index] != null;
    }

    public int getCellFuel(int index) {
        if (index >= 0 && index < this.slots.length && this.slots[index] != null && this.slots[index].func_77973_b() instanceof ItemCellMagmatic) {
            ItemCellMagmatic item = (ItemCellMagmatic)this.slots[index].func_77973_b();
            return item.getCharge(this.slots[index]);
        }
        return -1;
    }

    public ItemStack removeCellFromSlot(int index) {
        if (index >= 0 && index < this.slots.length && this.slots[index] != null) {
            ItemStack itemStack = this.slots[index];
            this.slots[index] = null;
            this.sync();
            return itemStack;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getStackInSlot(int index) {
        if (index >= 0 && index < this.slots.length && this.slots[index] != null) {
            return this.slots[index];
        }
        return ItemStack.field_190927_a;
    }

    public boolean putCellInSlot(ItemStack itemStack, int index) {
        if (itemStack.func_77973_b() instanceof ItemCellMagmatic && index >= 0 && index < this.slots.length && this.slots[index] == null) {
            this.slots[index] = itemStack;
            this.sync();
            return true;
        }
        return false;
    }

    private void spawnParticle(IParticleData particle, Vector3d pos, int count, float speed) {
        if (this.field_145850_b instanceof ServerWorld) {
            ((ServerWorld)this.field_145850_b).func_195598_a(particle, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, count, 0.0, 0.0, 0.0, (double)speed);
        }
    }

    public Direction getFacing() {
        return (Direction)this.func_195044_w().func_177229_b((Property)HammerBaseBlock.facingProp);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT compound) {
        byte data;
        super.func_230337_a_(blockState, compound);
        this.slots = new ItemStack[2];
        if (compound.func_74764_b(slotsKey)) {
            ListNBT tagList = compound.func_150295_c(slotsKey, 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundNBT itemCompound = tagList.func_150305_b(i);
                int slot = itemCompound.func_74771_c(indexKey) & 0xFF;
                if (slot >= this.slots.length) continue;
                this.slots[slot] = ItemStack.func_199557_a((CompoundNBT)itemCompound);
            }
        }
        this.moduleA = null;
        if (compound.func_74764_b(moduleAKey) && (data = compound.func_74771_c(moduleAKey)) < HammerEffect.values().length) {
            this.moduleA = HammerEffect.values()[data];
        }
        this.moduleB = null;
        if (compound.func_74764_b(moduleBKey) && (data = compound.func_74771_c(moduleBKey)) < HammerEffect.values().length) {
            this.moduleB = HammerEffect.values()[data];
        }
        this.redstonePower = compound.func_74762_e(redstoneKey);
    }

    private void sync() {
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
        this.func_70296_d();
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        HammerBaseTile.writeCells(compound, this.slots);
        HammerBaseTile.writeModules(compound, this.moduleA, this.moduleB);
        compound.func_74768_a(redstoneKey, this.redstonePower);
        return compound;
    }

    public static void writeModules(CompoundNBT compound, HammerEffect moduleA, HammerEffect moduleB) {
        if (moduleA != null) {
            compound.func_218657_a(moduleAKey, (INBT)ByteNBT.func_229671_a_((byte)((byte)moduleA.ordinal())));
        }
        if (moduleB != null) {
            compound.func_218657_a(moduleBKey, (INBT)ByteNBT.func_229671_a_((byte)((byte)moduleB.ordinal())));
        }
    }

    public static void writeCells(CompoundNBT compound, ItemStack ... cells) {
        ListNBT nbttaglist = new ListNBT();
        for (int i = 0; i < cells.length; ++i) {
            if (cells[i] == null) continue;
            CompoundNBT nbttagcompound = new CompoundNBT();
            nbttagcompound.func_74774_a(indexKey, (byte)i);
            cells[i].func_77955_b(nbttagcompound);
            nbttaglist.add((Object)nbttagcompound);
        }
        compound.func_218657_a(slotsKey, (INBT)nbttaglist);
    }
}

