/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.rack;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.tetra.Tooltips;
import se.mickelus.tetra.blocks.TetraWaterloggedBlock;
import se.mickelus.tetra.blocks.rack.RackTESR;
import se.mickelus.tetra.blocks.rack.RackTile;
import se.mickelus.tetra.module.ItemUpgradeRegistry;
import se.mickelus.tetra.properties.IToolProvider;
import se.mickelus.tetra.properties.PropertyHelper;
import se.mickelus.tetra.util.ItemHandlerWrapper;
import se.mickelus.tetra.util.TileEntityOptional;

public class RackBlock
extends TetraWaterloggedBlock {
    public static final String unlocalizedName = "rack";
    @ObjectHolder(value="tetra:rack")
    public static RackBlock instance;
    public static final DirectionProperty facingProp;
    private static final Map<Direction, VoxelShape> shapes;

    public RackBlock() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151663_o).func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a));
        this.hasItem = true;
        this.setRegistryName(unlocalizedName);
    }

    @Override
    public void clientInit() {
        ClientRegistry.bindTileEntityRenderer(RackTile.type, RackTESR::new);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{facingProp});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new RackTile();
    }

    public ActionResultType func_225533_a_(BlockState blockState, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        Direction facing = (Direction)blockState.func_177229_b((Property)facingProp);
        AxisAlignedBB boundingBox = blockState.func_196954_c((IBlockReader)player.field_70170_p, pos).func_197752_a();
        if (facing == hit.func_216354_b()) {
            System.out.println(hit.func_216347_e());
            Vector3d hitVec = hit.func_216347_e();
            int slot = RackBlock.getHitX(facing, boundingBox, (float)hitVec.field_72450_a - (float)pos.func_177958_n(), (float)hitVec.field_72448_b - (float)pos.func_177956_o(), (float)hitVec.field_72449_c - (float)pos.func_177952_p()) > 0.5 ? 1 : 0;
            TileEntityOptional.from((IBlockReader)world, pos, RackTile.class).ifPresent(tile -> tile.slotInteract(slot, player, hand));
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    private static double getHitX(Direction facing, AxisAlignedBB boundingBox, double hitX, double hitY, double hitZ) {
        switch (facing) {
            case NORTH: {
                return boundingBox.field_72336_d - hitX;
            }
            case SOUTH: {
                return hitX - boundingBox.field_72340_a;
            }
            case WEST: {
                return hitZ - boundingBox.field_72339_c;
            }
            case EAST: {
                return boundingBox.field_72334_f - hitZ;
            }
        }
        return 0.0;
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        if (Direction.Axis.Y != context.func_196000_l().func_176740_k()) {
            return Optional.of((BlockState)this.func_176223_P().func_206870_a((Property)facingProp, (Comparable)context.func_196000_l())).filter(blockState -> blockState.func_196955_c((IWorldReader)context.func_195991_k(), context.func_195995_a())).orElse(null);
        }
        return null;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177972_a(((Direction)state.func_177229_b((Property)facingProp)).func_176734_d())).func_185904_a().func_76220_a();
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        RackBlock.dropBlockInventory(this, world, pos, newState);
    }

    @Override
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing.func_176734_d() == stateIn.func_177229_b((Property)facingProp) && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : stateIn;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return shapes.get(state.func_177229_b((Property)facingProp));
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)facingProp, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)facingProp)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)facingProp)));
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        if (Screen.func_231173_s_()) {
            tooltip.add(Tooltips.expanded);
            tooltip.add((ITextComponent)new TranslationTextComponent("block.tetra.rack.description").func_240699_a_(TextFormatting.GRAY));
        } else {
            tooltip.add(Tooltips.expand);
        }
    }

    @Override
    public boolean canProvideTools(World world, BlockPos pos, BlockPos targetPos) {
        return true;
    }

    @Override
    public Collection<ToolType> getTools(World world, BlockPos pos, BlockState blockState) {
        return Optional.ofNullable(world.func_175625_s(pos)).map(te -> te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)).orElse(LazyOptional.empty()).map(ItemHandlerWrapper::new).map(PropertyHelper::getInventoryTools).orElseGet(Collections::emptySet);
    }

    @Override
    public int getToolLevel(World world, BlockPos pos, BlockState blockState, ToolType toolType) {
        return Optional.ofNullable(world.func_175625_s(pos)).map(te -> te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)).orElse(LazyOptional.empty()).map(ItemHandlerWrapper::new).map(inv -> PropertyHelper.getInventoryToolLevel(inv, toolType)).orElse(-1);
    }

    @Override
    public ItemStack onCraftConsumeTool(World world, BlockPos pos, BlockState blockState, ItemStack targetStack, String slot, boolean isReplacing, PlayerEntity player, ToolType requiredTool, int requiredLevel, boolean consumeResources) {
        IInventory inventory;
        ItemStack providerStack;
        Optional optional = Optional.ofNullable(world.func_175625_s(pos)).map(te -> te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)).orElse(LazyOptional.empty()).map(ItemHandlerWrapper::new);
        if (optional.isPresent() && player != null && !(providerStack = PropertyHelper.getInventoryProvidingItemStack(inventory = (IInventory)optional.orElse(null), requiredTool, requiredLevel)).func_190926_b()) {
            if (consumeResources) {
                this.spawnConsumeParticle(world, pos, blockState, inventory, providerStack);
            }
            return ((IToolProvider)providerStack.func_77973_b()).onCraftConsume(providerStack, targetStack, player, requiredTool, requiredLevel, consumeResources);
        }
        return null;
    }

    @Override
    public ItemStack onActionConsumeTool(World world, BlockPos pos, BlockState blockState, ItemStack targetStack, PlayerEntity player, ToolType requiredTool, int requiredLevel, boolean consumeResources) {
        IInventory inventory;
        ItemStack providerStack;
        Optional optional = Optional.ofNullable(world.func_175625_s(pos)).map(te -> te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)).orElse(LazyOptional.empty()).map(ItemHandlerWrapper::new);
        if (optional.isPresent() && player != null && !(providerStack = PropertyHelper.getInventoryProvidingItemStack(inventory = (IInventory)optional.orElse(null), requiredTool, requiredLevel)).func_190926_b()) {
            if (consumeResources) {
                this.spawnConsumeParticle(world, pos, blockState, inventory, providerStack);
            }
            return ((IToolProvider)providerStack.func_77973_b()).onActionConsume(providerStack, targetStack, player, requiredTool, requiredLevel, consumeResources);
        }
        return null;
    }

    private void spawnConsumeParticle(World world, BlockPos pos, BlockState blockState, IInventory inventory, ItemStack providerStack) {
        if (world instanceof ServerWorld) {
            Direction facing = (Direction)blockState.func_177229_b((Property)facingProp);
            Vector3d particlePos = Vector3d.func_237491_b_((Vector3i)pos).func_72441_c(0.5, 0.75, 0.5).func_178787_e(Vector3d.func_237491_b_((Vector3i)facing.func_176730_m()).func_186678_a(-0.3));
            ItemStack firstSlot = inventory.func_70301_a(0);
            particlePos = ItemStack.func_77989_b((ItemStack)providerStack, (ItemStack)(firstSlot = Optional.of(ItemUpgradeRegistry.instance.getReplacement(firstSlot)).filter(itemStack -> !itemStack.func_190926_b()).orElse(firstSlot))) ? particlePos.func_178787_e(Vector3d.func_237491_b_((Vector3i)facing.func_176735_f().func_176730_m()).func_186678_a(-0.25)) : particlePos.func_178787_e(Vector3d.func_237491_b_((Vector3i)facing.func_176735_f().func_176730_m()).func_186678_a(0.25));
            ((ServerWorld)world).func_195598_a((IParticleData)new RedstoneParticleData(0.0f, 0.66f, 0.66f, 1.0f), particlePos.func_82615_a(), particlePos.func_82617_b(), particlePos.func_82616_c(), 2, 0.0, 0.0, 0.0, 0.0);
        }
    }

    static {
        facingProp = HorizontalBlock.field_185512_D;
        shapes = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.func_208617_a((double)0.0, (double)11.0, (double)14.0, (double)16.0, (double)14.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.func_208617_a((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)14.0, (double)2.0), (Object)Direction.WEST, (Object)Block.func_208617_a((double)14.0, (double)11.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), (Object)Direction.EAST, (Object)Block.func_208617_a((double)0.0, (double)11.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0)));
    }
}

