/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.scroll;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.tetra.blocks.scroll.ScrollBlock;
import se.mickelus.tetra.blocks.scroll.ScrollData;
import se.mickelus.tetra.blocks.scroll.ScrollTile;
import se.mickelus.tetra.util.RotationHelper;
import se.mickelus.tetra.util.TileEntityOptional;

public class RolledScrollBlock
extends ScrollBlock {
    public static final String identifier = "scroll_rolled";
    @ObjectHolder(value="tetra:scroll_rolled")
    public static ScrollBlock instance;
    private final VoxelShape[] baseShapes = new VoxelShape[]{Block.func_208617_a((double)6.0, (double)0.0, (double)1.0, (double)9.0, (double)3.0, (double)15.0), Block.func_208617_a((double)4.0, (double)0.0, (double)1.0, (double)11.0, (double)3.0, (double)15.0), Block.func_208617_a((double)2.0, (double)0.0, (double)1.0, (double)13.0, (double)3.0, (double)15.0), VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)2.0, (double)0.0, (double)1.0, (double)13.0, (double)3.0, (double)15.0), (VoxelShape)Block.func_208617_a((double)8.0, (double)3.0, (double)1.0, (double)11.0, (double)6.0, (double)15.0)), VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)2.0, (double)0.0, (double)1.0, (double)13.0, (double)3.0, (double)15.0), (VoxelShape)Block.func_208617_a((double)4.0, (double)3.0, (double)1.0, (double)11.0, (double)6.0, (double)15.0)), VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)2.0, (double)0.0, (double)1.0, (double)13.0, (double)3.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)4.0, (double)3.0, (double)1.0, (double)11.0, (double)6.0, (double)15.0), Block.func_208617_a((double)6.0, (double)6.0, (double)1.0, (double)9.0, (double)9.0, (double)15.0)})};
    private final Map<Direction, VoxelShape[]> shapes = new EnumMap<Direction, VoxelShape[]>(Direction.class);

    public RolledScrollBlock() {
        super(identifier, ScrollBlock.Arrangement.rolled);
        for (int i = 0; i < 4; ++i) {
            Direction direction = Direction.func_176731_b((int)i);
            VoxelShape[] result = new VoxelShape[this.baseShapes.length];
            for (int j = 0; j < result.length; ++j) {
                result[j] = RotationHelper.rotateDirection(this.baseShapes[j], direction);
            }
            this.shapes.put(direction, result);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction facing = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
        int index = TileEntityOptional.from(worldIn, pos, ScrollTile.class).map(ScrollTile::getScrolls).map(scrolls -> ((ScrollData[])scrolls).length - 1).map(c -> MathHelper.func_76125_a((int)c, (int)0, (int)5)).orElse(0);
        return this.shapes.get(facing)[index];
    }
}

