/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.scroll;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import se.mickelus.tetra.blocks.TetraBlock;
import se.mickelus.tetra.blocks.scroll.ScrollItem;
import se.mickelus.tetra.blocks.scroll.ScrollTile;
import se.mickelus.tetra.blocks.workbench.AbstractWorkbenchBlock;
import se.mickelus.tetra.util.TileEntityOptional;

public class ScrollBlock
extends TetraBlock {
    private Arrangement arrangement;
    public static final Material material = new Material.Builder(MaterialColor.field_151659_e).func_200502_b().func_200506_i();
    public static final SoundType sound = new SoundType(0.8f, 1.3f, SoundEvents.field_219617_ah, SoundEvents.field_219617_ah, SoundEvents.field_219617_ah, SoundEvents.field_219617_ah, SoundEvents.field_219617_ah);

    public ScrollBlock(String registryName, Arrangement arrangement) {
        super(AbstractBlock.Properties.func_200945_a((Material)material).func_200947_a(sound));
        this.setRegistryName("tetra", registryName);
        this.arrangement = arrangement;
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)Direction.EAST));
    }

    public Arrangement getArrangement() {
        return this.arrangement;
    }

    @Override
    public boolean canUnlockSchematics(World world, BlockPos pos, BlockPos targetPos) {
        boolean isIntricate = TileEntityOptional.from((IBlockReader)world, pos, ScrollTile.class).map(ScrollTile::isIntricate).orElse(false);
        return !isIntricate || targetPos.func_177984_a().equals((Object)pos);
    }

    @Override
    public ResourceLocation[] getSchematics(World world, BlockPos pos, BlockState blockState) {
        return TileEntityOptional.from((IBlockReader)world, pos, ScrollTile.class).map(ScrollTile::getSchematics).orElseGet(() -> new ResourceLocation[0]);
    }

    @Override
    public boolean canUnlockCraftingEffects(World world, BlockPos pos, BlockPos targetPos) {
        boolean isIntricate = TileEntityOptional.from((IBlockReader)world, pos, ScrollTile.class).map(ScrollTile::isIntricate).orElse(false);
        return !isIntricate || targetPos.func_177984_a().equals((Object)pos);
    }

    @Override
    public ResourceLocation[] getCraftingEffects(World world, BlockPos pos, BlockState blockState) {
        return TileEntityOptional.from((IBlockReader)world, pos, ScrollTile.class).map(ScrollTile::getCraftingEffects).orElseGet(() -> new ResourceLocation[0]);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        BlockState offsetState;
        if (this.arrangement == Arrangement.open && (offsetState = world.func_180495_p(pos.func_177977_b())).func_177230_c() instanceof AbstractWorkbenchBlock) {
            return offsetState.func_227031_a_(world, player, hand, new BlockRayTraceResult(Vector3d.field_186680_a, Direction.UP, pos.func_177977_b(), true));
        }
        return super.func_225533_a_(state, world, pos, player, hand, hit);
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        Direction facing = Direction.UP;
        if (this.getArrangement() == Arrangement.wall) {
            facing = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
        }
        BlockPos offsetPos = pos.func_177972_a(facing.func_176734_d());
        BlockState offsetState = world.func_180495_p(offsetPos);
        if (this.getArrangement() == Arrangement.open) {
            return offsetState.func_177230_c() instanceof AbstractWorkbenchBlock;
        }
        return offsetState.func_224755_d((IBlockReader)world, offsetPos, facing);
    }

    public BlockState func_196271_a(BlockState blockState, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (!blockState.func_196955_c((IWorldReader)world, currentPos)) {
            if (!world.func_201670_d() && world.func_72912_H().func_82574_x().func_223586_b(GameRules.field_223603_f) && world instanceof World) {
                this.dropScrolls((World)world, currentPos);
            }
            return Blocks.field_150350_a.func_176223_P();
        }
        return blockState;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208157_J});
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ScrollTile();
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        super.func_176208_a(world, pos, state, player);
        if (!world.field_72995_K && !player.func_184812_l_() && world.func_82736_K().func_223586_b(GameRules.field_223603_f)) {
            this.dropScrolls(world, pos);
        }
    }

    public void dropScrolls(World world, BlockPos pos) {
        TileEntityOptional.from((IBlockReader)world, pos, ScrollTile.class).ifPresent(tile -> {
            for (CompoundNBT nbt : tile.getItemTags()) {
                ItemStack itemStack = new ItemStack((IItemProvider)ScrollItem.instance);
                itemStack.func_77983_a("BlockEntityTag", (INBT)nbt);
                ItemEntity entity = new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, itemStack);
                entity.func_174869_p();
                world.func_217376_c((Entity)entity);
            }
        });
    }

    public static enum Arrangement {
        wall,
        open,
        rolled;

    }
}

