/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench;

import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import se.mickelus.tetra.blocks.salvage.BlockInteraction;
import se.mickelus.tetra.blocks.salvage.InteractionOutcome;
import se.mickelus.tetra.blocks.workbench.WorkbenchTile;
import se.mickelus.tetra.blocks.workbench.action.WorkbenchAction;
import se.mickelus.tetra.util.CastOptional;

public class ActionInteraction
extends BlockInteraction {
    private String actionKey;

    public ActionInteraction(ToolType requiredType, int requiredLevel, String actionKey) {
        super(requiredType, requiredLevel, Direction.UP, 5.0f, 11.0f, 5.0f, 11.0f, InteractionOutcome.EMPTY);
        this.actionKey = actionKey;
        this.applyUsageEffects = false;
    }

    public static ActionInteraction create(WorkbenchTile tile) {
        ItemStack targetStack = tile.getTargetItemStack();
        return Arrays.stream(tile.getAvailableActions(null)).filter(WorkbenchAction::allowInWorldInteraction).filter(action -> action.getRequiredTools(targetStack).entrySet().size() == 1).findFirst().map(action -> {
            Map.Entry requirementPair = (Map.Entry)action.getRequiredTools(targetStack).entrySet().stream().findFirst().get();
            return new ActionInteraction((ToolType)requirementPair.getKey(), (Integer)requirementPair.getValue(), action.getKey());
        }).orElse(null);
    }

    @Override
    public boolean applicableForBlock(World world, BlockPos pos, BlockState blockState) {
        return this.actionKey != null;
    }

    @Override
    public void applyOutcome(World world, BlockPos pos, BlockState blockState, @Nullable PlayerEntity player, @Nullable Hand hand, Direction hitFace) {
        if (!world.field_72995_K) {
            CastOptional.cast(world.func_175625_s(pos), WorkbenchTile.class).ifPresent(tile -> {
                if (player != null) {
                    tile.performAction(player, this.actionKey);
                } else {
                    tile.performAction(this.actionKey);
                }
            });
        }
    }
}

