/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench.gui;

import java.util.Collections;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.ToolType;
import se.mickelus.tetra.blocks.workbench.gui.GuiTool;

public class ToolRequirementGui
extends GuiTool {
    private int requiredLevel;
    private int availableLevel;
    private boolean showTooltip = true;
    private boolean showTooltipRequirement = true;
    String requirementTooltip;

    public ToolRequirementGui(int x, int y, ToolType toolType) {
        this(x, y, toolType, "tetra.tool." + toolType.getName() + ".requirement");
    }

    public ToolRequirementGui(int x, int y, ToolType toolType, String requirementTooltip) {
        super(x, y, toolType);
        this.requirementTooltip = requirementTooltip;
    }

    public ToolRequirementGui setTooltipVisibility(boolean shouldShow) {
        this.showTooltip = shouldShow;
        return this;
    }

    public ToolRequirementGui setTooltipRequirementVisibility(boolean shouldShow) {
        this.showTooltipRequirement = shouldShow;
        return this;
    }

    public ToolRequirementGui updateRequirement(int requiredLevel, int availableLevel) {
        this.setVisible(requiredLevel != 0);
        this.requiredLevel = requiredLevel;
        this.availableLevel = availableLevel;
        if (this.isVisible()) {
            if (requiredLevel > availableLevel) {
                this.update(requiredLevel, 0xFFAAAA);
            } else {
                this.update(requiredLevel, 0xAAFFAA);
            }
        }
        return this;
    }

    public List<String> getTooltipLines() {
        if (this.hasFocus() && this.showTooltip) {
            if (this.showTooltipRequirement) {
                return Collections.singletonList(I18n.func_135052_a((String)this.requirementTooltip, (Object[])new Object[]{this.requiredLevel}) + "\n \n" + (this.requiredLevel > this.availableLevel ? TextFormatting.RED : TextFormatting.GREEN) + I18n.func_135052_a((String)"tetra.tool.available", (Object[])new Object[]{this.availableLevel}));
            }
            return Collections.singletonList(I18n.func_135052_a((String)this.requirementTooltip, (Object[])new Object[]{this.requiredLevel}));
        }
        return super.getTooltipLines();
    }
}

