/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench.gui;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ToolType;
import se.mickelus.mgui.gui.GuiAlignment;
import se.mickelus.mgui.gui.GuiAttachment;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.animation.Applier;
import se.mickelus.mgui.gui.animation.KeyframeAnimation;
import se.mickelus.tetra.ToolTypes;
import se.mickelus.tetra.gui.statbar.AbilityStats;
import se.mickelus.tetra.gui.statbar.GuiStatBar;
import se.mickelus.tetra.gui.statbar.GuiStatBarTool;
import se.mickelus.tetra.gui.statbar.GuiStatBase;
import se.mickelus.tetra.gui.statbar.GuiStats;
import se.mickelus.tetra.items.modular.IModularItem;

public class WorkbenchStatsGui
extends GuiElement {
    private static final List<GuiStatBase> bars = new LinkedList<GuiStatBar>(Arrays.asList(new GuiStatBar[]{GuiStats.attackDamage, GuiStats.attackSpeed, GuiStats.drawStrength, GuiStats.drawSpeed, GuiStats.abilityDamage, GuiStats.abilityCooldown, GuiStats.reach, GuiStats.durability, GuiStats.armor, GuiStats.toughness, GuiStats.blocking, GuiStats.bashing, GuiStats.throwable, GuiStats.ricochet, GuiStats.piercing, GuiStats.jab, GuiStats.quickslot, GuiStats.potionStorage, GuiStats.storage, GuiStats.quiver, GuiStats.booster, GuiStats.suspendSelf, GuiStats.sweeping, GuiStats.bleeding, GuiStats.backstab, GuiStats.armorPenetration, GuiStats.crushing, GuiStats.skewering, GuiStats.howling, GuiStats.knockback, AbilityStats.execute, GuiStats.severing, GuiStats.stun, AbilityStats.lunge, AbilityStats.slam, AbilityStats.puncture, AbilityStats.pry, AbilityStats.overpower, AbilityStats.reap, GuiStats.looting, GuiStats.fiery, GuiStats.smite, GuiStats.arthropod, GuiStats.unbreaking, GuiStats.mending, GuiStats.silkTouch, GuiStats.fortune, GuiStats.infinity, GuiStats.flame, GuiStats.punch, GuiStats.quickStrike, GuiStats.softStrike, GuiStats.fierySelf, GuiStats.enderReverb, GuiStats.criticalStrike, GuiStats.earthbind, GuiStats.releaseLatch, GuiStats.overbowed, GuiStats.multishot, GuiStats.zoom, GuiStats.velocity, GuiStats.scannerRange, GuiStats.scannerHorizontalSpread, GuiStats.scannerVerticalSpread, GuiStats.intuit, GuiStats.workable, GuiStats.stability, new GuiStatBarTool(0, 0, 59, ToolTypes.hammer), new GuiStatBarTool(0, 0, 59, ToolType.AXE), new GuiStatBarTool(0, 0, 59, ToolType.PICKAXE), new GuiStatBarTool(0, 0, 59, ToolType.SHOVEL), new GuiStatBarTool(0, 0, 59, ToolTypes.cut), new GuiStatBarTool(0, 0, 59, ToolTypes.pry), new GuiStatBarTool(0, 0, 59, ToolType.HOE)}));
    private GuiElement barGroup;

    public WorkbenchStatsGui(int x, int y) {
        super(x, y, 200, 52);
        this.barGroup = new GuiElement(0, 0, this.width, this.height);
        this.addChild(this.barGroup);
    }

    public static void addBar(GuiStatBase statBar) {
        bars.add(statBar);
    }

    public void update(ItemStack itemStack, ItemStack previewStack, String slot, String improvement, PlayerEntity player) {
        boolean shouldShow = !itemStack.func_190926_b() && itemStack.func_77973_b() instanceof IModularItem;
        this.setVisible(shouldShow);
        if (shouldShow) {
            this.barGroup.clearChildren();
            bars.stream().filter(bar -> bar.shouldShow(player, itemStack, previewStack, slot, improvement)).forEach(bar -> {
                bar.update(player, itemStack, previewStack, slot, improvement);
                this.realignBar((GuiStatBase)((Object)bar));
                this.barGroup.addChild((GuiElement)bar);
            });
        }
    }

    public void showAnimation() {
        if (this.isVisible()) {
            for (int i = 0; i < this.barGroup.getNumChildren(); ++i) {
                this.barGroup.getChild(i).updateAnimations();
                new KeyframeAnimation(100, this.barGroup.getChild(i)).withDelay(i * 60 + 400).applyTo(new Applier[]{new Applier.Opacity(0.0f, 1.0f), new Applier.TranslateY(3.0f, 0.0f, true)}).start();
            }
        }
    }

    private void realignBar(GuiStatBase bar) {
        int count = this.barGroup.getNumChildren();
        bar.setY(-17 * (count % 6 / 2) - 3);
        bar.setAttachmentAnchor(GuiAttachment.bottomCenter);
        int xOffset = 3 + count / 6 * 62;
        if (count % 2 == 0) {
            bar.setX(xOffset);
            bar.setAttachmentPoint(GuiAttachment.bottomLeft);
            bar.setAlignment(GuiAlignment.left);
        } else {
            bar.setX(-xOffset);
            bar.setAttachmentPoint(GuiAttachment.bottomRight);
            bar.setAlignment(GuiAlignment.right);
        }
    }
}

