/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.TRSRTransformer;
import se.mickelus.tetra.client.model.BakedPerspectiveModel;
import se.mickelus.tetra.client.model.BakedWrapper;
import se.mickelus.tetra.client.model.ModularOverrideList;
import se.mickelus.tetra.module.data.ModuleModel;

public final class ModularItemModel
implements IModelGeometry<ModularItemModel> {
    private ItemCameraTransforms cameraTransforms;
    private Map<String, ItemCameraTransforms> transformVariants = Collections.emptyMap();
    ModularOverrideList overrideList;

    public ModularItemModel(ItemCameraTransforms cameraTransforms, Map<String, ItemCameraTransforms> transformVariants) {
        this(cameraTransforms);
        this.transformVariants = transformVariants != null ? transformVariants : Collections.emptyMap();
    }

    public ModularItemModel(ItemCameraTransforms cameraTransforms) {
        this.cameraTransforms = cameraTransforms;
    }

    public void clearCache() {
        Optional.ofNullable(this.overrideList).ifPresent(ModularOverrideList::clearCache);
    }

    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return Collections.emptyList();
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        this.overrideList = new ModularOverrideList(this, owner, bakery, spriteGetter, modelTransform, modelLocation);
        return new BakedWrapper(this, owner, bakery, spriteGetter, modelTransform, modelLocation, this.overrideList);
    }

    public IBakedModel realBake(List<ModuleModel> moduleModels, String transformVariant, IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        ImmutableList.Builder builder = ImmutableList.builder();
        TextureAtlasSprite particle = null;
        TransformationMatrix rotationTransform = modelTransform.func_225615_b_();
        ImmutableMap transforms = PerspectiveMapWrapper.getTransforms((IModelTransform)modelTransform);
        for (int i = 0; i < moduleModels.size(); ++i) {
            ModuleModel model = moduleModels.get(i);
            TextureAtlasSprite sprite = spriteGetter.apply(new RenderMaterial(AtlasTexture.field_110575_b, model.location));
            builder.addAll(ModularItemModel.getQuadsForSprite(i, sprite, rotationTransform, model.tint));
            particle = sprite;
        }
        return new BakedPerspectiveModel((ImmutableList<BakedQuad>)builder.build(), particle, (ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix>)transforms, overrides, rotationTransform.isIdentity(), owner.isSideLit(), this.getCameraTransforms(transformVariant));
    }

    protected ItemCameraTransforms getCameraTransforms(String transformVariant) {
        if (transformVariant != null && this.transformVariants.containsKey(transformVariant)) {
            ItemCameraTransforms variant = this.transformVariants.get(transformVariant);
            return new ItemCameraTransforms(variant.func_181687_c(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND) ? variant.field_188036_k : this.cameraTransforms.field_188036_k, variant.func_181687_c(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND) ? variant.field_188037_l : this.cameraTransforms.field_188037_l, variant.func_181687_c(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND) ? variant.field_188038_m : this.cameraTransforms.field_188038_m, variant.func_181687_c(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND) ? variant.field_188039_n : this.cameraTransforms.field_188039_n, variant.func_181687_c(ItemCameraTransforms.TransformType.HEAD) ? variant.field_178353_d : this.cameraTransforms.field_178353_d, variant.func_181687_c(ItemCameraTransforms.TransformType.GUI) ? variant.field_178354_e : this.cameraTransforms.field_178354_e, variant.func_181687_c(ItemCameraTransforms.TransformType.GROUND) ? variant.field_181699_o : this.cameraTransforms.field_181699_o, variant.func_181687_c(ItemCameraTransforms.TransformType.FIXED) ? variant.field_181700_p : this.cameraTransforms.field_181700_p);
        }
        return this.cameraTransforms;
    }

    public static List<BakedQuad> getQuadsForSprite(int tintIndex, TextureAtlasSprite sprite, TransformationMatrix transform, int color) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int uMax = sprite.func_94211_a();
        int vMax = sprite.func_94216_b();
        for (int v = 0; v < vMax; ++v) {
            builder.add((Object)ModularItemModel.buildSideQuad(transform, Direction.UP, tintIndex, color, sprite, 0, v, uMax));
            builder.add((Object)ModularItemModel.buildSideQuad(transform, Direction.DOWN, tintIndex, color, sprite, 0, v + 1, uMax));
        }
        for (int u = 0; u < uMax; ++u) {
            builder.add((Object)ModularItemModel.buildSideQuad(transform, Direction.EAST, tintIndex, color, sprite, u + 1, 0, vMax));
            builder.add((Object)ModularItemModel.buildSideQuad(transform, Direction.WEST, tintIndex, color, sprite, u, 0, vMax));
        }
        builder.add((Object)ModularItemModel.buildQuad(transform, Direction.NORTH, sprite, tintIndex, color, 0.0f, 0.0f, 0.46875f, sprite.func_94209_e(), sprite.func_94210_h(), 0.0f, 1.0f, 0.46875f, sprite.func_94209_e(), sprite.func_94206_g(), 1.0f, 1.0f, 0.46875f, sprite.func_94212_f(), sprite.func_94206_g(), 1.0f, 0.0f, 0.46875f, sprite.func_94212_f(), sprite.func_94210_h()));
        builder.add((Object)ModularItemModel.buildQuad(transform, Direction.SOUTH, sprite, tintIndex, color, 0.0f, 0.0f, 0.53125f, sprite.func_94209_e(), sprite.func_94210_h(), 1.0f, 0.0f, 0.53125f, sprite.func_94212_f(), sprite.func_94210_h(), 1.0f, 1.0f, 0.53125f, sprite.func_94212_f(), sprite.func_94206_g(), 0.0f, 1.0f, 0.53125f, sprite.func_94209_e(), sprite.func_94206_g()));
        return builder.build();
    }

    private static BakedQuad buildSideQuad(TransformationMatrix transform, Direction side, int tintIndex, int color, TextureAtlasSprite sprite, int u, int v, int size) {
        float eps = 0.01f;
        int width = sprite.func_94211_a();
        int height = sprite.func_94216_b();
        float x0 = (float)u / (float)width;
        float y0 = (float)v / (float)height;
        float x1 = x0;
        float y1 = y0;
        float z0 = 0.46875f;
        float z1 = 0.53125f;
        switch (side) {
            case WEST: {
                z0 = 0.53125f;
                z1 = 0.46875f;
                y1 = (float)(v + size) / (float)height;
                break;
            }
            case EAST: {
                y1 = (float)(v + size) / (float)height;
                break;
            }
            case DOWN: {
                z0 = 0.53125f;
                z1 = 0.46875f;
                x1 = (float)(u + size) / (float)width;
                break;
            }
            case UP: {
                x1 = (float)(u + size) / (float)width;
                break;
            }
            default: {
                throw new IllegalArgumentException("can't handle z-oriented side");
            }
        }
        float dx = (float)side.func_176730_m().func_177958_n() * 0.01f / (float)width;
        float dy = (float)side.func_176730_m().func_177956_o() * 0.01f / (float)height;
        float u0 = 16.0f * (x0 - dx);
        float u1 = 16.0f * (x1 - dx);
        float v0 = 16.0f * (1.0f - y0 - dy);
        float v1 = 16.0f * (1.0f - y1 - dy);
        return ModularItemModel.buildQuad(transform, ModularItemModel.remap(side), sprite, tintIndex, color, x0, y0, z0, sprite.func_94214_a((double)u0), sprite.func_94207_b((double)v0), x1, y1, z0, sprite.func_94214_a((double)u1), sprite.func_94207_b((double)v1), x1, y1, z1, sprite.func_94214_a((double)u1), sprite.func_94207_b((double)v1), x0, y0, z1, sprite.func_94214_a((double)u0), sprite.func_94207_b((double)v0));
    }

    private static Direction remap(Direction side) {
        return side.func_176740_k() == Direction.Axis.Y ? side.func_176734_d() : side;
    }

    private static BakedQuad buildQuad(TransformationMatrix transform, Direction side, TextureAtlasSprite sprite, int tintIndex, int color, float x0, float y0, float z0, float u0, float v0, float x1, float y1, float z1, float u1, float v1, float x2, float y2, float z2, float u2, float v2, float x3, float y3, float z3, float u3, float v3) {
        BakedQuadBuilder builder = new BakedQuadBuilder(sprite);
        builder.setQuadTint(tintIndex);
        builder.setQuadOrientation(side);
        boolean hasTransform = !transform.isIdentity();
        BakedQuadBuilder consumer = hasTransform ? new TRSRTransformer((IVertexConsumer)builder, transform) : builder;
        ModularItemModel.putVertex((IVertexConsumer)consumer, side, x0, y0, z0, u0, v0, color);
        ModularItemModel.putVertex((IVertexConsumer)consumer, side, x1, y1, z1, u1, v1, color);
        ModularItemModel.putVertex((IVertexConsumer)consumer, side, x2, y2, z2, u2, v2, color);
        ModularItemModel.putVertex((IVertexConsumer)consumer, side, x3, y3, z3, u3, v3, color);
        return builder.build();
    }

    private static void putVertex(IVertexConsumer consumer, Direction side, float x, float y, float z, float u, float v, int color) {
        VertexFormat format = consumer.getVertexFormat();
        block6: for (int e = 0; e < format.func_227894_c_().size(); ++e) {
            switch (((VertexFormatElement)format.func_227894_c_().get(e)).func_177375_c()) {
                case POSITION: {
                    consumer.put(e, new float[]{x, y, z, 1.0f});
                    continue block6;
                }
                case COLOR: {
                    float r = (float)(color >> 16 & 0xFF) / 255.0f;
                    float g = (float)(color >> 8 & 0xFF) / 255.0f;
                    float b = (float)(color >> 0 & 0xFF) / 255.0f;
                    float a = (float)(color >> 24 & 0xFF) / 255.0f;
                    a = a == 0.0f ? 1.0f : a;
                    consumer.put(e, new float[]{r, g, b, a});
                    continue block6;
                }
                case NORMAL: {
                    float offX = side.func_82601_c();
                    float offY = side.func_96559_d();
                    float offZ = side.func_82599_e();
                    consumer.put(e, new float[]{offX, offY, offZ, 0.0f});
                    continue block6;
                }
                case UV: {
                    if (((VertexFormatElement)format.func_227894_c_().get(e)).func_177369_e() == 0) {
                        consumer.put(e, new float[]{u, v, 0.0f, 1.0f});
                        continue block6;
                    }
                }
                default: {
                    consumer.put(e, new float[0]);
                }
            }
        }
    }
}

