/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.client.model;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModelConfiguration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.tetra.client.model.ModularItemModel;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.module.data.ModuleModel;

public class ModularOverrideList
extends ItemOverrideList {
    private static final Logger logger = LogManager.getLogger();
    private Cache<CacheKey, IBakedModel> bakedModelCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private ModularItemModel model;
    private IModelConfiguration owner;
    private ModelBakery bakery;
    private Function<RenderMaterial, TextureAtlasSprite> spriteGetter;
    private IModelTransform modelTransform;
    private ResourceLocation modelLocation;

    public ModularOverrideList(ModularItemModel model, IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ResourceLocation modelLocation) {
        this.model = model;
        this.owner = owner;
        this.bakery = bakery;
        this.spriteGetter = spriteGetter;
        this.modelTransform = modelTransform;
        this.modelLocation = modelLocation;
    }

    public void clearCache() {
        logger.debug("Clearing item model cache for " + this.modelLocation);
        this.bakedModelCache.invalidateAll();
    }

    @Nullable
    public IBakedModel func_239290_a_(IBakedModel originalModel, ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity entity) {
        CompoundNBT baseTag = stack.func_77978_p();
        IBakedModel result = originalModel;
        if (baseTag != null && !baseTag.isEmpty()) {
            CacheKey key = this.getCacheKey(stack, entity, originalModel);
            try {
                result = (IBakedModel)this.bakedModelCache.get((Object)key, () -> this.getOverrideModel(stack, (World)world, entity));
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    protected IBakedModel getOverrideModel(ItemStack itemStack, @Nullable World world, @Nullable LivingEntity entity) {
        IModularItem item = (IModularItem)itemStack.func_77973_b();
        ImmutableList<ModuleModel> models = item.getModels(itemStack, entity);
        String transformVariant = item.getTransformVariant(itemStack, entity);
        return this.model.realBake((List<ModuleModel>)models, transformVariant, this.owner, this.bakery, this.spriteGetter, this.modelTransform, ItemOverrideList.field_188022_a, this.modelLocation);
    }

    protected CacheKey getCacheKey(ItemStack itemStack, LivingEntity entity, IBakedModel original) {
        return new CacheKey(original, ((IModularItem)itemStack.func_77973_b()).getModelCacheKey(itemStack, entity));
    }

    protected static class CacheKey {
        final IBakedModel parent;
        final String data;

        protected CacheKey(IBakedModel parent, String hash) {
            this.parent = parent;
            this.data = hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.parent != null ? this.parent != cacheKey.parent : cacheKey.parent != null) {
                return false;
            }
            return Objects.equals(this.data, cacheKey.data);
        }

        public int hashCode() {
            int result = this.parent != null ? this.parent.hashCode() : 0;
            result = 31 * result + (this.data != null ? this.data.hashCode() : 0);
            return result;
        }
    }
}

