/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.data.deserializer;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.reflect.TypeToken;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class AttributesDeserializer
implements JsonDeserializer<Multimap<Attribute, AttributeModifier>> {
    public static final TypeToken<Multimap<Attribute, AttributeModifier>> typeToken = new TypeToken<Multimap<Attribute, AttributeModifier>>(){};

    public Multimap<Attribute, AttributeModifier> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        ArrayListMultimap result = ArrayListMultimap.create();
        jsonObject.entrySet().forEach(entry -> {
            Attribute attribute = AttributesDeserializer.getAttribute((String)entry.getKey());
            if (attribute != null) {
                result.put((Object)attribute, (Object)new AttributeModifier("module_data", ((JsonElement)entry.getValue()).getAsDouble(), AttributesDeserializer.getOperation((String)entry.getKey())));
            }
        });
        return result;
    }

    private static AttributeModifier.Operation getOperation(String key) {
        if (key.startsWith("**")) {
            return AttributeModifier.Operation.MULTIPLY_TOTAL;
        }
        if (key.startsWith("*")) {
            return AttributeModifier.Operation.MULTIPLY_BASE;
        }
        return AttributeModifier.Operation.ADDITION;
    }

    private static Attribute getAttribute(String key) {
        ResourceLocation rl = new ResourceLocation(key.replace("*", ""));
        return (Attribute)ForgeRegistries.ATTRIBUTES.getValue(rl);
    }
}

