/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import se.mickelus.tetra.TetraMod;
import se.mickelus.tetra.effect.EffectHelper;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.effect.ItemEffectHandler;
import se.mickelus.tetra.effect.TruesweepPacket;
import se.mickelus.tetra.util.CastOptional;

public class SweepingEffect {
    public static void sweepAttack(ItemStack itemStack, LivingEntity target, LivingEntity attacker, int sweepingLevel) {
        boolean trueSweep = EffectHelper.getEffectLevel(itemStack, ItemEffect.truesweep) > 0;
        float damage = (float)Math.max(attacker.func_233637_b_(Attributes.field_233823_f_) * (double)((float)sweepingLevel * 0.125f), 1.0);
        float knockback = trueSweep ? (float)(EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180313_o, (ItemStack)itemStack) + 1) * 0.5f : 0.5f;
        double range = 1.0 + EffectHelper.getEffectEfficiency(itemStack, ItemEffect.sweeping);
        double reach = attacker.func_233637_b_((Attribute)ForgeMod.REACH_DISTANCE.get());
        attacker.field_70170_p.func_217357_a(LivingEntity.class, target.func_174813_aQ().func_72314_b(range, 0.25, range)).stream().filter(entity -> entity != attacker).filter(entity -> entity != target).filter(entity -> !attacker.func_184191_r((Entity)entity)).filter(entity -> attacker.func_70068_e((Entity)entity) < (range + reach) * (range + reach)).forEach(entity -> {
            DamageSource damageSource;
            entity.func_233627_a_(knockback, (double)MathHelper.func_76126_a((float)(attacker.field_70177_z * (float)Math.PI / 180.0f)), (double)(-MathHelper.func_76134_b((float)(attacker.field_70177_z * (float)Math.PI / 180.0f))));
            DamageSource damageSource2 = damageSource = attacker instanceof PlayerEntity ? DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)attacker)) : DamageSource.func_188403_a((Entity)attacker, (LivingEntity)entity);
            if (trueSweep) {
                ItemEffectHandler.applyHitEffects(itemStack, entity, attacker);
                EffectHelper.applyEnchantmentHitEffects(itemStack, entity, attacker);
                SweepingEffect.causeTruesweepDamage(damageSource, damage, itemStack, attacker, entity);
            } else {
                entity.func_70097_a(damageSource, damage);
            }
        });
        attacker.field_70170_p.func_184148_a(null, attacker.func_226277_ct_(), attacker.func_226278_cu_(), attacker.func_226281_cx_(), SoundEvents.field_187730_dW, attacker.func_184176_by(), 1.0f, 1.0f);
        CastOptional.cast(attacker, PlayerEntity.class).ifPresent(PlayerEntity::func_184810_cG);
    }

    public static void triggerTruesweep() {
        TetraMod.packetHandler.sendToServer(new TruesweepPacket());
    }

    public static void truesweep(ItemStack itemStack, LivingEntity attacker) {
        int sweepingLevel = EffectHelper.getEffectLevel(itemStack, ItemEffect.sweeping);
        float damage = (float)Math.max(attacker.func_233637_b_(Attributes.field_233823_f_) * (double)((float)sweepingLevel * 0.125f), 1.0);
        float knockback = 0.5f + (float)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180313_o, (ItemStack)itemStack) * 0.5f;
        double range = 2.0 + EffectHelper.getEffectEfficiency(itemStack, ItemEffect.sweeping);
        Vector3d target = Vector3d.func_189986_a((float)attacker.field_70125_A, (float)attacker.field_70177_z).func_72432_b().func_186678_a(range).func_178787_e(attacker.func_174824_e(0.0f));
        AxisAlignedBB aoe = new AxisAlignedBB(target, target);
        attacker.field_70170_p.func_217357_a(LivingEntity.class, aoe.func_72314_b(range, 1.0, range)).stream().filter(entity -> entity != attacker).filter(entity -> !attacker.func_184191_r((Entity)entity)).forEach(entity -> {
            entity.func_233627_a_(knockback, (double)MathHelper.func_76126_a((float)(attacker.field_70177_z * (float)Math.PI / 180.0f)), (double)(-MathHelper.func_76134_b((float)(attacker.field_70177_z * (float)Math.PI / 180.0f))));
            ItemEffectHandler.applyHitEffects(itemStack, entity, attacker);
            EffectHelper.applyEnchantmentHitEffects(itemStack, entity, attacker);
            DamageSource damageSource = attacker instanceof PlayerEntity ? DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)attacker)) : DamageSource.func_188403_a((Entity)attacker, (LivingEntity)entity);
            SweepingEffect.causeTruesweepDamage(damageSource, damage, itemStack, attacker, entity);
        });
        attacker.field_70170_p.func_184148_a(null, attacker.func_226277_ct_(), attacker.func_226278_cu_(), attacker.func_226281_cx_(), SoundEvents.field_187730_dW, attacker.func_184176_by(), 1.0f, 1.0f);
        CastOptional.cast(attacker, PlayerEntity.class).ifPresent(PlayerEntity::func_184810_cG);
    }

    private static void causeTruesweepDamage(DamageSource damageSource, float baseDamage, ItemStack itemStack, LivingEntity attacker, LivingEntity target) {
        float targetModifier = EnchantmentHelper.func_152377_a((ItemStack)itemStack, (CreatureAttribute)target.func_70668_bt());
        float critMultiplier = CastOptional.cast(attacker, PlayerEntity.class).map(player -> ForgeHooks.getCriticalHit((PlayerEntity)player, (Entity)target, (boolean)false, (float)1.5f)).map(CriticalHitEvent::getDamageModifier).orElse(Float.valueOf(1.0f)).floatValue();
        target.func_70097_a(damageSource, (baseDamage + targetModifier) * critMultiplier);
        if (targetModifier > 0.0f) {
            CastOptional.cast(attacker, PlayerEntity.class).ifPresent(player -> player.func_71047_c((Entity)target));
        }
        if (critMultiplier > 1.0f) {
            attacker.func_130014_f_().func_184133_a(null, target.func_233580_cy_(), SoundEvents.field_187718_dS, SoundCategory.PLAYERS, 1.0f, 1.3f);
            ((PlayerEntity)attacker).func_71009_b((Entity)target);
        }
    }
}

