/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect.gui;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import se.mickelus.mgui.gui.GuiAttachment;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiTexture;
import se.mickelus.mgui.gui.animation.Applier;
import se.mickelus.mgui.gui.animation.KeyframeAnimation;
import se.mickelus.tetra.effect.ComboPoints;
import se.mickelus.tetra.gui.GuiTextures;
import se.mickelus.tetra.gui.InvertColorGui;

public class ComboPointGui
extends GuiElement {
    private GuiElement container;
    private Point[] points;

    public ComboPointGui() {
        super(-1, 18, 15, 3);
        this.setAttachment(GuiAttachment.middleCenter);
        this.container = new InvertColorGui(0, 0, 15, 3);
        this.addChild(this.container);
        this.points = new Point[4];
        for (int i = 0; i < this.points.length; ++i) {
            this.points[i] = new Point(i * 4, 0, i);
            this.container.addChild((GuiElement)this.points[i]);
        }
    }

    public void update(int points) {
        if (points > 0) {
            for (int i = 0; i < this.points.length; ++i) {
                this.points[i].setVisible(true);
                this.points[i].toggle(points > i);
            }
        } else {
            for (int i = 0; i < this.points.length; ++i) {
                this.points[i].setVisible(false);
            }
        }
    }

    public void update(PlayerEntity player) {
        if (ComboPoints.canSpend((LivingEntity)player)) {
            this.update(ComboPoints.get((Entity)player));
        } else {
            this.update(0);
        }
    }

    static class Point
    extends GuiElement {
        private GuiTexture active = new GuiTexture(0, 0, 3, 3, 3, 4, GuiTextures.hud);
        private GuiTexture inactive;
        private final KeyframeAnimation showAnimation;
        private final KeyframeAnimation hideAnimation;

        public Point(int x, int y, int offset) {
            super(x, y - 3, 3, 3);
            this.addChild((GuiElement)this.active);
            this.inactive = new GuiTexture(0, 0, 3, 3, 6, 4, GuiTextures.hud);
            this.addChild((GuiElement)this.inactive);
            this.showAnimation = new KeyframeAnimation(60, (GuiElement)this).applyTo(new Applier[]{new Applier.Opacity(1.0f), new Applier.TranslateY((float)y)}).withDelay(50 * offset);
            this.hideAnimation = new KeyframeAnimation(100, (GuiElement)this).applyTo(new Applier[]{new Applier.Opacity(0.0f), new Applier.TranslateY((float)(y - 3))}).withDelay(50 * offset).onStop(complete -> {
                if (complete.booleanValue()) {
                    this.isVisible = false;
                }
            });
        }

        public void toggle(boolean on) {
            this.active.setVisible(on);
            this.inactive.setVisible(!on);
        }

        protected void onShow() {
            if (!this.showAnimation.isActive()) {
                this.showAnimation.start();
            }
            this.hideAnimation.stop();
        }

        protected boolean onHide() {
            if (!this.hideAnimation.isActive()) {
                this.hideAnimation.start();
            }
            this.showAnimation.stop();
            return false;
        }
    }
}

