/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect.potion;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Random;
import net.minecraft.client.gui.DisplayEffectsScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import se.mickelus.tetra.effect.EffectHelper;

public class PuncturedPotionEffect
extends Effect {
    public static PuncturedPotionEffect instance;

    public PuncturedPotionEffect() {
        super(EffectType.HARMFUL, 0x880000);
        this.setRegistryName("punctured");
        this.func_220304_a(Attributes.field_233826_i_, "69967662-e7e9-4671-8f48-81d0de9d2098", -0.05, AttributeModifier.Operation.MULTIPLY_TOTAL);
        instance = this;
    }

    public void func_76394_a(LivingEntity entity, int amplifier) {
        if (!entity.func_130014_f_().field_72995_K) {
            Random rand = entity.func_70681_au();
            EquipmentSlotType slot = EquipmentSlotType.values()[2 + rand.nextInt(4)];
            ItemStack itemStack = entity.func_184582_a(slot);
            if (!itemStack.func_190926_b()) {
                ((ServerWorld)entity.field_70170_p).func_195598_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, itemStack), entity.func_226277_ct_() + (double)entity.func_213311_cf() * (0.3 + rand.nextGaussian() * 0.4), entity.func_226278_cu_() + (double)entity.func_213302_cg() * (0.2 + rand.nextGaussian() * 0.4), entity.func_226281_cx_() + (double)entity.func_213311_cf() * (0.3 + rand.nextGaussian() * 0.4), 10, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public boolean func_76397_a(int duration, int amplifier) {
        return duration % 10 == 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderInventoryEffect(EffectInstance effect, DisplayEffectsScreen<?> gui, MatrixStack mStack, int x, int y, float z) {
        super.renderInventoryEffect(effect, gui, mStack, x, y, z);
        int amp = effect.func_76458_c() + 1;
        double armor = gui.getMinecraft().field_71439_g.func_70658_aO();
        double armorReduction = armor / (1.0 - (double)amp * 0.1) - armor;
        EffectHelper.renderInventoryEffectTooltip(gui, mStack, x, y, () -> new StringTextComponent(I18n.func_135052_a((String)"effect.tetra.punctured.tooltip", (Object[])new Object[]{String.format("%d", amp * 10), String.format("%.1f", armorReduction)})));
    }
}

