/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect.revenge;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.tetra.TetraMod;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.effect.revenge.AddRevengePacket;
import se.mickelus.tetra.effect.revenge.RemoveRevengePacket;
import se.mickelus.tetra.items.modular.IModularItem;

public class RevengeTracker {
    private static final Logger logger = LogManager.getLogger();
    private static Cache<Integer, Collection<Integer>> cache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(30L, TimeUnit.SECONDS).build();

    private static int getIdentifier(Entity entity) {
        return entity.field_70170_p.field_72995_K ? -entity.func_145782_y() : entity.func_145782_y();
    }

    public static boolean canRevenge(LivingEntity entity) {
        return Stream.of(entity.func_184614_ca(), entity.func_184592_cb()).filter(itemStack -> itemStack.func_77973_b() instanceof IModularItem).anyMatch(itemStack -> RevengeTracker.canRevenge((IModularItem)itemStack.func_77973_b(), itemStack));
    }

    public static boolean canRevenge(IModularItem item, ItemStack itemStack) {
        return item.getEffectLevel(itemStack, ItemEffect.abilityRevenge) > 0;
    }

    public static boolean canRevenge(Entity entity, Entity enemy) {
        return Optional.ofNullable((Collection)cache.getIfPresent((Object)RevengeTracker.getIdentifier(entity))).map(enemies -> enemies.contains(enemy.func_145782_y())).orElse(false);
    }

    public static void onAttackEntity(LivingAttackEvent event) {
        Entity enemy;
        Entity entity = event.getEntity();
        if (!event.getEntity().func_130014_f_().func_201670_d() && EntityType.field_200729_aH.equals(entity.func_200600_R()) && (enemy = event.getSource().func_76346_g()) != null) {
            RevengeTracker.addEnemy(entity, enemy);
            if (entity instanceof ServerPlayerEntity) {
                TetraMod.packetHandler.sendTo(new AddRevengePacket(enemy), (ServerPlayerEntity)entity);
            } else {
                logger.warn("Unable to sync revenge state, server entity of type player is of other heritage. This should not happen");
            }
        }
    }

    public static void removeEnemySynced(ServerPlayerEntity entity, Entity enemy) {
        RevengeTracker.removeEnemy((Entity)entity, enemy.func_145782_y());
        TetraMod.packetHandler.sendTo(new RemoveRevengePacket(enemy), entity);
    }

    public static void removeEnemy(Entity entity, Entity enemy) {
        RevengeTracker.removeEnemy(entity, enemy.func_145782_y());
    }

    public static void removeEnemy(Entity entity, int enemyId) {
        Optional.ofNullable((Collection)cache.getIfPresent((Object)RevengeTracker.getIdentifier(entity))).ifPresent(enemies -> enemies.remove(enemyId));
    }

    public static void addEnemy(Entity entity, Entity enemy) {
        RevengeTracker.addEnemy(entity, enemy.func_145782_y());
    }

    public static void addEnemy(Entity entity, int enemyId) {
        try {
            ((Collection)cache.get((Object)RevengeTracker.getIdentifier(entity), HashSet::new)).add(enemyId);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }
}

