/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui;

import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import se.mickelus.mgui.gui.GuiAttachment;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiString;
import se.mickelus.mgui.gui.GuiStringSmall;
import se.mickelus.tetra.Tooltips;
import se.mickelus.tetra.gui.statbar.GuiBar;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.util.CastOptional;

public class GuiMagicUsage
extends GuiElement {
    protected GuiString valueString;
    protected GuiBar bar;
    protected List<String> tooltip;
    protected List<String> tooltipExtended;

    public GuiMagicUsage(int x, int y, int barLength) {
        super(x, y, barLength, 12);
        this.addChild((GuiElement)new GuiStringSmall(0, 0, I18n.func_135052_a((String)"item.tetra.modular.magic_capacity.label", (Object[])new Object[0])));
        this.valueString = new GuiStringSmall(0, 0, "");
        this.valueString.setAttachment(GuiAttachment.topRight);
        this.addChild((GuiElement)this.valueString);
        this.bar = new GuiBar(0, 0, barLength, 0.0, 0.0);
        this.addChild(this.bar);
    }

    public void update(ItemStack itemStack, ItemStack previewStack, String slot) {
        if (!previewStack.func_190926_b()) {
            int value = GuiMagicUsage.getCost(itemStack, slot);
            int diffValue = GuiMagicUsage.getCost(previewStack, slot) - value;
            int max = GuiMagicUsage.getGain(itemStack, slot);
            int diffMax = GuiMagicUsage.getGain(previewStack, slot) - max;
            int risk = Math.round(GuiMagicUsage.getDestabilizeChance(previewStack, slot) * 100.0f);
            int xpCost = GuiMagicUsage.getExperienceCost(previewStack, slot);
            this.bar.setMax(Math.max(max + diffMax, max));
            this.tooltip = Arrays.asList(I18n.func_135052_a((String)"item.tetra.modular.magic_capacity.description", (Object[])new Object[]{max, value + diffValue, xpCost, risk}), " ", Tooltips.expand.getString());
            this.tooltipExtended = Arrays.asList(I18n.func_135052_a((String)"item.tetra.modular.magic_capacity.description", (Object[])new Object[]{max, value + diffValue, xpCost, risk}), " ", Tooltips.expanded.getString(), I18n.func_135052_a((String)"item.tetra.modular.magic_capacity.description_extended", (Object[])new Object[0]));
            if (diffMax != 0) {
                this.bar.setValue(max, max + diffMax);
                this.valueString.setString(String.format("%s(%+d)%s %d/%d", diffMax < 0 ? TextFormatting.RED : TextFormatting.GREEN, diffMax, TextFormatting.RESET, max + diffMax, max + diffMax));
            } else if (diffValue != 0) {
                this.bar.setValue(max - value, max - value - diffValue);
                this.valueString.setString(String.format("%s(%+d)%s %d/%d", diffValue > 0 ? TextFormatting.RED : TextFormatting.GREEN, -diffValue, TextFormatting.RESET, max - value - diffValue, max));
            } else {
                this.bar.setValue(max - value, max - value);
                this.valueString.setString(String.format("%d/%d", max - value, max));
            }
        } else {
            int value = GuiMagicUsage.getCost(itemStack, slot);
            int max = GuiMagicUsage.getGain(itemStack, slot);
            int risk = Math.round(GuiMagicUsage.getDestabilizeChance(itemStack, slot) * 100.0f);
            int xpCost = GuiMagicUsage.getExperienceCost(itemStack, slot);
            this.tooltip = Arrays.asList(I18n.func_135052_a((String)"item.tetra.modular.magic_capacity.description", (Object[])new Object[]{max, value, xpCost, risk}), " ", Tooltips.expand.getString());
            this.tooltipExtended = Arrays.asList(I18n.func_135052_a((String)"item.tetra.modular.magic_capacity.description", (Object[])new Object[]{max, value, xpCost, risk}), " ", Tooltips.expanded.getString(), I18n.func_135052_a((String)"item.tetra.modular.magic_capacity.description_extended", (Object[])new Object[0]));
            this.valueString.setString(String.format("%d/%d", max - value, max));
            this.bar.setMax(max);
            this.bar.setValue(max - value, max - value);
        }
    }

    private static int getGain(ItemStack itemStack, String slot) {
        return CastOptional.cast(itemStack.func_77973_b(), IModularItem.class).map(item -> item.getModuleFromSlot(itemStack, slot)).map(module -> module.getMagicCapacityGain(itemStack)).orElse(0);
    }

    private static int getCost(ItemStack itemStack, String slot) {
        return CastOptional.cast(itemStack.func_77973_b(), IModularItem.class).map(item -> item.getModuleFromSlot(itemStack, slot)).map(module -> module.getMagicCapacityCost(itemStack)).orElse(0);
    }

    private static float getDestabilizeChance(ItemStack itemStack, String slot) {
        return CastOptional.cast(itemStack.func_77973_b(), IModularItem.class).map(item -> item.getModuleFromSlot(itemStack, slot)).map(module -> Float.valueOf(module.getDestabilizationChance(itemStack, 1.0f))).orElse(Float.valueOf(0.0f)).floatValue();
    }

    private static int getExperienceCost(ItemStack itemStack, String slot) {
        return CastOptional.cast(itemStack.func_77973_b(), IModularItem.class).map(item -> item.getModuleFromSlot(itemStack, slot)).map(module -> module.getRepairExperienceCost(itemStack)).orElse(0);
    }

    public boolean hasChanged(ItemStack itemStack, ItemStack previewStack, String slot) {
        return !previewStack.func_190926_b() && (GuiMagicUsage.getCost(itemStack, slot) != GuiMagicUsage.getCost(previewStack, slot) || GuiMagicUsage.getGain(itemStack, slot) != GuiMagicUsage.getGain(previewStack, slot));
    }

    public boolean providesCapacity(ItemStack itemStack, ItemStack previewStack, String slot) {
        return GuiMagicUsage.getGain(itemStack, slot) > 0 || GuiMagicUsage.getGain(previewStack, slot) > 0;
    }

    public List<String> getTooltipLines() {
        if (this.hasFocus()) {
            if (Screen.func_231173_s_()) {
                return this.tooltipExtended;
            }
            return this.tooltip;
        }
        return super.getTooltipLines();
    }
}

