/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui;

import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import se.mickelus.mgui.gui.GuiAttachment;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiString;
import se.mickelus.mgui.gui.GuiStringSmall;
import se.mickelus.mgui.gui.animation.Applier;
import se.mickelus.mgui.gui.animation.KeyframeAnimation;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.Tooltips;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.gui.statbar.GuiBar;
import se.mickelus.tetra.items.modular.IModularItem;

public class HoneProgressGui
extends GuiElement {
    protected GuiString labelString = new GuiStringSmall(0, 0, I18n.func_135052_a((String)"item.tetra.modular.hone_progress.label", (Object[])new Object[0]));
    protected GuiString valueString;
    protected GuiBar bar;
    protected List<String> tooltip;
    protected List<String> extendedTooltip;

    public HoneProgressGui(int x, int y) {
        super(x, y, 45, 12);
        this.addChild((GuiElement)this.labelString);
        this.valueString = new GuiStringSmall(0, 0, "");
        this.valueString.setAttachment(GuiAttachment.topRight);
        this.addChild((GuiElement)this.valueString);
        this.bar = new GuiBar(0, 0, this.width, 0.0, 1.0);
        this.addChild(this.bar);
    }

    public void update(ItemStack itemStack, boolean isPlaceholder) {
        boolean shouldShow = !isPlaceholder && itemStack.func_77973_b() instanceof IModularItem && (Boolean)ConfigHandler.moduleProgression.get() != false && ((IModularItem)itemStack.func_77973_b()).canGainHoneProgress();
        this.setVisible(shouldShow);
        if (shouldShow) {
            IModularItem item = (IModularItem)itemStack.func_77973_b();
            int limit = item.getHoningLimit(itemStack);
            int progress = limit - item.getHoningProgress(itemStack);
            float factor = MathHelper.func_76131_a((float)(1.0f * (float)progress / (float)limit), (float)0.0f, (float)1.0f);
            float workableFactor = -item.getEffectLevel(itemStack, ItemEffect.workable);
            String factorString = String.format("%.0f%%", Float.valueOf(100.0f * factor));
            String tooltipBase = I18n.func_135052_a((String)"item.tetra.modular.hone_progress.description", (Object[])new Object[]{progress, limit, factorString, item.getHoneBase(), item.getHoningIntegrityPenalty(itemStack)});
            if (workableFactor < 0.0f) {
                tooltipBase = tooltipBase + I18n.func_135052_a((String)"item.tetra.modular.hone_progress.description_workable", (Object[])new Object[]{String.format("%.0f%%", Float.valueOf(workableFactor))});
            }
            this.tooltip = Collections.singletonList(tooltipBase + "\n \n" + Tooltips.expand.getString());
            this.extendedTooltip = Collections.singletonList(tooltipBase + "\n \n" + Tooltips.expanded.getString() + "\n" + TextFormatting.GRAY.toString() + I18n.func_135052_a((String)"item.tetra.modular.hone_progress.description_extended", (Object[])new Object[0]));
            this.valueString.setString(factorString);
            this.bar.setValue(factor, factor);
            if (factor < 1.0f) {
                this.labelString.setColor(0xFFFFFF);
                this.valueString.setColor(0xFFFFFF);
                this.bar.setColor(0xFFFFFF);
            } else {
                this.labelString.setColor(0xCECEFF);
                this.valueString.setColor(0xCECEFF);
                this.bar.setColor(0xCECEFF);
            }
        }
    }

    public void showAnimation() {
        if (this.isVisible()) {
            new KeyframeAnimation(100, (GuiElement)this).withDelay(600).applyTo(new Applier[]{new Applier.Opacity(0.0f, 1.0f), new Applier.TranslateX(-3.0f, 0.0f, true)}).start();
        }
    }

    public List<String> getTooltipLines() {
        if (this.hasFocus()) {
            if (Screen.func_231173_s_()) {
                return this.extendedTooltip;
            }
            return this.tooltip;
        }
        return super.getTooltipLines();
    }
}

