/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui;

import se.mickelus.mgui.gui.GuiAttachment;
import se.mickelus.mgui.gui.GuiClickable;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiRect;
import se.mickelus.mgui.gui.GuiString;
import se.mickelus.mgui.gui.animation.AnimationChain;
import se.mickelus.mgui.gui.animation.Applier;
import se.mickelus.mgui.gui.animation.KeyframeAnimation;
import se.mickelus.tetra.gui.GuiKeybinding;

public class VerticalTabButtonGui
extends GuiClickable {
    protected boolean hasContent = false;
    protected boolean isActive;
    protected GuiRect indicator;
    protected GuiString label;
    protected GuiKeybinding keybinding;
    protected AnimationChain indicatorFlash;
    protected KeyframeAnimation labelShow;
    protected KeyframeAnimation labelHide;
    protected KeyframeAnimation keybindShow;
    protected KeyframeAnimation keybindHide;

    public VerticalTabButtonGui(int x, int y, String label, String keybinding, Runnable onClickHandler, boolean initiallyActive) {
        super(x, y, 0, 15, onClickHandler);
        this.setAttachmentPoint(GuiAttachment.topRight);
        this.indicator = new GuiRect(0, 0, 1, 15, 0xFFFFFF);
        this.indicator.setAttachment(GuiAttachment.topRight);
        this.addChild((GuiElement)this.indicator);
        this.indicatorFlash = new AnimationChain(new KeyframeAnimation[]{new KeyframeAnimation(40, (GuiElement)this.indicator).applyTo(new Applier[]{new Applier.TranslateX(-3.0f)}), new KeyframeAnimation(60, (GuiElement)this.indicator).applyTo(new Applier[]{new Applier.TranslateX(0.0f)})});
        this.label = new GuiString(-5, 4, label);
        this.label.setAttachment(GuiAttachment.topRight);
        this.label.setOpacity(0.0f);
        this.addChild((GuiElement)this.label);
        this.labelShow = new KeyframeAnimation(100, (GuiElement)this.label).applyTo(new Applier[]{new Applier.Opacity(1.0f), new Applier.TranslateX(-5.0f)});
        this.labelHide = new KeyframeAnimation(150, (GuiElement)this.label).applyTo(new Applier[]{new Applier.Opacity(0.0f), new Applier.TranslateX(-2.0f)});
        this.keybinding = new GuiKeybinding(0, 2, keybinding);
        this.keybinding.setOpacity(0.0f);
        this.keybindShow = new KeyframeAnimation(100, (GuiElement)this.keybinding).applyTo(new Applier[]{new Applier.Opacity(1.0f), new Applier.TranslateX(0.0f)});
        this.keybindHide = new KeyframeAnimation(150, (GuiElement)this.keybinding).applyTo(new Applier[]{new Applier.Opacity(0.0f), new Applier.TranslateX(3.0f)});
        if (keybinding != null) {
            this.addChild(this.keybinding);
        }
        this.width = this.label.getWidth() + 10;
        this.isActive = initiallyActive;
        this.updateStyling();
    }

    protected void updateStyling() {
        if (this.isActive) {
            this.indicator.setOpacity(1.0f);
        } else if (this.hasContent) {
            this.indicator.setOpacity(0.5f);
        } else {
            this.indicator.setOpacity(0.25f);
        }
        this.indicator.setColor(this.hasFocus() ? 0xFFFFCC : 0xFFFFFF);
    }

    public void setHasContent(boolean hasContent) {
        this.hasContent = hasContent;
        this.updateStyling();
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
        this.updateStyling();
        if (isActive) {
            this.indicatorFlash.stop();
            this.indicatorFlash.start();
        }
    }

    protected void onFocus() {
        this.updateStyling();
        this.labelHide.stop();
        this.keybindHide.stop();
        this.labelShow.stop();
        this.keybindShow.stop();
        this.labelShow.start();
        this.keybindShow.start();
    }

    protected void onBlur() {
        this.updateStyling();
        this.labelShow.stop();
        this.keybindShow.stop();
        this.labelHide.stop();
        this.keybindHide.stop();
        this.labelHide.start();
        this.keybindHide.start();
    }
}

