/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.statbar;

import java.util.Collections;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import se.mickelus.mgui.gui.GuiAlignment;
import se.mickelus.mgui.gui.GuiAttachment;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiRect;
import se.mickelus.mgui.gui.GuiString;
import se.mickelus.mgui.gui.GuiStringSmall;
import se.mickelus.tetra.gui.statbar.GuiBar;
import se.mickelus.tetra.gui.statbar.GuiBarSegmented;
import se.mickelus.tetra.gui.statbar.GuiStatBase;
import se.mickelus.tetra.gui.statbar.getter.ILabelGetter;
import se.mickelus.tetra.gui.statbar.getter.IStatGetter;
import se.mickelus.tetra.gui.statbar.getter.ITooltipGetter;
import se.mickelus.tetra.gui.statbar.getter.LabelGetterBasic;
import se.mickelus.tetra.gui.statbar.getter.StatGetterIntegrity;
import se.mickelus.tetra.gui.statbar.getter.TooltipGetterInteger;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.util.CastOptional;

public class GuiStatBarIntegrity
extends GuiStatBase {
    protected double max = 9.0;
    protected GuiString labelString = new GuiStringSmall(0, 0, I18n.func_135052_a((String)"tetra.stats.integrity", (Object[])new Object[0]));
    protected GuiString valueString;
    protected GuiBar barPositive;
    protected GuiBar barNegative;
    protected List<String> tooltip;
    protected IStatGetter statGetter;
    protected ILabelGetter labelGetter;
    protected ITooltipGetter tooltipGetterPositive;
    protected ITooltipGetter tooltipGetterNegative;

    public GuiStatBarIntegrity(int x, int y) {
        super(x, y, 59, 12);
        this.addChild((GuiElement)this.labelString);
        this.valueString = new GuiStringSmall(0, 0, "");
        this.valueString.setAttachment(GuiAttachment.topRight);
        this.addChild((GuiElement)this.valueString);
        this.barNegative = new GuiBarSegmented(-1, 0, 27, 0.0, this.max, true);
        this.barNegative.setAlignment(GuiAlignment.right);
        this.addChild(this.barNegative);
        this.barPositive = new GuiBarSegmented(1, 0, 27, 0.0, this.max);
        this.barPositive.setAttachment(GuiAttachment.topRight);
        this.addChild(this.barPositive);
        this.addChild((GuiElement)new GuiRect(29, 5, 1, 3, 0x7F7F7F));
        this.statGetter = new StatGetterIntegrity();
        this.labelGetter = LabelGetterBasic.integerLabel;
        this.tooltipGetterPositive = new TooltipGetterInteger("tetra.stats.integrity.tooltip_positive", this.statGetter);
        this.tooltipGetterNegative = new TooltipGetterInteger("tetra.stats.integrity.tooltip_negative", this.statGetter, true);
    }

    @Override
    public void setAlignment(GuiAlignment alignment) {
    }

    @Override
    public void update(PlayerEntity player, ItemStack currentStack, ItemStack previewStack, String slot, String improvement) {
        double diffValue;
        double value;
        if (!previewStack.func_190926_b()) {
            value = this.statGetter.getValue(player, currentStack);
            diffValue = this.statGetter.getValue(player, previewStack);
        } else {
            value = this.statGetter.getValue(player, currentStack);
            if (slot != null) {
                diffValue = value;
                value -= this.getSlotValue(player, currentStack, slot, improvement);
            } else {
                diffValue = value;
            }
        }
        this.tooltip = value < 0.0 ? Collections.singletonList(this.tooltipGetterNegative.getTooltip(player, previewStack)) : Collections.singletonList(this.tooltipGetterPositive.getTooltip(player, previewStack));
        this.updateValue(value, diffValue);
        this.labelString.setString(I18n.func_135052_a((String)"tetra.stats.integrity", (Object[])new Object[0]));
    }

    @Override
    public boolean shouldShow(PlayerEntity player, ItemStack currentStack, ItemStack previewStack, String slot, String improvement) {
        return this.statGetter.shouldShow(player, currentStack, previewStack);
    }

    protected double getSlotValue(PlayerEntity player, ItemStack itemStack, String slot, String improvement) {
        return CastOptional.cast(itemStack.func_77973_b(), IModularItem.class).map(item -> {
            if (improvement != null) {
                return this.statGetter.getValue(player, itemStack, slot, improvement);
            }
            return this.statGetter.getValue(player, itemStack, slot);
        }).orElse(0.0);
    }

    public void updateValue(double value, double diffValue) {
        this.barNegative.setValue(value > 0.0 ? 0.0 : -value, diffValue > 0.0 ? 0.0 : -diffValue);
        this.barPositive.setValue(value < 0.0 ? 0.0 : value, diffValue < 0.0 ? 0.0 : diffValue);
        this.updateValueLabel(value, diffValue);
    }

    private void updateValueLabel(double value, double diffValue) {
        this.valueString.setString(this.labelGetter.getLabel(value, diffValue, false));
    }

    public List<String> getTooltipLines() {
        if (this.hasFocus()) {
            return this.tooltip;
        }
        return super.getTooltipLines();
    }
}

