/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.statbar;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ToolType;
import se.mickelus.mgui.gui.GuiAlignment;
import se.mickelus.tetra.blocks.workbench.gui.GuiTool;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.gui.statbar.GuiStatBar;
import se.mickelus.tetra.gui.statbar.GuiStatIndicator;
import se.mickelus.tetra.gui.statbar.StrikingStatIndicatorGui;
import se.mickelus.tetra.gui.statbar.getter.IStatGetter;
import se.mickelus.tetra.gui.statbar.getter.LabelGetterBasic;
import se.mickelus.tetra.gui.statbar.getter.StatGetterEffectLevel;
import se.mickelus.tetra.gui.statbar.getter.StatGetterToolEfficiency;
import se.mickelus.tetra.gui.statbar.getter.StatGetterToolLevel;
import se.mickelus.tetra.gui.statbar.getter.TooltipGetterInteger;
import se.mickelus.tetra.gui.statbar.getter.TooltipGetterTool;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.util.CastOptional;

public class GuiStatBarTool
extends GuiStatBar {
    private static final int efficiencyMax = 50;
    private GuiTool icon;
    private IStatGetter levelGetter;
    private boolean efficiencyVisibility;

    public GuiStatBarTool(int x, int y, int width, ToolType toolType) {
        this(x, y, width, toolType, false);
    }

    public GuiStatBarTool(int x, int y, int width, ToolType toolType, boolean efficiencyVisibility) {
        super(x, y, width, null, 0.0, 50.0, false, new StatGetterToolEfficiency(toolType), LabelGetterBasic.decimalLabel, new TooltipGetterTool(toolType));
        this.efficiencyVisibility = efficiencyVisibility;
        this.bar.setWidth(width - 16);
        this.bar.setX(16);
        this.levelGetter = new StatGetterToolLevel(toolType);
        this.icon = new GuiTool(-3, -3, toolType);
        this.addChild(this.icon);
        StatGetterEffectLevel extractorGetter = new StatGetterEffectLevel(ItemEffect.extractor, 4.5);
        this.setIndicators(new StrikingStatIndicatorGui(toolType), new GuiStatIndicator(0, 0, "tetra.stats.tool.extractor", 7, extractorGetter, new TooltipGetterInteger("tetra.stats.tool.extractor.tooltip", extractorGetter)));
    }

    @Override
    public void update(PlayerEntity player, ItemStack currentStack, ItemStack previewStack, String slot, String improvement) {
        super.update(player, currentStack, previewStack, slot, improvement);
        int level = (int)this.levelGetter.getValue(player, currentStack);
        int color = 0xFFFFFF;
        if (!previewStack.func_190926_b()) {
            int previewLevel = (int)this.levelGetter.getValue(player, previewStack);
            color = this.getDiffColor(level, previewLevel);
            level = previewLevel;
        } else if (slot != null) {
            int previewLevel = level - this.getSlotLevel(player, currentStack, slot, improvement);
            color = this.getDiffColor(previewLevel, level);
        }
        this.icon.update(level, color);
    }

    @Override
    protected void realign() {
        super.realign();
        if (GuiAlignment.left.equals((Object)this.alignment)) {
            this.bar.setX(16);
            this.icon.setX(-3);
        } else {
            this.bar.setX(0);
            this.icon.setX(0);
        }
        this.icon.setAttachment(this.alignment.toAttachment());
        int offset = this.icon.getWidth() + 2;
        this.indicatorGroup.setX(GuiAlignment.right.equals((Object)this.alignment) ? -offset : offset);
    }

    @Override
    public boolean shouldShow(PlayerEntity player, ItemStack currentStack, ItemStack previewStack, String slot, String improvement) {
        return this.levelGetter.getValue(player, currentStack) > 0.0 || this.levelGetter.getValue(player, previewStack) > 0.0 || this.efficiencyVisibility && (this.statGetter.getValue(player, currentStack) > 0.0 || this.statGetter.getValue(player, previewStack) > 0.0);
    }

    protected int getDiffColor(int currentValue, int previewValue) {
        if (previewValue > currentValue) {
            return 0x55FF55;
        }
        if (previewValue < currentValue) {
            return 0xFF5555;
        }
        return 0xFFFFFF;
    }

    protected int getSlotLevel(PlayerEntity player, ItemStack itemStack, String slot, String improvement) {
        return CastOptional.cast(itemStack.func_77973_b(), IModularItem.class).map(item -> {
            if (improvement != null) {
                return this.levelGetter.getValue(player, itemStack, slot, improvement);
            }
            return this.levelGetter.getValue(player, itemStack, slot);
        }).orElse(-1.0).intValue();
    }
}

