/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.statbar;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ToolType;
import se.mickelus.tetra.ToolTypes;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.gui.statbar.GuiStatIndicator;
import se.mickelus.tetra.gui.statbar.getter.StatGetterEffectLevel;
import se.mickelus.tetra.gui.statbar.getter.TooltipGetterNone;

public class StrikingStatIndicatorGui
extends GuiStatIndicator {
    GuiStatIndicator striking;
    GuiStatIndicator sweeping;
    GuiStatIndicator current;

    public StrikingStatIndicatorGui(ToolType toolType) {
        super(0, 0, "", 0, null, null);
        if (toolType == ToolType.AXE) {
            this.striking = new GuiStatIndicator(0, 0, "tetra.stats.tool.striking", 0, new StatGetterEffectLevel(ItemEffect.strikingAxe, 1.0), new TooltipGetterNone("tetra.stats.tool.striking.tooltip"));
        } else if (toolType == ToolType.PICKAXE) {
            this.striking = new GuiStatIndicator(0, 0, "tetra.stats.tool.striking", 0, new StatGetterEffectLevel(ItemEffect.strikingPickaxe, 1.0), new TooltipGetterNone("tetra.stats.tool.striking.tooltip"));
        } else if (toolType == ToolTypes.cut) {
            this.striking = new GuiStatIndicator(0, 0, "tetra.stats.tool.striking", 0, new StatGetterEffectLevel(ItemEffect.strikingCut, 1.0), new TooltipGetterNone("tetra.stats.tool.striking.tooltip"));
        } else if (toolType == ToolType.SHOVEL) {
            this.striking = new GuiStatIndicator(0, 0, "tetra.stats.tool.striking", 0, new StatGetterEffectLevel(ItemEffect.strikingShovel, 1.0), new TooltipGetterNone("tetra.stats.tool.striking.tooltip"));
        } else if (toolType == ToolType.HOE) {
            this.striking = new GuiStatIndicator(0, 0, "tetra.stats.tool.striking", 0, new StatGetterEffectLevel(ItemEffect.strikingHoe, 1.0), new TooltipGetterNone("tetra.stats.tool.striking.tooltip"));
        }
        this.sweeping = new GuiStatIndicator(0, 0, "tetra.stats.tool.sweeping", 1, new StatGetterEffectLevel(ItemEffect.sweepingStrike, 1.0), new TooltipGetterNone("tetra.stats.tool.sweeping.tooltip"));
    }

    @Override
    public boolean update(PlayerEntity player, ItemStack currentStack, ItemStack previewStack, String slot, String improvement) {
        if (this.striking != null && this.striking.update(player, currentStack, previewStack, slot, improvement)) {
            this.current = this.sweeping.update(player, currentStack, previewStack, slot, improvement) ? this.sweeping : this.striking;
            return true;
        }
        this.current = null;
        return false;
    }

    @Override
    public boolean isActive(PlayerEntity player, ItemStack itemStack) {
        return this.current != null && this.current.isActive(player, itemStack);
    }

    @Override
    protected int getDiffColor(double value, double diffValue) {
        return Optional.ofNullable(this.current).map(c -> c.getDiffColor(value, diffValue)).orElse(0xFFFFFF);
    }

    @Override
    public String getLabel() {
        return Optional.ofNullable(this.current).map(c -> c.label).orElse("");
    }

    @Override
    public String getTooltipBase(PlayerEntity player, ItemStack itemStack) {
        return Optional.ofNullable(this.current).map(c -> c.getTooltipBase(player, itemStack)).orElse("");
    }

    @Override
    public boolean hasExtendedTooltip(PlayerEntity player, ItemStack itemStack) {
        return Optional.ofNullable(this.current).map(c -> c.hasExtendedTooltip(player, itemStack)).orElse(false);
    }

    @Override
    public String getTooltipExtension(PlayerEntity player, ItemStack itemStack) {
        return Optional.ofNullable(this.current).map(c -> c.getTooltipExtension(player, itemStack)).orElse("");
    }

    public void draw(MatrixStack matrixStack, int refX, int refY, int screenWidth, int screenHeight, int mouseX, int mouseY, float opacity) {
        if (this.current != null) {
            this.current.draw(matrixStack, refX, refY, screenWidth, screenHeight, mouseX, mouseY, opacity);
        }
    }
}

