/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.statbar.getter;

import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ToolType;
import se.mickelus.tetra.gui.statbar.getter.IStatGetter;
import se.mickelus.tetra.gui.statbar.getter.ITooltipGetter;
import se.mickelus.tetra.gui.statbar.getter.StatGetterToolEfficiency;
import se.mickelus.tetra.gui.statbar.getter.StatGetterToolLevel;

public class TooltipGetterTool
implements ITooltipGetter {
    private final IStatGetter levelGetter;
    private final IStatGetter efficiencyGetter;
    private final String localizationKey;

    public TooltipGetterTool(ToolType tool) {
        this.localizationKey = "tetra.stats." + tool.getName() + ".tooltip";
        this.levelGetter = new StatGetterToolLevel(tool);
        this.efficiencyGetter = new StatGetterToolEfficiency(tool);
    }

    @Override
    public String getTooltipBase(PlayerEntity player, ItemStack itemStack) {
        return I18n.func_135052_a((String)this.localizationKey, (Object[])new Object[]{(int)this.levelGetter.getValue(player, itemStack), String.format("%.2f", this.efficiencyGetter.getValue(player, itemStack))});
    }

    @Override
    public boolean hasExtendedTooltip(PlayerEntity player, ItemStack itemStack) {
        return true;
    }

    @Override
    public String getTooltipExtension(PlayerEntity player, ItemStack itemStack) {
        return I18n.func_135052_a((String)"tetra.stats.tool.tooltip_extended", (Object[])new Object[0]);
    }
}

