/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.cell;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.tetra.blocks.forged.ForgedBlockCommon;
import se.mickelus.tetra.items.TetraItem;
import se.mickelus.tetra.items.TetraItemGroup;

public class ItemCellMagmatic
extends TetraItem {
    private static final String unlocalizedName = "magmatic_cell";
    @ObjectHolder(value="tetra:magmatic_cell")
    public static ItemCellMagmatic instance;
    private final String chargedPropKey = "tetra:charged";
    public static final int maxCharge = 128;

    public ItemCellMagmatic() {
        super(new Item.Properties().func_200917_a(1).func_200918_c(128).func_200916_a((ItemGroup)TetraItemGroup.instance));
        this.setRegistryName(unlocalizedName);
    }

    @Override
    public void clientInit() {
        ItemModelsProperties.func_239418_a_((Item)this, (ResourceLocation)new ResourceLocation("tetra:charged"), (itemStack, world, livingEntity) -> this.getCharge(itemStack) > 0 ? 1.0f : 0.0f);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        int charge = this.getCharge(stack);
        TranslationTextComponent chargeLine = new TranslationTextComponent("item.tetra.magmatic_cell.charge");
        if (charge == 128) {
            chargeLine.func_230529_a_((ITextComponent)new TranslationTextComponent("item.tetra.magmatic_cell.charge_full"));
        } else if ((double)charge > 51.2) {
            chargeLine.func_230529_a_((ITextComponent)new TranslationTextComponent("item.tetra.magmatic_cell.charge_good"));
        } else if (charge > 0) {
            chargeLine.func_230529_a_((ITextComponent)new TranslationTextComponent("item.tetra.magmatic_cell.charge_low"));
        } else {
            chargeLine.func_230529_a_((ITextComponent)new TranslationTextComponent("item.tetra.magmatic_cell.charge_empty"));
        }
        tooltip.add((ITextComponent)chargeLine);
        tooltip.add((ITextComponent)new StringTextComponent(" "));
        tooltip.add(ForgedBlockCommon.locationTooltip);
    }

    public void func_150895_a(ItemGroup itemGroup, NonNullList<ItemStack> itemList) {
        if (this.func_194125_a(itemGroup)) {
            itemList.add((Object)new ItemStack((IItemProvider)this));
            ItemStack emptyStack = new ItemStack((IItemProvider)this);
            emptyStack.func_196085_b(128);
            itemList.add((Object)emptyStack);
        }
    }

    public int getCharge(ItemStack itemStack) {
        return itemStack.func_77958_k() - itemStack.func_77952_i();
    }

    public int drainCharge(ItemStack itemStack, int amount) {
        if (itemStack.func_77952_i() + amount < itemStack.func_77958_k()) {
            this.setDamage(itemStack, itemStack.func_77952_i() + amount);
            return amount;
        }
        int actualAmount = itemStack.func_77958_k() - itemStack.func_77952_i();
        this.setDamage(itemStack, itemStack.func_77958_k());
        return actualAmount;
    }

    public int recharge(ItemStack itemStack, int amount) {
        if (this.getDamage(itemStack) - amount >= 0) {
            this.setDamage(itemStack, this.getDamage(itemStack) - amount);
            return 0;
        }
        int overfill = amount - this.getDamage(itemStack);
        this.setDamage(itemStack, 0);
        return overfill;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    public double getDurabilityForDisplay(ItemStack itemStack) {
        return super.getDurabilityForDisplay(itemStack);
    }

    public int getRGBDurabilityForDisplay(ItemStack itemStack) {
        return super.getRGBDurabilityForDisplay(itemStack);
    }
}

