/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import se.mickelus.tetra.TetraMod;
import se.mickelus.tetra.ToolTypes;
import se.mickelus.tetra.effect.AbilityUseResult;
import se.mickelus.tetra.effect.ChargedAbilityEffect;
import se.mickelus.tetra.effect.CritEffect;
import se.mickelus.tetra.effect.EffectHelper;
import se.mickelus.tetra.effect.ExecuteEffect;
import se.mickelus.tetra.effect.ExtractorEffect;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.effect.ItemEffectHandler;
import se.mickelus.tetra.effect.LungeEffect;
import se.mickelus.tetra.effect.OverpowerEffect;
import se.mickelus.tetra.effect.PiercingEffect;
import se.mickelus.tetra.effect.PryChargedEffect;
import se.mickelus.tetra.effect.PryEffect;
import se.mickelus.tetra.effect.PunctureEffect;
import se.mickelus.tetra.effect.ReapEffect;
import se.mickelus.tetra.effect.SlamEffect;
import se.mickelus.tetra.effect.SweepingEffect;
import se.mickelus.tetra.effect.howling.HowlingEffect;
import se.mickelus.tetra.effect.potion.StunPotionEffect;
import se.mickelus.tetra.items.modular.ChargedAbilityPacket;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.items.modular.ModularItem;
import se.mickelus.tetra.items.modular.SecondaryAbilityPacket;
import se.mickelus.tetra.items.modular.ThrownModularItemEntity;
import se.mickelus.tetra.items.modular.impl.ModularSingleHeadedItem;
import se.mickelus.tetra.items.modular.impl.shield.ModularShieldItem;
import se.mickelus.tetra.module.data.ToolData;
import se.mickelus.tetra.properties.AttributeHelper;
import se.mickelus.tetra.util.CastOptional;

public class ItemModularHandheld
extends ModularItem {
    private static final Set<Material> hoeBonusMaterials = Sets.newHashSet((Object[])new Material[]{Material.field_151585_k, Material.field_151582_l, Material.field_151589_v});
    private static final Set<Material> axeMaterials = Sets.newHashSet((Object[])new Material[]{Material.field_151575_d, Material.field_237214_y_, Material.field_151585_k, Material.field_151582_l, Material.field_215713_z, Material.field_151572_C});
    private static final Set<Material> pickaxeMaterials = Sets.newHashSet((Object[])new Material[]{Material.field_151573_f, Material.field_151574_g, Material.field_151576_e});
    private static final Set<Material> cuttingDestroyMaterials = Sets.newHashSet((Object[])new Material[]{Material.field_151585_k, Material.field_151582_l, Material.field_151589_v, Material.field_151572_C, Material.field_151569_G, Material.field_215713_z});
    private static final Set<ITag.INamedTag<Block>> cuttingDestroyTags = Sets.newHashSet((Object[])new ITag.INamedTag[]{BlockTags.field_206952_E});
    private static final Set<Block> cuttingHarvestBlocks = Sets.newHashSet((Object[])new Block[]{Blocks.field_196553_aF});
    public static final ResourceLocation nailedTag = new ResourceLocation("tetra:nailed");
    protected int blockDestroyDamage = 1;
    protected int entityHitDamage = 1;
    public static final int blockingDurationLimit = 16;
    static final ChargedAbilityEffect[] abilities = new ChargedAbilityEffect[]{ExecuteEffect.instance, LungeEffect.instance, SlamEffect.instance, PunctureEffect.instance, OverpowerEffect.instance, ReapEffect.instance, PryChargedEffect.instance};

    public ItemModularHandheld(Item.Properties properties) {
        super(properties);
    }

    public int getBlockDestroyDamage() {
        return this.blockDestroyDamage;
    }

    public int getEntityHitDamage() {
        return this.entityHitDamage;
    }

    public boolean isDamageable(ItemStack stack) {
        return stack.func_77942_o();
    }

    public boolean func_179218_a(ItemStack itemStack, World world, BlockState state, BlockPos pos, LivingEntity entity) {
        if (state.func_185887_b((IBlockReader)world, pos) > 0.0f) {
            this.applyDamage(this.blockDestroyDamage, itemStack, entity);
            if (!this.isBroken(itemStack)) {
                this.applyUsageEffects(entity, itemStack, 1.0);
            }
        }
        this.applyBreakEffects(itemStack, world, state, pos, entity);
        if (!world.field_72995_K && !this.isBroken(itemStack)) {
            int extractorLevel;
            if (this.getEffectLevel(itemStack, ItemEffect.piercingHarvest) > 0) {
                PiercingEffect.pierceBlocks(this, itemStack, this.getEffectLevel(itemStack, ItemEffect.piercing), (ServerWorld)world, state, pos, entity);
            }
            if ((extractorLevel = this.getEffectLevel(itemStack, ItemEffect.extractor)) > 0) {
                ExtractorEffect.breakBlocks(this, itemStack, extractorLevel, (ServerWorld)world, state, pos, entity);
            }
            CritEffect.onBlockBreak(entity);
        }
        return true;
    }

    public void applyBreakEffects(ItemStack itemStack, World world, BlockState state, BlockPos pos, LivingEntity entity) {
        int xp;
        int intuitLevel;
        if (!world.field_72995_K && (intuitLevel = this.getEffectLevel(itemStack, ItemEffect.intuit)) > 0 && (xp = state.getExpDrop((IWorldReader)world, pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)itemStack), EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)itemStack))) > 0) {
            this.tickHoningProgression(entity, itemStack, xp);
        }
    }

    public boolean func_77644_a(ItemStack itemStack, LivingEntity target, LivingEntity attacker) {
        this.applyDamage(this.entityHitDamage, itemStack, attacker);
        if (!this.isBroken(itemStack)) {
            float attackStrength = CastOptional.cast(attacker, PlayerEntity.class).map(EffectHelper::getCooledAttackStrength).orElse(Float.valueOf(1.0f)).floatValue();
            if ((double)attackStrength > 0.9) {
                int howlingLevel;
                int sweepingLevel = this.getEffectLevel(itemStack, ItemEffect.sweeping);
                if (sweepingLevel > 0 && attacker.func_233570_aj_() && !EffectHelper.getSprinting(attacker)) {
                    SweepingEffect.sweepAttack(itemStack, target, attacker, sweepingLevel);
                }
                if ((howlingLevel = EffectHelper.getEffectLevel(itemStack, ItemEffect.howling)) > 0) {
                    HowlingEffect.trigger(itemStack, attacker, howlingLevel);
                }
                ItemEffectHandler.applyHitEffects(itemStack, target, attacker);
                this.applyPositiveUsageEffects(attacker, itemStack, 1.0);
            }
            this.applyNegativeUsageEffects(attacker, itemStack, 1.0);
        }
        return true;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        boolean canChannel;
        PlayerEntity player = context.func_195999_j();
        Hand hand = context.func_221531_n();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        Direction facing = context.func_196000_l();
        ItemStack itemStack = player.func_184586_b(hand);
        BlockState blockState = world.func_180495_p(pos);
        if (this.isBroken(itemStack)) {
            return ActionResultType.PASS;
        }
        boolean bl = canChannel = this.func_77626_a(itemStack) > 0;
        if (!canChannel || player.func_213453_ef()) {
            ToolData toolData = this.getToolData(itemStack);
            Collection tools = toolData.getValues().stream().filter(tool -> toolData.getLevel(tool) > 0).sorted(player.func_213453_ef() ? Comparator.comparing(ToolType::getName).reversed() : Comparator.comparing(ToolType::getName)).collect(Collectors.toList());
            for (ToolType tool2 : tools) {
                BlockState block = blockState.getToolModifiedState(world, pos, context.func_195999_j(), context.func_195996_i(), tool2);
                if (block == null) continue;
                SoundEvent sound = Optional.ofNullable(this.getUseSound(tool2)).orElseGet(() -> blockState.getSoundType((IWorldReader)world, pos, (Entity)player).func_185846_f());
                world.func_184133_a(player, pos, sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
                if (!world.field_72995_K) {
                    world.func_180501_a(pos, block, 11);
                    this.applyDamage(this.blockDestroyDamage, context.func_195996_i(), (LivingEntity)player);
                    this.applyUsageEffects((LivingEntity)player, itemStack, 2.0);
                }
                return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
            }
            int denailingLevel = this.getEffectLevel(itemStack, ItemEffect.denailing);
            if (denailingLevel > 0 && (double)player.func_184825_o(0.0f) > 0.9 && this.denailBlock(player, world, pos, hand, facing)) {
                this.applyDamage(this.blockDestroyDamage, itemStack, (LivingEntity)player);
                this.applyUsageEffects((LivingEntity)player, itemStack, 2.0);
                player.func_184821_cY();
                return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
            }
        }
        return super.func_195939_a(context);
    }

    private SoundEvent getUseSound(ToolType tool) {
        if (tool == ToolType.AXE) {
            return SoundEvents.field_203255_y;
        }
        if (tool == ToolType.HOE) {
            return SoundEvents.field_187693_cj;
        }
        if (tool == ToolType.SHOVEL) {
            return SoundEvents.field_187771_eN;
        }
        return null;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (this.func_77626_a(itemStack) > 0) {
            player.func_184598_c(hand);
            return new ActionResult(ActionResultType.SUCCESS, (Object)itemStack);
        }
        return new ActionResult(ActionResultType.PASS, (Object)itemStack);
    }

    public ActionResultType func_111207_a(ItemStack itemStack, PlayerEntity player, LivingEntity target, Hand hand) {
        if (!(player.func_184811_cZ().func_185141_a((Item)this) || this.isBroken(itemStack) || this.func_77626_a(itemStack) != 0 && !player.func_213453_ef())) {
            int jabLevel;
            int bashingLevel = this.getEffectLevel(itemStack, ItemEffect.bashing);
            if (bashingLevel > 0) {
                this.bashEntity(itemStack, bashingLevel, player, target);
                this.tickProgression((LivingEntity)player, itemStack, 2);
                this.applyDamage(2, itemStack, (LivingEntity)player);
                return ActionResultType.func_233537_a_((boolean)player.field_70170_p.field_72995_K);
            }
            int pryLevel = this.getEffectLevel(itemStack, ItemEffect.pry);
            if (pryLevel > 0) {
                PryEffect.perform(player, hand, this, itemStack, pryLevel, target);
                return ActionResultType.func_233537_a_((boolean)player.field_70170_p.field_72995_K);
            }
            if (Hand.OFF_HAND.equals((Object)hand) && (jabLevel = this.getEffectLevel(itemStack, ItemEffect.jab)) > 0) {
                this.jabEntity(itemStack, jabLevel, player, target);
                this.tickProgression((LivingEntity)player, itemStack, 2);
                this.applyDamage(2, itemStack, (LivingEntity)player);
                return ActionResultType.func_233537_a_((boolean)player.field_70170_p.field_72995_K);
            }
        }
        return ActionResultType.PASS;
    }

    public boolean itemInteractionForEntitySecondary(ItemStack itemStack, PlayerEntity player, LivingEntity target, Hand hand) {
        int bashingLevel = this.getEffectLevel(itemStack, ItemEffect.bashing);
        if (bashingLevel > 0) {
            this.bashEntity(itemStack, bashingLevel, player, target);
            this.tickProgression((LivingEntity)player, itemStack, 2);
            this.applyDamage(2, itemStack, (LivingEntity)player);
            return true;
        }
        return false;
    }

    public AbilityUseResult hitEntity(ItemStack itemStack, PlayerEntity player, LivingEntity target, double damageMultiplier, float knockbackBase, float knockbackMultiplier) {
        return this.hitEntity(itemStack, player, target, damageMultiplier, 0.0, knockbackBase, knockbackMultiplier);
    }

    public AbilityUseResult hitEntity(ItemStack itemStack, PlayerEntity player, LivingEntity target, double damageMultiplier, double damageBonus, float knockbackBase, float knockbackMultiplier) {
        float targetModifier = EnchantmentHelper.func_152377_a((ItemStack)itemStack, (CreatureAttribute)target.func_70668_bt());
        float critMultiplier = Optional.ofNullable(ForgeHooks.getCriticalHit((PlayerEntity)player, (Entity)target, (boolean)false, (float)1.5f)).map(CriticalHitEvent::getDamageModifier).orElse(Float.valueOf(1.0f)).floatValue();
        double damage = (1.0 + this.getAbilityBaseDamage(itemStack) + (double)targetModifier) * (double)critMultiplier * damageMultiplier + damageBonus;
        boolean success = target.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), (float)damage);
        if (success) {
            EnchantmentHelper.func_151384_a((LivingEntity)target, (Entity)player);
            EffectHelper.applyEnchantmentHitEffects(itemStack, target, (LivingEntity)player);
            ItemEffectHandler.applyHitEffects(itemStack, target, (LivingEntity)player);
            float knockbackFactor = knockbackBase + (float)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180313_o, (ItemStack)itemStack);
            target.func_233627_a_(knockbackFactor * knockbackMultiplier, player.func_226277_ct_() - target.func_226277_ct_(), player.func_226281_cx_() - target.func_226281_cx_());
            if (targetModifier > 1.0f) {
                player.func_71047_c((Entity)target);
                return AbilityUseResult.magicCrit;
            }
            if (critMultiplier > 1.0f) {
                player.func_71009_b((Entity)target);
                return AbilityUseResult.crit;
            }
            return AbilityUseResult.hit;
        }
        return AbilityUseResult.fail;
    }

    public void jabEntity(ItemStack itemStack, int jabLevel, PlayerEntity player, LivingEntity target) {
        AbilityUseResult result = this.hitEntity(itemStack, player, target, (float)jabLevel / 100.0f, 0.5f, 0.2f);
        if (result == AbilityUseResult.crit) {
            player.func_130014_f_().func_184133_a(player, target.func_233580_cy_(), SoundEvents.field_187718_dS, SoundCategory.PLAYERS, 1.0f, 1.3f);
        } else {
            player.func_130014_f_().func_184133_a(player, target.func_233580_cy_(), SoundEvents.field_187733_dX, SoundCategory.PLAYERS, 1.0f, 1.3f);
        }
        player.func_184811_cZ().func_185145_a((Item)this, (int)Math.round(this.getCooldownBase(itemStack) * 20.0));
    }

    public void bashEntity(ItemStack itemStack, int bashingLevel, PlayerEntity player, LivingEntity target) {
        AbilityUseResult result = this.hitEntity(itemStack, player, target, 1.0, bashingLevel + (player.func_70051_ag() ? 1 : 0), 0.5f);
        if (result != AbilityUseResult.fail) {
            double stunDuration = this.getEffectEfficiency(itemStack, ItemEffect.bashing);
            if (stunDuration > 0.0) {
                target.func_195064_c(new EffectInstance((Effect)StunPotionEffect.instance, (int)Math.round(stunDuration * 20.0), 0, false, false));
            }
            player.func_130014_f_().func_184133_a(player, target.func_233580_cy_(), SoundEvents.field_187721_dT, SoundCategory.PLAYERS, 1.0f, 0.7f);
        } else {
            player.func_130014_f_().func_184133_a(player, target.func_233580_cy_(), SoundEvents.field_187733_dX, SoundCategory.PLAYERS, 1.0f, 0.7f);
        }
        player.func_184811_cZ().func_185145_a((Item)this, (int)Math.round(this.getCooldownBase(itemStack) * 20.0));
    }

    public void throwItem(PlayerEntity player, ItemStack stack, int riptideLevel, float cooldownBase) {
        World world = player.field_70170_p;
        if (!world.field_72995_K) {
            this.applyDamage(1, stack, (LivingEntity)player);
            this.applyUsageEffects((LivingEntity)player, stack, 1.0);
            ThrownModularItemEntity projectileEntity = new ThrownModularItemEntity(world, (LivingEntity)player, stack);
            if (player.field_71075_bZ.field_75098_d) {
                projectileEntity.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
            } else {
                player.field_71071_by.func_184437_d(stack);
            }
            projectileEntity.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 2.5f + (float)riptideLevel * 0.5f, 1.0f);
            world.func_217376_c((Entity)projectileEntity);
            if (this instanceof ModularSingleHeadedItem) {
                world.func_217384_a(null, (Entity)projectileEntity, SoundEvents.field_203274_ip, SoundCategory.PLAYERS, 1.0f, 1.0f);
            } else if (this instanceof ModularShieldItem) {
                world.func_217384_a(null, (Entity)projectileEntity, SoundEvents.field_187578_au, SoundCategory.PLAYERS, 1.0f, 2.0f);
            } else {
                world.func_217384_a(null, (Entity)projectileEntity, SoundEvents.field_187612_G, SoundCategory.PLAYERS, 1.0f, 0.7f);
            }
        }
        player.func_184811_cZ().func_185145_a((Item)this, Math.round(cooldownBase * 20.0f));
    }

    public void causeRiptideEffect(PlayerEntity player, int riptideLevel) {
        float yaw = player.field_70177_z;
        float pitch = player.field_70125_A;
        float x = -MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        float y = -MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180)));
        float z = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        float velocityMultiplier = 3.0f * ((1.0f + (float)riptideLevel) / 4.0f);
        player.func_70024_g((double)(x *= velocityMultiplier), (double)(y *= velocityMultiplier), (double)(z *= velocityMultiplier));
        player.func_204803_n(20);
        if (player.func_233570_aj_()) {
            player.func_213315_a(MoverType.SELF, new Vector3d(0.0, 1.1999999, 0.0));
        }
        SoundEvent soundEvent = riptideLevel >= 3 ? SoundEvents.field_203273_io : (riptideLevel == 2 ? SoundEvents.field_203272_in : SoundEvents.field_203271_im);
        player.field_70170_p.func_217384_a(null, (Entity)player, soundEvent, SoundCategory.PLAYERS, 1.0f, 1.0f);
        player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
    }

    public boolean denailBlock(PlayerEntity player, World world, BlockPos pos, Hand hand, Direction facing) {
        boolean success;
        ItemStack itemStack = player.func_184586_b(hand);
        if (!player.func_175151_a(pos.func_177972_a(facing), facing, itemStack)) {
            return false;
        }
        BlockState blockState = world.func_180495_p(pos);
        if (ItemModularHandheld.canDenail(blockState) && (success = EffectHelper.breakBlock(world, player, player.func_184586_b(hand), pos, blockState, true))) {
            player.func_184821_cY();
            return true;
        }
        return false;
    }

    public static boolean canDenail(BlockState blockState) {
        return blockState.func_177230_c().getTags().contains(nailedTag);
    }

    public UseAction func_77661_b(ItemStack stack) {
        if (this.getEffectLevel(stack, ItemEffect.blocking) > 0) {
            return UseAction.BLOCK;
        }
        if (this.getEffectLevel(stack, ItemEffect.throwable) > 0 || EnchantmentHelper.func_203190_g((ItemStack)stack) > 0) {
            return UseAction.SPEAR;
        }
        ChargedAbilityEffect ability = this.getChargeableAbility(stack);
        if (ability != null) {
            return ability.getPose();
        }
        return super.func_77661_b(stack);
    }

    public float getBlockProgress(ItemStack itemStack, @Nullable LivingEntity entity) {
        int blockingLevel = this.getEffectLevel(itemStack, ItemEffect.blocking);
        if (blockingLevel > 0 && blockingLevel < 16) {
            return Optional.ofNullable(entity).filter(e -> e.func_184605_cv() > 0).filter(e -> itemStack.equals(e.func_184607_cu())).map(e -> Float.valueOf((float)e.func_184605_cv() * 1.0f / (float)this.func_77626_a(itemStack))).orElse(Float.valueOf(0.0f)).floatValue();
        }
        return 0.0f;
    }

    public boolean isThrowing(ItemStack itemStack, @Nullable LivingEntity entity) {
        return UseAction.SPEAR.equals((Object)this.func_77661_b(itemStack)) && Optional.ofNullable(entity).filter(e -> itemStack.equals(e.func_184607_cu())).map(e -> e.func_184605_cv() > 0).orElse(false) != false;
    }

    public boolean isBlocking(ItemStack itemStack, @Nullable LivingEntity entity) {
        return UseAction.BLOCK.equals((Object)this.func_77661_b(itemStack)) && Optional.ofNullable(entity).filter(e -> itemStack.equals(e.func_184607_cu())).map(e -> e.func_184605_cv() > 0).orElse(false) != false;
    }

    public boolean isShield(ItemStack itemStack, @Nullable LivingEntity entity) {
        return this.getEffectLevel(itemStack, ItemEffect.blocking) > 0;
    }

    public int func_77626_a(ItemStack itemStack) {
        int blockingLevel = this.getEffectLevel(itemStack, ItemEffect.blocking);
        if (blockingLevel > 0) {
            int duration = blockingLevel * 20;
            return blockingLevel < 16 ? duration : 72000;
        }
        if (this.getEffectLevel(itemStack, ItemEffect.throwable) > 0 || EnchantmentHelper.func_203190_g((ItemStack)itemStack) > 0 || Arrays.stream(abilities).anyMatch(ability -> ability.isAvailable(this, itemStack))) {
            return 72000;
        }
        return 0;
    }

    public ItemStack func_77654_b(ItemStack itemStack, World world, LivingEntity entity) {
        CastOptional.cast(entity, PlayerEntity.class).ifPresent(player -> {
            int blockingLevel = this.getEffectLevel(itemStack, ItemEffect.blocking);
            if (blockingLevel > 0) {
                double blockingCooldown = this.getEffectEfficiency(itemStack, ItemEffect.blocking);
                if (blockingCooldown > 0.0) {
                    player.func_184811_cZ().func_185145_a((Item)this, (int)Math.round(blockingCooldown * this.getCooldownBase(itemStack) * 20.0));
                }
                if (player.func_213453_ef() && world.field_72995_K) {
                    this.onPlayerStoppedUsingSecondary(itemStack, world, entity, 0);
                }
            }
        });
        return super.func_77654_b(itemStack, world, entity);
    }

    public void func_77615_a(ItemStack itemStack, World world, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entityLiving;
            int ticksUsed = this.func_77626_a(itemStack) - timeLeft;
            double cooldownBase = this.getCooldownBase(itemStack);
            int blockingLevel = this.getEffectLevel(itemStack, ItemEffect.blocking);
            int throwingLevel = this.getEffectLevel(itemStack, ItemEffect.throwable);
            int riptideLevel = EnchantmentHelper.func_203190_g((ItemStack)itemStack);
            if (blockingLevel > 0) {
                double blockingCooldown = this.getEffectEfficiency(itemStack, ItemEffect.blocking);
                if (blockingCooldown > 0.0) {
                    player.func_184811_cZ().func_185145_a((Item)this, (int)Math.round(blockingCooldown * cooldownBase * 20.0));
                }
                if (player.func_213453_ef()) {
                    if (ticksUsed >= 10 && riptideLevel > 0 && player.func_70026_G()) {
                        this.causeRiptideEffect(player, riptideLevel);
                    } else if (ticksUsed >= 10 && throwingLevel > 0) {
                        this.throwItem(player, itemStack, riptideLevel, (float)cooldownBase);
                    } else if (world.field_72995_K) {
                        this.onPlayerStoppedUsingSecondary(itemStack, world, entityLiving, timeLeft);
                    }
                }
            } else {
                if (riptideLevel > 0 && ticksUsed >= 10 && player.func_70026_G()) {
                    this.causeRiptideEffect(player, riptideLevel);
                } else if (throwingLevel > 0 && ticksUsed >= 10) {
                    this.throwItem(player, itemStack, riptideLevel, (float)cooldownBase);
                }
                if (world.field_72995_K) {
                    this.triggerChargedAbility(itemStack, world, entityLiving, ticksUsed);
                }
            }
        }
    }

    public ChargedAbilityEffect getChargeableAbility(ItemStack itemStack) {
        return Arrays.stream(abilities).filter(ability -> ability.canCharge(this, itemStack)).findFirst().orElse(null);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void triggerChargedAbility(ItemStack itemStack, World world, LivingEntity entity, int ticksUsed) {
        if (entity instanceof PlayerEntity) {
            RayTraceResult rayTrace = Minecraft.func_71410_x().field_71476_x;
            LivingEntity target = Optional.ofNullable(rayTrace).filter(rayTraceResult -> rayTraceResult.func_216346_c() == RayTraceResult.Type.ENTITY).map(rayTraceResult -> ((EntityRayTraceResult)rayTraceResult).func_216348_a()).flatMap(hitEntity -> CastOptional.cast(hitEntity, LivingEntity.class)).orElse(null);
            BlockPos targetPos = Optional.ofNullable(rayTrace).filter(rayTraceResult -> rayTraceResult.func_216346_c() == RayTraceResult.Type.BLOCK).map(rayTraceResult -> ((BlockRayTraceResult)rayTraceResult).func_216350_a()).orElse(null);
            Vector3d hitVec = Optional.ofNullable(rayTrace).map(RayTraceResult::func_216347_e).orElse(null);
            Hand activeHand = entity.func_184600_cs();
            TetraMod.packetHandler.sendToServer(new ChargedAbilityPacket(target, targetPos, hitVec, activeHand, ticksUsed));
            ItemModularHandheld.handleChargedAbility((PlayerEntity)entity, activeHand, target, targetPos, hitVec, ticksUsed);
        }
    }

    public static void handleChargedAbility(PlayerEntity player, Hand hand, @Nullable LivingEntity target, @Nullable BlockPos targetPos, @Nullable Vector3d hitVec, int ticksUsed) {
        ItemStack activeStack = player.func_184586_b(hand);
        if (!activeStack.func_190926_b() && activeStack.func_77973_b() instanceof ItemModularHandheld) {
            ItemModularHandheld item = (ItemModularHandheld)activeStack.func_77973_b();
            Arrays.stream(abilities).filter(ability -> ability.canPerform(player, item, activeStack, target, targetPos, ticksUsed)).findFirst().ifPresent(ability -> ability.perform(player, hand, item, activeStack, target, targetPos, hitVec, ticksUsed));
            player.func_184602_cy();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onPlayerStoppedUsingSecondary(ItemStack itemStack, World world, LivingEntity entity, int timeLeft) {
        if (entity instanceof PlayerEntity) {
            LivingEntity target = Optional.ofNullable(Minecraft.func_71410_x().field_71476_x).filter(rayTraceResult -> rayTraceResult.func_216346_c() == RayTraceResult.Type.ENTITY).map(rayTraceResult -> ((EntityRayTraceResult)rayTraceResult).func_216348_a()).flatMap(hitEntity -> CastOptional.cast(hitEntity, LivingEntity.class)).orElse(null);
            Hand activeHand = entity.func_184600_cs();
            TetraMod.packetHandler.sendToServer(new SecondaryAbilityPacket(target, activeHand));
            ItemModularHandheld.handleSecondaryAbility((PlayerEntity)entity, activeHand, target);
        }
    }

    public static void handleSecondaryAbility(PlayerEntity player, Hand hand, LivingEntity target) {
        ItemStack activeStack = player.func_184586_b(hand);
        if (!activeStack.func_190926_b() && activeStack.func_77973_b() instanceof ItemModularHandheld) {
            ItemModularHandheld item = (ItemModularHandheld)activeStack.func_77973_b();
            if (target != null) {
                item.itemInteractionForEntitySecondary(activeStack, player, target, hand);
                player.func_184602_cy();
                player.func_184811_cZ().func_185145_a((Item)item, (int)Math.round(item.getCooldownBase(activeStack) * 20.0 * 1.5));
                player.func_184609_a(hand);
            }
        }
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        EffectHelper.setCooledAttackStrength(player, player.func_184825_o(0.5f));
        EffectHelper.setSprinting((LivingEntity)player, player.func_70051_ag());
        return false;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack itemStack) {
        if (this.isBroken(itemStack)) {
            return AttributeHelper.emptyMap;
        }
        if (slot == EquipmentSlotType.MAINHAND) {
            return this.getAttributeModifiersCached(itemStack);
        }
        if (slot == EquipmentSlotType.OFFHAND) {
            return (Multimap)this.getAttributeModifiersCached(itemStack).entries().stream().filter(entry -> ((Attribute)entry.getKey()).equals(Attributes.field_233826_i_) || ((Attribute)entry.getKey()).equals(Attributes.field_233827_j_)).collect(Multimaps.toMultimap(Map.Entry::getKey, Map.Entry::getValue, ArrayListMultimap::create));
        }
        return AttributeHelper.emptyMap;
    }

    public double getAbilityBaseDamage(ItemStack itemStack) {
        return this.getAttributeValue(itemStack, Attributes.field_233823_f_) + 1.0;
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getEffectAttributes(ItemStack itemStack) {
        ArrayListMultimap result = ArrayListMultimap.create();
        Optional.of(this.getCounterWeightBonus(itemStack)).filter(bonus -> bonus > 0.0).map(bonus -> new AttributeModifier("counterweight", bonus.doubleValue(), AttributeModifier.Operation.ADDITION)).ifPresent(arg_0 -> ItemModularHandheld.lambda$getEffectAttributes$25((Multimap)result, arg_0));
        return result;
    }

    public double getCounterWeightBonus(ItemStack itemStack) {
        int counterWeightLevel = this.getEffectLevel(itemStack, ItemEffect.counterweight);
        if (counterWeightLevel > 0) {
            int integrityCost = IModularItem.getIntegrityCost(itemStack);
            return ItemModularHandheld.getCounterWeightBonus(counterWeightLevel, integrityCost);
        }
        return 0.0;
    }

    public static double getCounterWeightBonus(int counterWeightLevel, int integrityCost) {
        return Math.max(0.0, 0.15 - (double)Math.abs(counterWeightLevel - integrityCost) * 0.05);
    }

    public double getCooldownBase(ItemStack itemStack) {
        return 1.0 / Math.max(0.1, this.getAttributeValue(itemStack, Attributes.field_233825_h_, 4.0) + this.getCounterWeightBonus(itemStack));
    }

    public Set<ToolType> getToolTypes(ItemStack stack) {
        if (!this.isBroken(stack)) {
            return this.getTools(stack);
        }
        return Collections.emptySet();
    }

    public int getHarvestLevel(ItemStack stack, ToolType tool, @Nullable PlayerEntity player, @Nullable BlockState blockState) {
        int toolTier;
        if (!this.isBroken(stack) && (toolTier = this.getToolLevel(stack, tool)) > 0) {
            return toolTier - 1;
        }
        return -1;
    }

    public boolean canHarvestBlock(ItemStack stack, BlockState state) {
        if (!state.func_235783_q_()) {
            return true;
        }
        ToolType requiredTool = state.getHarvestTool();
        if (requiredTool == null) {
            requiredTool = ItemModularHandheld.getEffectiveTool(state);
        }
        return requiredTool != null && this.getHarvestLevel(stack, requiredTool, null, state) >= Math.max(state.getHarvestLevel(), 0);
    }

    public float func_150893_a(ItemStack itemStack, BlockState blockState) {
        if (!this.isBroken(itemStack)) {
            ToolType tool = ItemModularHandheld.getEffectiveTool(blockState);
            float speed = (float)(this.getAttributeValue(itemStack, Attributes.field_233825_h_, 4.0) * 0.5 + 0.5);
            speed = tool != null ? (speed *= this.getToolEfficiency(itemStack, tool)) : (speed *= this.getToolTypes(itemStack).stream().filter(arg_0 -> ((BlockState)blockState).isToolEffective(arg_0)).map(toolType -> Float.valueOf(this.getToolEfficiency(itemStack, (ToolType)toolType))).max(Comparator.naturalOrder()).orElse(Float.valueOf(0.0f)).floatValue());
            if (this.getToolLevel(itemStack, ToolTypes.cut) > 0) {
                if (blockState.func_177230_c().equals(Blocks.field_196553_aF)) {
                    speed *= 10.0f;
                }
                if (blockState.func_177230_c().equals(Blocks.field_222405_kQ)) {
                    speed = 30.0f;
                }
            }
            if (speed < 1.0f) {
                return 1.0f;
            }
            return speed;
        }
        return 1.0f;
    }

    public static boolean isToolEffective(ToolType toolType, BlockState blockState) {
        if (ToolTypes.cut.equals(toolType) && (cuttingHarvestBlocks.contains(blockState.func_177230_c()) || cuttingDestroyMaterials.contains(blockState.func_185904_a()) || cuttingDestroyTags.stream().anyMatch(tag -> blockState.func_177230_c().func_203417_a((ITag)tag)))) {
            return true;
        }
        if (ToolType.HOE.equals(toolType) && hoeBonusMaterials.contains(blockState.func_185904_a())) {
            return true;
        }
        if (ToolType.AXE.equals(toolType) && axeMaterials.contains(blockState.func_185904_a())) {
            return true;
        }
        if (ToolType.PICKAXE.equals(toolType) && pickaxeMaterials.contains(blockState.func_185904_a())) {
            return true;
        }
        return toolType.equals(blockState.getHarvestTool());
    }

    public static ToolType getEffectiveTool(BlockState blockState) {
        ToolType tool = blockState.getHarvestTool();
        if (tool != null) {
            return tool;
        }
        if (cuttingHarvestBlocks.contains(blockState.func_177230_c()) || cuttingDestroyMaterials.contains(blockState.func_185904_a()) || cuttingDestroyTags.stream().anyMatch(tag -> blockState.func_177230_c().func_203417_a((ITag)tag))) {
            return ToolTypes.cut;
        }
        if (axeMaterials.contains(blockState.func_185904_a())) {
            return ToolType.AXE;
        }
        if (pickaxeMaterials.contains(blockState.func_185904_a())) {
            return ToolType.PICKAXE;
        }
        return null;
    }

    @Override
    public ItemStack onCraftConsume(ItemStack providerStack, ItemStack targetStack, PlayerEntity player, ToolType tool, int toolLevel, boolean consumeResources) {
        if (consumeResources) {
            this.applyDamage(toolLevel, providerStack, (LivingEntity)player);
            this.applyUsageEffects((LivingEntity)player, providerStack, 10 + toolLevel * 5);
        }
        return super.onCraftConsume(providerStack, targetStack, player, tool, toolLevel, consumeResources);
    }

    @Override
    public ItemStack onActionConsume(ItemStack providerStack, ItemStack targetStack, PlayerEntity player, ToolType tool, int toolLevel, boolean consumeResources) {
        if (consumeResources) {
            this.applyDamage(toolLevel, providerStack, (LivingEntity)player);
            this.applyUsageEffects((LivingEntity)player, providerStack, 4 + toolLevel * 3);
        }
        return super.onCraftConsume(providerStack, targetStack, player, tool, toolLevel, consumeResources);
    }

    private static /* synthetic */ void lambda$getEffectAttributes$25(Multimap result, AttributeModifier modifier) {
        result.put((Object)Attributes.field_233825_h_, (Object)modifier);
    }
}

