/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl;

import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.items.modular.ItemModularHandheld;
import se.mickelus.tetra.module.SchematicRegistry;
import se.mickelus.tetra.module.schematic.RemoveSchematic;
import se.mickelus.tetra.module.schematic.RepairSchematic;
import se.mickelus.tetra.network.PacketHandler;

public class ModularBladedItem
extends ItemModularHandheld {
    public static final String bladeKey = "sword/blade";
    public static final String hiltKey = "sword/hilt";
    public static final String guardKey = "sword/guard";
    public static final String pommelKey = "sword/pommel";
    public static final String fullerKey = "sword/fuller";
    public static final String unlocalizedName = "modular_sword";
    @ObjectHolder(value="tetra:modular_sword")
    public static ModularBladedItem instance;

    public ModularBladedItem() {
        super(new Item.Properties().func_200917_a(1).func_234689_a_());
        this.setRegistryName(unlocalizedName);
        this.blockDestroyDamage = 2;
        this.majorModuleKeys = new String[]{bladeKey, hiltKey};
        this.minorModuleKeys = new String[]{fullerKey, guardKey, pommelKey};
        this.requiredModules = new String[]{bladeKey, hiltKey};
        this.updateConfig((Integer)ConfigHandler.honeSwordBase.get(), (Integer)ConfigHandler.honeSwordIntegrityMultiplier.get());
        SchematicRegistry.instance.registerSchematic(new RepairSchematic(this));
        RemoveSchematic.registerRemoveSchematics(this);
    }

    @Override
    public void init(PacketHandler packetHandler) {
        DataManager.synergyData.onReload(() -> {
            this.synergies = DataManager.instance.getSynergyData("sword/");
        });
    }

    public void updateConfig(int honeBase, int honeIntegrityMultiplier) {
        this.honeBase = honeBase;
        this.honeIntegrityMultiplier = honeIntegrityMultiplier;
    }

    @Override
    public String getModelCacheKey(ItemStack itemStack, LivingEntity entity) {
        if (this.isThrowing(itemStack, entity)) {
            return super.getModelCacheKey(itemStack, entity) + ":throwing";
        }
        if (this.isBlocking(itemStack, entity)) {
            return super.getModelCacheKey(itemStack, entity) + ":blocking";
        }
        return super.getModelCacheKey(itemStack, entity);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getTransformVariant(ItemStack itemStack, @Nullable LivingEntity entity) {
        if (this.isThrowing(itemStack, entity)) {
            return "throwing";
        }
        if (this.isBlocking(itemStack, entity)) {
            return "blocking";
        }
        return null;
    }
}

