/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.crossbow;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.FireworkRocketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.blocks.forged.chthonic.ChthonicExtractorBlock;
import se.mickelus.tetra.blocks.forged.chthonic.ExtractorProjectileEntity;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.gui.GuiModuleOffsets;
import se.mickelus.tetra.items.modular.ModularItem;
import se.mickelus.tetra.items.modular.impl.crossbow.CrossbowOverlay;
import se.mickelus.tetra.items.modular.impl.crossbow.ShootableDummyItem;
import se.mickelus.tetra.module.ItemModule;
import se.mickelus.tetra.module.SchematicRegistry;
import se.mickelus.tetra.module.data.ModuleModel;
import se.mickelus.tetra.module.schematic.RemoveSchematic;
import se.mickelus.tetra.module.schematic.RepairSchematic;
import se.mickelus.tetra.network.PacketHandler;
import se.mickelus.tetra.properties.AttributeHelper;
import se.mickelus.tetra.properties.TetraAttributes;
import se.mickelus.tetra.util.CastOptional;

public class ModularCrossbowItem
extends ModularItem {
    public static final String staveKey = "crossbow/stave";
    public static final String stockKey = "crossbow/stock";
    public static final String stringKey = "crossbow/string";
    public static final String attachmentAKey = "crossbow/attachment_0";
    public static final String attachmentBKey = "crossbow/attachment_1";
    public static final String unlocalizedName = "modular_crossbow";
    protected ModuleModel arrowModel = new ModuleModel("item", new ResourceLocation("tetra", "items/module/crossbow/arrow"));
    protected ModuleModel extractorModel = new ModuleModel("item", new ResourceLocation("tetra", "items/module/crossbow/extractor"));
    protected ModuleModel fireworkModel = new ModuleModel("item", new ResourceLocation("tetra", "items/module/crossbow/firework"));
    private static final GuiModuleOffsets majorOffsets = new GuiModuleOffsets(-13, 0, -13, 18);
    private static final GuiModuleOffsets minorOffsets = new GuiModuleOffsets(4, -1, 13, 12, 4, 25);
    public static final double velocityFactor = 0.125;
    protected ItemStack shootableDummy;
    private boolean isLoadingStart = false;
    private boolean isLoadingMiddle = false;
    @ObjectHolder(value="tetra:modular_crossbow")
    public static ModularCrossbowItem instance;

    public ModularCrossbowItem() {
        super(new Item.Properties().func_200917_a(1).func_234689_a_());
        this.setRegistryName(unlocalizedName);
        this.majorModuleKeys = new String[]{staveKey, stockKey};
        this.minorModuleKeys = new String[]{attachmentAKey, stringKey, attachmentBKey};
        this.requiredModules = new String[]{stringKey, stockKey, staveKey};
        this.shootableDummy = new ItemStack((IItemProvider)new ShootableDummyItem());
        this.updateConfig((Integer)ConfigHandler.honeCrossbowBase.get(), (Integer)ConfigHandler.honeCrossbowIntegrityMultiplier.get());
        SchematicRegistry.instance.registerSchematic(new RepairSchematic(this));
        RemoveSchematic.registerRemoveSchematics(this);
    }

    @Override
    public void init(PacketHandler packetHandler) {
        DataManager.synergyData.onReload(() -> {
            this.synergies = DataManager.instance.getSynergyData("crossbow/");
        });
    }

    public void updateConfig(int honeBase, int honeIntegrityMultiplier) {
        this.honeBase = honeBase;
        this.honeIntegrityMultiplier = honeIntegrityMultiplier;
    }

    @Override
    public void clientInit() {
        super.clientInit();
        MinecraftForge.EVENT_BUS.register((Object)new CrossbowOverlay(Minecraft.func_71410_x()));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        List<ItemStack> list = this.getProjectiles(stack);
        if (this.isLoaded(stack) && !list.isEmpty()) {
            ItemStack itemstack = list.get(0);
            tooltip.add((ITextComponent)new TranslationTextComponent("item.minecraft.crossbow.projectile").func_240702_b_(" ").func_230529_a_(itemstack.func_151000_E()));
            if (flagIn.func_194127_a() && itemstack.func_77973_b() == Items.field_196152_dE) {
                ArrayList list1 = Lists.newArrayList();
                Items.field_196152_dE.func_77624_a(itemstack, worldIn, (List)list1, flagIn);
                if (!list1.isEmpty()) {
                    for (int i = 0; i < list1.size(); ++i) {
                        list1.set(i, new StringTextComponent("  ").func_230529_a_((ITextComponent)list1.get(i)).func_240699_a_(TextFormatting.GRAY));
                    }
                    tooltip.addAll(list1);
                }
            }
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (Screen.func_231173_s_()) {
            tooltip.add((ITextComponent)new StringTextComponent(" "));
            tooltip.add((ITextComponent)new TranslationTextComponent("item.tetra.crossbow.wip").func_240699_a_(TextFormatting.GRAY));
            tooltip.add((ITextComponent)new StringTextComponent(" "));
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack itemStack) {
        if (this.isBroken(itemStack)) {
            return AttributeHelper.emptyMap;
        }
        if (slot == EquipmentSlotType.MAINHAND) {
            return this.getAttributeModifiersCached(itemStack);
        }
        if (slot == EquipmentSlotType.OFFHAND) {
            return (Multimap)this.getAttributeModifiersCached(itemStack).entries().stream().filter(entry -> !((Attribute)entry.getKey()).equals(Attributes.field_233823_f_) && !((Attribute)entry.getKey()).equals(Attributes.field_233823_f_)).collect(Multimaps.toMultimap(Map.Entry::getKey, Map.Entry::getValue, ArrayListMultimap::create));
        }
        return AttributeHelper.emptyMap;
    }

    public void func_219972_a(World world, LivingEntity entity, ItemStack itemStack, int count) {
        if (!world.field_72995_K) {
            int drawDuration = this.getReloadDuration(itemStack);
            float f = this.getProgress(itemStack, entity);
            if (f < 0.2f) {
                this.isLoadingStart = false;
                this.isLoadingMiddle = false;
            }
            if (f >= 0.2f && !this.isLoadingStart) {
                this.isLoadingStart = true;
                world.func_184148_a(null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), this.getSoundEvent(drawDuration), SoundCategory.PLAYERS, 0.5f, 1.0f);
            }
            if (f >= 0.5f && drawDuration <= 28 && !this.isLoadingMiddle) {
                this.isLoadingMiddle = true;
                if (drawDuration > 21) {
                    world.func_184148_a(null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), SoundEvents.field_219611_bC, SoundCategory.PLAYERS, 0.5f, 1.0f);
                }
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (this.isLoaded(itemstack)) {
            this.fireProjectiles(itemstack, world, (LivingEntity)player);
            this.setLoaded(itemstack, false);
            return ActionResult.func_226249_b_((Object)itemstack);
        }
        if (!this.findAmmo((LivingEntity)player).func_190926_b()) {
            if (!this.isLoaded(itemstack)) {
                this.isLoadingStart = false;
                this.isLoadingMiddle = false;
                player.func_184598_c(hand);
            }
            return ActionResult.func_226249_b_((Object)itemstack);
        }
        return ActionResult.func_226251_d_((Object)itemstack);
    }

    public void func_77615_a(ItemStack itemStack, World world, LivingEntity entity, int timeLeft) {
        boolean gotLoaded;
        float progress = this.getProgress(itemStack, entity);
        if (progress >= 1.0f && !this.isLoaded(itemStack) && (gotLoaded = this.reload(entity, itemStack))) {
            this.setLoaded(itemStack, true);
            SoundCategory soundcategory = entity instanceof PlayerEntity ? SoundCategory.PLAYERS : SoundCategory.HOSTILE;
            world.func_184148_a(null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), SoundEvents.field_219610_bB, soundcategory, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.5f + 1.0f) + 0.2f);
        }
    }

    protected void fireProjectiles(ItemStack itemStack, World world, LivingEntity entity) {
        if (entity instanceof PlayerEntity && !world.field_72995_K) {
            ItemStack advancementCopy = itemStack.func_77946_l();
            PlayerEntity player = (PlayerEntity)entity;
            int count = Math.max(this.getEffectLevel(itemStack, ItemEffect.multishot), 1);
            List<ItemStack> list = this.takeProjectiles(itemStack, count);
            if (!list.isEmpty()) {
                double spread = this.getEffectEfficiency(itemStack, ItemEffect.multishot);
                for (int i = 0; i < list.size(); ++i) {
                    ItemStack ammoStack = list.get(i);
                    double yaw = (double)player.field_70177_z - spread * (double)(count - 1) / 2.0 + spread * (double)i;
                    this.fireProjectile(world, itemStack, ammoStack, player, yaw);
                }
                itemStack.func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(p.func_184600_cs()));
                this.applyUsageEffects(entity, itemStack, 1.0);
                world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_219616_bH, SoundCategory.PLAYERS, 1.0f, 1.0f);
                if (player instanceof ServerPlayerEntity) {
                    CriteriaTriggers.field_215099_F.func_215111_a((ServerPlayerEntity)player, advancementCopy);
                    player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                }
            }
        }
    }

    protected void fireProjectile(World world, ItemStack crossbowStack, ItemStack ammoStack, PlayerEntity player, double yaw) {
        double strength = this.getAttributeValue(crossbowStack, (Attribute)TetraAttributes.drawStrength.get());
        float velocityBonus = (float)this.getEffectLevel(crossbowStack, ItemEffect.velocity) / 100.0f;
        float projectileVelocity = ModularCrossbowItem.getProjectileVelocity(strength, velocityBonus);
        if (ChthonicExtractorBlock.item.equals(ammoStack.func_77973_b()) || ChthonicExtractorBlock.usedItem.equals(ammoStack.func_77973_b())) {
            ExtractorProjectileEntity projectileEntity = new ExtractorProjectileEntity(world, (LivingEntity)player, ammoStack);
            if (player.field_71075_bZ.field_75098_d) {
                projectileEntity.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
            }
            projectileEntity.func_234612_a_((Entity)player, player.field_70125_A, (float)yaw, 0.0f, projectileVelocity, 1.0f);
            world.func_217376_c((Entity)projectileEntity);
        } else if (ammoStack.func_77973_b() instanceof FireworkRocketItem) {
            FireworkRocketEntity projectile = new FireworkRocketEntity(world, ammoStack, (Entity)player, player.func_226277_ct_(), player.func_226280_cw_() - 0.15, player.func_226281_cx_(), true);
            projectile.func_234612_a_((Entity)player, player.field_70125_A, (float)yaw, 0.0f, projectileVelocity * 1.6f, 1.0f);
            world.func_217376_c((Entity)projectile);
        } else {
            int piercingLevel;
            ArrowItem ammoItem = CastOptional.cast(ammoStack.func_77973_b(), ArrowItem.class).orElse((ArrowItem)Items.field_151032_g);
            AbstractArrowEntity projectile = ammoItem.func_200887_a(world, ammoStack, (LivingEntity)player);
            projectile.func_213869_a(SoundEvents.field_219609_bA);
            projectile.func_213865_o(true);
            projectile.func_70243_d(true);
            projectile.func_70239_b(projectile.func_70242_d() - 2.0 + strength / 3.0);
            if (projectileVelocity > 1.0f) {
                projectile.func_70239_b(projectile.func_70242_d() / (double)projectileVelocity);
            }
            if ((piercingLevel = this.getEffectLevel(crossbowStack, ItemEffect.piercing)) > 0) {
                projectile.func_213872_b((byte)piercingLevel);
            }
            if (player.field_71075_bZ.field_75098_d) {
                projectile.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
            }
            projectile.func_234612_a_((Entity)player, player.field_70125_A, (float)yaw, 0.0f, projectileVelocity * 3.15f, 1.0f);
            world.func_217376_c((Entity)projectile);
        }
    }

    public static float getProjectileVelocity(double strength, float velocityBonus) {
        float velocity = (float)Math.max(1.0, 1.0 + (strength - 6.0) * 0.125);
        velocity += velocity * velocityBonus;
        return velocity;
    }

    public int getReloadDuration(ItemStack itemStack) {
        return Math.max((int)(20.0 * this.getAttributeValue(itemStack, (Attribute)TetraAttributes.drawSpeed.get())), 1);
    }

    public float getProgress(ItemStack itemStack, @Nullable LivingEntity entity) {
        return Optional.ofNullable(entity).filter(e -> e.func_184605_cv() > 0).filter(e -> itemStack.equals(e.func_184607_cu())).map(e -> Float.valueOf((float)(this.func_77626_a(itemStack) - e.func_184605_cv()) * 1.0f / (float)this.getReloadDuration(itemStack))).orElse(Float.valueOf(0.0f)).floatValue();
    }

    private ItemStack findAmmo(LivingEntity entity) {
        return entity.func_213356_f(this.shootableDummy);
    }

    private boolean reload(LivingEntity entity, ItemStack crossbowStack) {
        int count = Math.max(this.getEffectLevel(crossbowStack, ItemEffect.multishot), 1);
        boolean infinite = CastOptional.cast(entity, PlayerEntity.class).map(player -> player.field_71075_bZ.field_75098_d).orElse(false);
        ItemStack ammoStack = this.findAmmo(entity);
        ItemStack itemstack1 = ammoStack.func_77946_l();
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                ammoStack = itemstack1.func_77946_l();
            }
            if (ammoStack.func_190926_b() && infinite) {
                ammoStack = new ItemStack((IItemProvider)Items.field_151032_g);
                itemstack1 = ammoStack.func_77946_l();
            }
            if (this.loadProjectiles(entity, crossbowStack, ammoStack, i > 0, infinite)) continue;
            return false;
        }
        return true;
    }

    private boolean loadProjectiles(LivingEntity entity, ItemStack crossbowStack, ItemStack ammoStack, boolean p_220023_3_, boolean p_220023_4_) {
        ItemStack itemstack;
        boolean flag;
        if (ammoStack.func_190926_b()) {
            return false;
        }
        boolean bl = flag = p_220023_4_ && ammoStack.func_77973_b() instanceof ArrowItem;
        if (!(flag || p_220023_4_ || p_220023_3_)) {
            itemstack = ammoStack.func_77979_a(1);
            if (ammoStack.func_190926_b() && entity instanceof PlayerEntity) {
                ((PlayerEntity)entity).field_71071_by.func_184437_d(ammoStack);
            }
        } else {
            itemstack = ammoStack.func_77946_l();
        }
        this.writeProjectile(crossbowStack, itemstack);
        return true;
    }

    public boolean isLoaded(ItemStack stack) {
        CompoundNBT compoundnbt = stack.func_77978_p();
        return compoundnbt != null && compoundnbt.func_74767_n("Charged");
    }

    public void setLoaded(ItemStack stack, boolean chargedIn) {
        CompoundNBT compoundnbt = stack.func_196082_o();
        compoundnbt.func_74757_a("Charged", chargedIn);
    }

    private ListNBT getProjectilesNBT(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            return this.getProjectilesNBT(itemStack.func_77978_p());
        }
        return new ListNBT();
    }

    private ListNBT getProjectilesNBT(CompoundNBT nbt) {
        if (nbt.func_150297_b("ChargedProjectiles", 9)) {
            return nbt.func_150295_c("ChargedProjectiles", 10);
        }
        return new ListNBT();
    }

    private void writeProjectile(ItemStack crossbowStack, ItemStack projectileStack) {
        CompoundNBT crossbowTag = crossbowStack.func_196082_o();
        ListNBT list = this.getProjectilesNBT(crossbowTag);
        CompoundNBT projectileTag = new CompoundNBT();
        projectileStack.func_77955_b(projectileTag);
        list.add((Object)projectileTag);
        crossbowTag.func_218657_a("ChargedProjectiles", (INBT)list);
    }

    private ItemStack getFirstProjectile(ItemStack itemStack) {
        ListNBT projectiles = this.getProjectilesNBT(itemStack);
        if (projectiles.size() > 0) {
            return ItemStack.func_199557_a((CompoundNBT)projectiles.func_150305_b(0));
        }
        return ItemStack.field_190927_a;
    }

    private List<ItemStack> getProjectiles(ItemStack itemStack) {
        ArrayList result = Lists.newArrayList();
        ListNBT projectileTags = this.getProjectilesNBT(itemStack);
        for (int i = 0; i < projectileTags.size(); ++i) {
            CompoundNBT stackNbt = projectileTags.func_150305_b(i);
            result.add(ItemStack.func_199557_a((CompoundNBT)stackNbt));
        }
        return result;
    }

    private List<ItemStack> takeProjectiles(ItemStack itemStack, int count) {
        ListNBT nbtList = this.getProjectilesNBT(itemStack);
        int size = Math.min(nbtList.size(), count);
        ArrayList<ItemStack> result = new ArrayList<ItemStack>(size);
        for (int i = 0; i < size; ++i) {
            CompoundNBT stackNbt = nbtList.func_150305_b(0);
            nbtList.remove(0);
            result.add(ItemStack.func_199557_a((CompoundNBT)stackNbt));
        }
        return result;
    }

    public boolean hasProjectiles(ItemStack stack, Item ammoItem) {
        return this.getProjectiles(stack).stream().anyMatch(s -> s.func_77973_b() == ammoItem);
    }

    private SoundEvent getSoundEvent(float velocity) {
        if (velocity < 7.0f) {
            return SoundEvents.field_219615_bG;
        }
        if (velocity < 15.0f) {
            return SoundEvents.field_219614_bF;
        }
        if (velocity < 22.0f) {
            return SoundEvents.field_219613_bE;
        }
        return SoundEvents.field_219612_bD;
    }

    public int func_77626_a(ItemStack itemStack) {
        return 37000;
    }

    public UseAction func_77661_b(ItemStack stack) {
        if (this.isLoaded(stack)) {
            return UseAction.BOW;
        }
        return UseAction.CROSSBOW;
    }

    public boolean func_219970_i(ItemStack stack) {
        return true;
    }

    public boolean func_77645_m() {
        return true;
    }

    private String getDrawVariant(ItemStack itemStack, @Nullable LivingEntity entity) {
        float progress = this.getProgress(itemStack, entity);
        if (this.isLoaded(itemStack)) {
            return "loaded";
        }
        if (progress == 0.0f) {
            return "item";
        }
        if ((double)progress < 0.58) {
            return "draw_0";
        }
        if (progress < 1.0f) {
            return "draw_1";
        }
        return "draw_2";
    }

    private String getProjectileVariant(ItemStack itemStack) {
        ItemStack projectileStack = this.getFirstProjectile(itemStack);
        if (projectileStack.func_77973_b() instanceof FireworkRocketItem) {
            return "p1";
        }
        if (ChthonicExtractorBlock.item.equals(projectileStack.func_77973_b()) || ChthonicExtractorBlock.usedItem.equals(projectileStack.func_77973_b())) {
            return "p2";
        }
        return "p0";
    }

    private ModuleModel getProjectileModel(ItemStack itemStack) {
        ItemStack projectileStack = this.getFirstProjectile(itemStack);
        if (projectileStack.func_77973_b() instanceof FireworkRocketItem) {
            return this.fireworkModel;
        }
        if (ChthonicExtractorBlock.item.equals(projectileStack.func_77973_b()) || ChthonicExtractorBlock.usedItem.equals(projectileStack.func_77973_b())) {
            return this.extractorModel;
        }
        return this.arrowModel;
    }

    @Override
    public String getModelCacheKey(ItemStack itemStack, LivingEntity entity) {
        return super.getModelCacheKey(itemStack, entity) + ":" + this.getDrawVariant(itemStack, entity) + this.getProjectileVariant(itemStack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ImmutableList<ModuleModel> getModels(ItemStack itemStack, @Nullable LivingEntity entity) {
        String modelType = this.getDrawVariant(itemStack, entity);
        ImmutableList models = this.getAllModules(itemStack).stream().sorted(Comparator.comparing(ItemModule::getRenderLayer)).flatMap(itemModule -> Arrays.stream(itemModule.getModels(itemStack))).filter(Objects::nonNull).filter(model -> model.type.equals(modelType) || model.type.equals("static")).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf));
        if (this.isLoaded(itemStack)) {
            return ImmutableList.builder().addAll((Iterable)models).add((Object)this.getProjectileModel(itemStack)).build();
        }
        return models;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiModuleOffsets getMajorGuiOffsets() {
        return majorOffsets;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiModuleOffsets getMinorGuiOffsets() {
        return minorOffsets;
    }
}

