/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.holo;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.gui.GuiModuleOffsets;
import se.mickelus.tetra.items.TetraItemGroup;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.items.modular.ModularItem;
import se.mickelus.tetra.items.modular.impl.holo.gui.HoloGui;
import se.mickelus.tetra.items.modular.impl.holo.gui.scan.ScannerOverlayGui;
import se.mickelus.tetra.module.schematic.RemoveSchematic;
import se.mickelus.tetra.network.PacketHandler;
import se.mickelus.tetra.properties.TetraAttributes;

public class ModularHolosphereItem
extends ModularItem {
    private static final String unlocalizedName = "holo";
    public static final String coreKey = "holo/core";
    public static final String frameKey = "holo/frame";
    public static final String attachmentAKey = "holo/attachment_0";
    public static final String attachmentBKey = "holo/attachment_1";
    private static final GuiModuleOffsets majorOffsets = new GuiModuleOffsets(-14, 0, -14, 18, 4, 0, 4, 18);
    @ObjectHolder(value="tetra:holo")
    public static ModularHolosphereItem instance;

    public ModularHolosphereItem() {
        super(new Item.Properties().func_200917_a(1).func_200916_a((ItemGroup)TetraItemGroup.instance).func_234689_a_());
        this.canHone = false;
        this.setRegistryName(unlocalizedName);
        this.majorModuleKeys = new String[]{coreKey, frameKey, attachmentAKey, attachmentBKey};
        this.minorModuleKeys = new String[0];
        this.requiredModules = new String[]{coreKey, frameKey};
    }

    @Override
    public void init(PacketHandler packetHandler) {
        super.init(packetHandler);
        DataManager.synergyData.onReload(() -> {
            this.synergies = DataManager.instance.getSynergyData("holo/");
        });
        RemoveSchematic.registerRemoveSchematics(this);
    }

    @Override
    public void clientInit() {
        super.clientInit();
        MinecraftForge.EVENT_BUS.register((Object)new ScannerOverlayGui());
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            ItemStack itemStack = new ItemStack((IItemProvider)this);
            IModularItem.putModuleInSlot(itemStack, coreKey, coreKey, "frame/dim");
            IModularItem.putModuleInSlot(itemStack, frameKey, frameKey, "core/ancient");
            items.add((Object)itemStack);
        }
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("item.tetra.holo.tooltip1").func_240699_a_(TextFormatting.GRAY));
        tooltip.add((ITextComponent)new StringTextComponent(" "));
        if (ScannerOverlayGui.instance != null && ScannerOverlayGui.instance.isAvailable()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tetra.holo.scan.status", new Object[]{ScannerOverlayGui.instance.getStatus()}).func_240699_a_(TextFormatting.GRAY));
            tooltip.add((ITextComponent)new StringTextComponent(" "));
            tooltip.add((ITextComponent)new TranslationTextComponent("tetra.holo.scan.snooze"));
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("item.tetra.holo.tooltip2"));
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (world.field_72995_K) {
            if (player.func_213453_ef() && ScannerOverlayGui.instance.isAvailable()) {
                ScannerOverlayGui.instance.toggleSnooze();
            } else {
                this.showGui();
            }
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)player.func_184586_b(hand));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void showGui() {
        HoloGui gui = HoloGui.getInstance();
        Minecraft.func_71410_x().func_147108_a((Screen)gui);
        gui.onShow();
    }

    @Override
    public GuiModuleOffsets getMajorGuiOffsets() {
        return majorOffsets;
    }

    public double getCooldownBase(ItemStack itemStack) {
        return Math.max(0.0, this.getAttributeValue(itemStack, (Attribute)TetraAttributes.abilityCooldown.get()));
    }
}

